/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.client.rendering;

import CoroUtil.config.ConfigCoroUtil;
import extendedrenderer.particle.entity.EntityRotFX;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.api.weather.AbstractWeatherRenderer;
import net.mrbt0907.weather2.api.weather.WeatherEnum;
import net.mrbt0907.weather2.client.NewSceneEnhancer;
import net.mrbt0907.weather2.client.entity.particle.ExtendedEntityRotFX;
import net.mrbt0907.weather2.client.weather.WeatherManagerClient;
import net.mrbt0907.weather2.config.ConfigParticle;
import net.mrbt0907.weather2.config.ConfigStorm;
import net.mrbt0907.weather2.registry.ParticleRegistry;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.util.WeatherUtil;
import net.mrbt0907.weather2.util.WeatherUtilBlock;
import net.mrbt0907.weather2.weather.storm.StormObject;

public class April24StormRenderer
extends AbstractWeatherRenderer {
    @SideOnly(value=Side.CLIENT)
    public List<EntityRotFX> listParticlesCloud = new ArrayList<EntityRotFX>();
    @SideOnly(value=Side.CLIENT)
    public List<EntityRotFX> listParticlesFunnel;
    @SideOnly(value=Side.CLIENT)
    public List<EntityRotFX> listParticlesMeso;
    @SideOnly(value=Side.CLIENT)
    public List<EntityRotFX> listParticlesGround = new ArrayList<EntityRotFX>();
    @SideOnly(value=Side.CLIENT)
    public List<EntityRotFX> listParticlesRain = new ArrayList<EntityRotFX>();
    public ExtendedEntityRotFX april = null;
    public int particleLimitCloud;
    public int particleLimitFunnel;
    public int particleLimitGround;
    public int particleLimitRain;
    public int particleLimitMeso;

    public April24StormRenderer(StormObject system) {
        super(system);
        this.listParticlesFunnel = new ArrayList<EntityRotFX>();
        this.listParticlesMeso = new ArrayList<EntityRotFX>();
    }

    @Override
    public void onTick(WeatherManagerClient manager) {
        int i;
        int i2;
        if (!(this.system instanceof StormObject)) {
            return;
        }
        StormObject storm = (StormObject)this.system;
        EntityPlayerSP entP = Minecraft.func_71410_x().field_71439_g;
        IBlockState state = ConfigCoroUtil.optimizedCloudRendering ? Blocks.field_150350_a.func_176223_P() : Weather2.clientChunkUtil.getBlockState(manager.getWorld(), (int)storm.pos_funnel_base.posX, (int)storm.pos_funnel_base.posY - 1, (int)storm.pos_funnel_base.posZ);
        Material material = state.func_185904_a();
        double maxRenderDistance = (double)NewSceneEnhancer.instance().renderDistance + 64.0;
        float sizeCloudMult = Math.min(Math.max((float)storm.size * 0.0011f, 0.45f) * (float)ConfigParticle.particle_scale_mult, (float)storm.getLayerHeight() * 0.01f);
        float sizeFunnelMult = Math.min(Math.max(storm.funnelSize * 0.008f, 0.35f) * (float)ConfigParticle.particle_scale_mult, (float)storm.getLayerHeight() * 0.006f);
        float sizeOtherMult = Math.min(Math.max((float)storm.size * 0.003f, 0.45f) * (float)ConfigParticle.particle_scale_mult, (float)storm.getLayerHeight() * 0.035f);
        float heightMult = (float)storm.getLayerHeight() * 0.0053f;
        float rotationMult = Math.max(heightMult * 0.55f, 1.0f);
        float r = -1.0f;
        float g = -1.0f;
        float b = -1.0f;
        if (ConfigParticle.enable_tornado_block_colors) {
            if (!ConfigCoroUtil.optimizedCloudRendering && state.func_177230_c().equals(Blocks.field_150350_a)) {
                state = storm.isSpout ? Blocks.field_150355_j.func_176223_P() : Blocks.field_150346_d.func_176223_P();
                material = state.func_185904_a();
            }
            if (material.equals(Material.field_151578_c) || material.equals(Material.field_151577_b) || material.equals(Material.field_151584_j) || material.equals(Material.field_151585_k)) {
                r = 0.3f;
                g = 0.25f;
                b = 0.15f;
            } else if (material.equals(Material.field_151595_p)) {
                r = 0.5f;
                g = 0.45f;
                b = 0.35f;
            } else if (material.equals(Material.field_151597_y)) {
                r = 0.5f;
                g = 0.5f;
                b = 0.7f;
            } else if (material.equals(Material.field_151586_h) || storm.isSpout) {
                r = 0.3f;
                g = 0.35f;
                b = 0.7f;
            } else if (material.equals(Material.field_151587_i)) {
                r = 1.0f;
                g = 0.45f;
                b = 0.35f;
            }
        }
        int delay = Math.max(1, (int)(100.0f / (float)storm.size));
        int loopSize = 1;
        int extraSpawning = 0;
        if (storm.isSevere()) {
            loopSize += 4;
            extraSpawning = (int)Math.min(storm.funnelSize * 2.375f, 1000.0f);
        }
        Random rand = new Random();
        Maths.Vec3 playerAdjPos = new Maths.Vec3(entP.field_70165_t, storm.pos.posY, entP.field_70161_v);
        if (ConfigCoroUtil.optimizedCloudRendering) {
            boolean isStorm = storm.stage >= WeatherEnum.Stage.RAIN.getStage();
            int height = storm.getLayerHeight() + (isStorm ? -5 : 0);
            int size = (int)((double)storm.size * 1.2);
            float finalBright = isStorm ? 0.5f : 0.75f;
            for (int i3 = 0; i3 < loopSize && this.shouldSpawn(0); ++i3) {
                Maths.Vec3 tryPos = new Maths.Vec3(storm.pos.posX + (double)Maths.random(size), (double)height, storm.pos.posZ + (double)Maths.random(size));
                ExtendedEntityRotFX particle = this.spawnParticle(tryPos.posX, tryPos.posY, tryPos.posZ, 0);
                if (particle != null) {
                    if (i3 != 0) {
                        float radStart;
                        double rotPos = i3 - 1;
                        particle.rotationAroundCenter = radStart = (float)(45.0 * rotPos);
                    }
                    particle.setColor(finalBright, finalBright, finalBright);
                    particle.setScale(400.0f * sizeCloudMult);
                    particle.func_187114_a(120);
                    this.listParticlesCloud.add(particle);
                    continue;
                }
                break;
            }
        } else if (manager.getWorld().func_82737_E() % (long)(delay + ConfigParticle.cloud_particle_delay) == 0L) {
            for (i2 = 0; i2 < loopSize && this.shouldSpawn(0); ++i2) {
                if (!((float)this.listParticlesCloud.size() < (float)(storm.size + extraSpawning) / 1.0f)) continue;
                double spawnRad = (double)storm.size * 1.2;
                Maths.Vec3 tryPos = new Maths.Vec3(storm.pos.posX + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad, (double)storm.getLayerHeight() + rand.nextDouble() * 40.0 + (storm.stage >= WeatherEnum.Stage.RAIN.getStage() ? 30.0 : 60.0), storm.pos.posZ + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad);
                if (!(tryPos.distanceSq(playerAdjPos) < maxRenderDistance) || !(storm.pos.distanceSq(tryPos) > 200.0) && storm.stormType != 0 || storm.getAvoidAngleIfTerrainAtOrAheadOfPosition(storm.getAngle(), tryPos) != 0.0f) continue;
                float finalBright = Math.min(0.8f, 0.6f + rand.nextFloat() * 0.2f) + (storm.stage >= WeatherEnum.Stage.RAIN.getStage() ? -0.3f : 0.0f);
                ExtendedEntityRotFX particle = this.spawnParticle(tryPos.posX, tryPos.posY, tryPos.posZ, 0, storm.stage <= WeatherEnum.Stage.RAIN.getStage() ? ParticleRegistry.cloud256_light : ParticleRegistry.cloud256);
                if (particle != null) {
                    particle.setColor(finalBright, finalBright, finalBright);
                    if (storm.isSevere() && storm.isFirenado) {
                        particle.func_187117_a(ParticleRegistry.cloud256_fire);
                        particle.setColor(1.0f, 1.0f, 1.0f);
                    }
                    particle.rotationPitch = Maths.random(70.0f, 110.0f);
                    particle.setScale(1250.0f * sizeCloudMult);
                    this.listParticlesCloud.add(particle);
                    continue;
                }
                break;
            }
        }
        if (ConfigParticle.enable_tornado_debris && !ConfigCoroUtil.optimizedCloudRendering && storm.stormType == StormObject.StormType.LAND.ordinal() && storm.stage > WeatherEnum.Stage.SEVERE.getStage() && r >= 0.0f && !material.func_76224_d() && manager.getWorld().func_82737_E() % (long)(delay + ConfigParticle.ground_debris_particle_delay) == 0L) {
            for (i2 = 0; i2 < 16 && this.shouldSpawn(2); ++i2) {
                ExtendedEntityRotFX particle;
                double spawnRad = storm.funnelSize;
                Maths.Vec3 tryPos = new Maths.Vec3(storm.pos_funnel_base.posX + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad, storm.pos_funnel_base.posY, storm.pos_funnel_base.posZ + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad);
                double distance = tryPos.distanceSq(playerAdjPos);
                if (!(distance < maxRenderDistance) || !(distance < 64.0)) continue;
                int groundY = WeatherUtilBlock.getPrecipitationHeightSafe(manager.getWorld(), new BlockPos((int)tryPos.posX, 0, (int)tryPos.posZ)).func_177956_o();
                if (WeatherUtil.isAprilFoolsDay()) {
                    particle = this.spawnParticle(tryPos.posX, groundY, tryPos.posZ, 1, extendedrenderer.particle.ParticleRegistry.potato);
                } else {
                    int reee = Maths.random(3);
                    TextureAtlasSprite sprite = reee == 1 ? extendedrenderer.particle.ParticleRegistry.debris_1 : (reee == 2 ? extendedrenderer.particle.ParticleRegistry.debris_2 : (reee == 3 ? extendedrenderer.particle.ParticleRegistry.debris_3 : extendedrenderer.particle.ParticleRegistry.leaf));
                    particle = this.spawnParticle(tryPos.posX, groundY, tryPos.posZ, 1, sprite);
                }
                if (particle == null) break;
                particle.setColor(r, g, b);
                particle.setTicksFadeInMax(8.0f);
                particle.setTicksFadeOutMax(80.0f);
                particle.setGravity(0.25f);
                particle.func_187114_a(160);
                particle.setScale(7.0f);
                particle.rotationYaw = rand.nextInt(360);
                particle.rotationPitch = 30.0f + (float)rand.nextInt(60);
                particle.setMotionY(0.9);
                this.listParticlesGround.add(particle);
            }
        }
        delay = 1;
        loopSize = 3 + (storm.funnelSize > 300.0f ? 4 : (int)(storm.funnelSize / 80.0f));
        double spawnRad = storm.funnelSize * 0.01f;
        if (storm.stage >= WeatherEnum.Stage.TORNADO.getStage() + 1) {
            spawnRad *= 48.25;
        }
        if ((storm.isDeadly() && storm.stormType == 0 || storm.isSpout) && manager.getWorld().func_82737_E() % (long)(delay + ConfigParticle.funnel_particle_delay) == 0L) {
            for (int i4 = 0; i4 < loopSize && this.shouldSpawn(1); ++i4) {
                Maths.Vec3 tryPos = new Maths.Vec3(storm.pos_funnel_base.posX + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad, storm.pos.posY, storm.pos_funnel_base.posZ + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad);
                if (!(tryPos.distanceSq(playerAdjPos) < maxRenderDistance)) continue;
                ExtendedEntityRotFX particle = !storm.isFirenado ? this.spawnParticle(tryPos.posX, storm.pos_funnel_base.posY, tryPos.posZ, 2, ParticleRegistry.cloud256) : this.spawnParticle(tryPos.posX, storm.pos_funnel_base.posY, tryPos.posZ, 2, ParticleRegistry.cloud256_fire);
                if (particle == null) break;
                particle.func_187114_a(120 + (storm.stage - 1) * 10 + rand.nextInt(100));
                particle.rotationYaw = rand.nextInt(360);
                float finalBright = Math.min(0.6f, 0.4f + rand.nextFloat() * 0.2f);
                if (storm.stage == WeatherEnum.Stage.SEVERE.getStage()) {
                    particle.setScale(100.0f * sizeFunnelMult * heightMult);
                } else {
                    particle.setScale(450.0f * sizeFunnelMult * heightMult);
                }
                if (r >= 0.0f) {
                    particle.setColor(r, g, b);
                    particle.setFinalColor(0.0f, finalBright, finalBright, finalBright);
                    particle.setColorFade(0.75f);
                } else {
                    particle.setColor(finalBright, finalBright, finalBright);
                }
                if (storm.isFirenado) {
                    particle.func_70538_b(1.0f, 1.0f, 1.0f);
                    particle.setScale(particle.getScale() * 0.7f);
                }
                this.listParticlesFunnel.add(particle);
            }
        }
        if (this.april == null) {
            if (storm.stage > WeatherEnum.Stage.SEVERE.getStage()) {
                double posY = storm.pos.posY;
                posY -= storm.pos_funnel_base.posY;
                posY = storm.pos.posY - posY * 0.75;
                this.april = this.spawnParticle(storm.pos.posX, posY, storm.pos.posZ, 2, ParticleRegistry.concerned);
                this.april.facePlayer = true;
                this.april.setColor(1.0f, 1.0f, 1.0f);
                this.april.setFinalColor(1.0f, 1.0f, 1.0f, 1.0f);
                this.april.setColorFade(1.0f);
                this.april.facePlayerYaw = true;
                this.april.func_187114_a(999999);
                this.april.setAge(20000);
                this.april.setScale(100.0f);
                this.april.field_82339_as = 0.75f;
            }
        } else {
            this.april.field_82339_as = 0.75f;
            double posY = storm.pos.posY;
            posY -= storm.pos_funnel_base.posY;
            posY = storm.pos.posY - posY * 0.75;
            this.april.setAge(0);
            this.april.func_187109_b(storm.pos.posX, posY, storm.pos.posZ);
            this.april.setScale(MathHelper.func_76131_a((float)(storm.funnelSize * 2.0f), (float)64.0f, (float)256.0f));
            if (storm.stage <= WeatherEnum.Stage.SEVERE.getStage() || this.april.field_187133_m) {
                this.april.func_187112_i();
                this.april = null;
            }
        }
        if (ConfigParticle.enable_distant_downfall && storm.ticks % 20L == 0L && ConfigParticle.distant_downfall_particle_rate > 0.0 && this.listParticlesRain.size() < 1000 && storm.stage > WeatherEnum.Stage.THUNDER.getStage() && storm.isRaining() && storm.temperature > 0.0f) {
            int particleCount = (int)Math.min(Math.ceil((double)(storm.rain * (float)storm.stage) * ConfigParticle.distant_downfall_particle_rate * (double)0.005f), 50.0);
            for (int i5 = 0; i5 < particleCount && this.shouldSpawn(3); ++i5) {
                double spawnRad2 = storm.size;
                Maths.Vec3 tryPos = new Maths.Vec3(storm.pos.posX + rand.nextDouble() * spawnRad2 - rand.nextDouble() * spawnRad2, storm.pos.posY + (double)rand.nextInt(50), storm.pos.posZ + rand.nextDouble() * spawnRad2 - rand.nextDouble() * spawnRad2);
                if (!(tryPos.distanceSq(playerAdjPos) < maxRenderDistance)) continue;
                float finalBright = Math.min(0.7f, 0.5f + rand.nextFloat() * 0.2f) + (storm.stage >= WeatherEnum.Stage.RAIN.getStage() ? -0.2f : 0.0f);
                ExtendedEntityRotFX particle = this.spawnParticle(tryPos.posX, tryPos.posY, tryPos.posZ, 2, ParticleRegistry.distant_downfall);
                if (particle == null) break;
                particle.func_187114_a(200 + rand.nextInt(100));
                particle.setScale(550.0f * sizeOtherMult);
                particle.func_82338_g(0.0f);
                particle.setColor(finalBright, finalBright, finalBright);
                particle.facePlayer = false;
                this.listParticlesRain.add(particle);
            }
        }
        for (i = 0; i < this.listParticlesFunnel.size(); ++i) {
            EntityRotFX ent = this.listParticlesFunnel.get(i);
            if (!ent.func_187113_k() || ent.getPosY() > (double)(storm.getLayerHeight() + 200)) {
                ent.func_187112_i();
                this.listParticlesFunnel.remove(ent);
                continue;
            }
            double var16 = storm.pos.posX - ent.getPosX();
            double var18 = storm.pos.posZ - ent.getPosZ();
            ent.rotationYaw = (float)(Maths.fastATan2(var18, var16) * 180.0 / Math.PI) - 90.0f;
            ent.rotationYaw += (float)(ent.getEntityId() % 90);
            ent.rotationPitch = -30.0f;
            storm.spinEntity(ent);
        }
        if (storm.getStage() > WeatherEnum.Stage.THUNDER.getStage() && manager.getWorld().func_82737_E() % (long)(delay + ConfigParticle.cloud_particle_delay) == 0L) {
            for (i = 0; i < loopSize && this.shouldSpawn(4); ++i) {
                if (!((float)this.listParticlesMeso.size() < (float)(storm.size + extraSpawning) / 1.0f)) continue;
                double stormRad = (double)storm.size * 1.2;
                Maths.Vec3 tryPos = new Maths.Vec3(storm.pos.posX + rand.nextDouble() * stormRad - rand.nextDouble() * stormRad, (double)storm.getLayerHeight() + rand.nextDouble() * 40.0, storm.pos.posZ + rand.nextDouble() * stormRad - rand.nextDouble() * stormRad);
                if (!(tryPos.distanceSq(playerAdjPos) < maxRenderDistance) || !(storm.stormType == 1 && storm.pos.distanceSq(tryPos) > 350.0) && storm.stormType != 0 || storm.getAvoidAngleIfTerrainAtOrAheadOfPosition(storm.getAngle(), tryPos) != 0.0f) continue;
                float finalBright = Math.min(0.8f, 0.6f + rand.nextFloat() * 0.2f - 0.3f);
                ExtendedEntityRotFX particle = this.spawnParticle(tryPos.posX, tryPos.posY, tryPos.posZ, 0, ParticleRegistry.cloud256_meso);
                if (particle == null) break;
                particle.setColor(finalBright, finalBright, finalBright);
                if (storm.isFirenado) {
                    particle.func_187117_a(ParticleRegistry.cloud256_fire);
                    particle.setColor(1.0f, 1.0f, 1.0f);
                }
                particle.rotationPitch = Maths.random(70.0f, 110.0f);
                particle.setScale(1250.0f * sizeCloudMult);
                this.listParticlesMeso.add(particle);
            }
        }
        for (i = 0; i < this.listParticlesMeso.size(); ++i) {
            EntityRotFX ent = this.listParticlesMeso.get(i);
            if (!ent.func_187113_k()) {
                ent.func_187112_i();
                this.listParticlesMeso.remove(ent);
                continue;
            }
            double speed = storm.spin + rand.nextDouble() * 0.04 * (double)rotationMult;
            double curSpeed = Math.sqrt(ent.getMotionX() * ent.getMotionX() + ent.getMotionY() * ent.getMotionY() + ent.getMotionZ() * ent.getMotionZ());
            if (storm.stormType == 1) {
                speed *= 2.0;
            }
            double vecX = ent.getPosX() - storm.pos.posX;
            double vecZ = ent.getPosZ() - storm.pos.posZ;
            float angle = (float)(Maths.fastATan2(vecZ, vecX) * 180.0 / Math.PI);
            double curDist = 1000.0;
            angle = (float)((double)angle + speed * 2.0);
            angle = (float)((double)angle - (double)(ent.getEntityId() % 10) * 3.0);
            angle += (float)(rand.nextInt(10) - rand.nextInt(10));
            if (ent.field_187127_g > (double)storm.getLayerHeight() + 10.0) {
                ent.func_187109_b(ent.field_187126_f, (double)storm.getLayerHeight() + 10.0, ent.field_187128_h);
            }
            if (storm.stage >= WeatherEnum.Stage.TORNADO.getStage()) {
                if (storm.stormType == StormObject.StormType.WATER.ordinal()) {
                    angle += (float)(30 + ent.getEntityId() % 5 * 4);
                    if (curDist > (double)(150 + (storm.stage - WeatherEnum.Stage.TORNADO.getStage() + 1) * 30)) {
                        angle += 10.0f;
                    }
                } else {
                    angle += (float)(30 + ent.getEntityId() % 5 * 4);
                }
            } else if (curDist > 150.0) {
                angle += (float)(10 + ent.getEntityId() % 5 * 4);
            }
            double var16 = storm.pos.posX - ent.getPosX();
            double var18 = storm.pos.posZ - ent.getPosZ();
            ent.rotationYaw = (float)(Maths.fastATan2(var18, var16) * 180.0 / Math.PI) - 90.0f;
            ent.rotationPitch = -30.0f - (float)(ent.getEntityId() % 10);
            ent.setScale((storm.stormType == StormObject.StormType.WATER.ordinal() ? 400.0f : 900.0f) * sizeCloudMult);
            ent.func_187117_a(ParticleRegistry.cloud256_meso);
            if (!(curSpeed < speed * 20.0)) continue;
            ent.setMotionX(ent.getMotionX() + -Maths.fastSin(Math.toRadians(angle)) * speed);
            ent.setMotionZ(ent.getMotionZ() + Maths.fastCos(Math.toRadians(angle)) * speed);
        }
        for (i = 0; i < this.listParticlesCloud.size(); ++i) {
            EntityRotFX ent = this.listParticlesCloud.get(i);
            if (!ent.func_187113_k() || storm.stormType == StormObject.StormType.WATER.ordinal() && ent.getDistance(storm.pos.posX, ent.field_187127_g, storm.pos.posZ) < (double)storm.funnelSize) {
                ent.func_187112_i();
                this.listParticlesCloud.remove(ent);
                continue;
            }
            double curSpeed = Math.sqrt(ent.getMotionX() * ent.getMotionX() + ent.getMotionY() * ent.getMotionY() + ent.getMotionZ() * ent.getMotionZ());
            double curDist = 10.0;
            if (storm.isSevere()) {
                double speed = storm.spin + rand.nextDouble() * 0.04 * (double)rotationMult;
                double distt = Math.max((double)ConfigStorm.max_storm_size, (double)storm.funnelSize + 20.0);
                if (storm.stormType == 1) {
                    speed *= 2.0;
                    distt *= 2.0;
                }
                double vecX = ent.getPosX() - storm.pos.posX;
                double vecZ = ent.getPosZ() - storm.pos.posZ;
                float angle = (float)(Maths.fastATan2(vecZ, vecX) * 180.0 / Math.PI);
                angle = (float)((double)angle + speed * 10.0);
                angle = (float)((double)angle - (double)(ent.getEntityId() % 10) * 3.0);
                angle += (float)(rand.nextInt(10) - rand.nextInt(10));
                if (curDist > distt) {
                    angle += 40.0f;
                }
                ent.rotationPitch = (float)(90.0 - 90.0 * Math.min(ent.getPosY() / (double)((float)storm.getLayerHeight() + ent.getScale() * 0.75f), 1.0));
                if (ConfigParticle.enable_extended_render_distance) {
                    ent.setScale(1000.0f * sizeCloudMult);
                }
                if (curSpeed < speed * 20.0) {
                    ent.setMotionX(ent.getMotionX() + -Maths.fastSin(Math.toRadians(angle)) * speed);
                    ent.setMotionZ(ent.getMotionZ() + Maths.fastCos(Math.toRadians(angle)) * speed);
                }
            } else {
                float cloudMoveAmp = 0.1f * (float)(1 + storm.layer);
                float speed = storm.getSpeed() * cloudMoveAmp;
                float angle = storm.getAngle();
                if (manager.getWorld().func_82737_E() % 40L == 0L) {
                    ent.avoidTerrainAngle = storm.getAvoidAngleIfTerrainAtOrAheadOfPosition(angle, new Maths.Vec3(ent.getPos()));
                }
                angle += ent.avoidTerrainAngle;
                if (ent.avoidTerrainAngle != 0.0f) {
                    speed = (float)((double)speed * 0.5);
                }
                if (curSpeed < (double)speed * 1.0) {
                    ent.setMotionX(ent.getMotionX() + -Maths.fastSin(Math.toRadians(angle)) * (double)speed);
                    ent.setMotionZ(ent.getMotionZ() + Maths.fastCos(Math.toRadians(angle)) * (double)speed);
                }
            }
            float dropDownSpeedMax = 0.5f;
            if (storm.stormType == 1 || storm.stage > 8) {
                dropDownSpeedMax = 1.9f;
            }
            if (ent.getMotionY() < (double)(-dropDownSpeedMax)) {
                ent.setMotionY((double)(-dropDownSpeedMax));
            }
            if (!(ent.getMotionY() > (double)dropDownSpeedMax)) continue;
            ent.setMotionY((double)dropDownSpeedMax);
        }
        for (i = 0; i < this.listParticlesRain.size(); ++i) {
            EntityRotFX ent = this.listParticlesRain.get(i);
            if (!ent.func_187113_k()) {
                this.listParticlesRain.remove(ent);
            }
            if (ent.field_187130_j > (double)(-heightMult)) {
                ent.field_187130_j -= 0.1;
            }
            double speed = Math.sqrt(ent.getMotionX() * ent.getMotionX() + ent.getMotionY() * ent.getMotionY() + ent.getMotionZ() * ent.getMotionZ());
            double spin = storm.spin + (double)0.04f;
            double vecX = ent.getPosX() - storm.pos.posX;
            double vecZ = ent.getPosZ() - storm.pos.posZ;
            float angle = (float)(Maths.fastATan2(vecZ, vecX) * 180.0 / Math.PI);
            ent.rotationPitch = 0.0f;
            ent.rotationYaw = angle + 90.0f;
            if (ent.getAlphaF() < 0.01f) {
                ent.func_82338_g(ent.getAlphaF() + 0.01f);
            }
            if (!(speed < spin * 15.0 * (double)rotationMult)) continue;
            ent.setMotionX(ent.getMotionX() + -Maths.fastSin(Math.toRadians(angle)) * spin);
            ent.setMotionZ(ent.getMotionZ() + Maths.fastCos(Math.toRadians(angle)) * spin);
        }
        for (i = 0; i < this.listParticlesGround.size(); ++i) {
            EntityRotFX ent = this.listParticlesGround.get(i);
            if (!ent.func_187113_k()) {
                this.listParticlesGround.remove(ent);
                continue;
            }
            storm.spinEntity(ent);
        }
        if (storm.strength != 100.0f) {
            storm.strength = 100.0f;
        }
    }

    @Override
    public void onParticleLimitRefresh(WeatherManagerClient manager, int newParticleLimit) {
        this.particleLimitCloud = (int)((float)newParticleLimit * 0.05f) - 1;
        this.particleLimitGround = (int)((float)newParticleLimit * 0.25f);
        this.particleLimitRain = (int)((float)newParticleLimit * 0.1f);
        this.particleLimitFunnel = (int)((float)newParticleLimit * 0.5f);
        this.particleLimitMeso = (int)((float)newParticleLimit * 0.1f);
    }

    @Override
    public void cleanupRenderer() {
        this.listParticlesCloud.clear();
        this.listParticlesFunnel.clear();
        this.listParticlesGround.clear();
        this.listParticlesRain.clear();
        this.listParticlesMeso.clear();
        if (this.april != null) {
            this.april.func_187112_i();
        }
        this.april = null;
    }

    private boolean shouldSpawn(int type) {
        switch (type) {
            case 0: {
                return this.listParticlesCloud.size() < this.particleLimitCloud;
            }
            case 1: {
                return this.listParticlesFunnel.size() < this.particleLimitFunnel;
            }
            case 2: {
                return this.listParticlesGround.size() < this.particleLimitGround;
            }
            case 3: {
                return this.listParticlesRain.size() < this.particleLimitRain;
            }
            case 4: {
                return this.listParticlesMeso.size() < this.particleLimitMeso;
            }
        }
        return false;
    }

    @Override
    public List<String> onDebugInfo() {
        ArrayList<String> debugInfo = new ArrayList<String>();
        debugInfo.add("Default Renderer - Version 2.0");
        debugInfo.add("");
        debugInfo.add("Cloud Particles: " + this.listParticlesCloud.size() + "/" + this.particleLimitCloud);
        debugInfo.add("Funnel Particles: " + this.listParticlesFunnel.size() + "/" + this.particleLimitFunnel);
        debugInfo.add("Ground Particles: " + this.listParticlesGround.size() + "/" + this.particleLimitGround);
        debugInfo.add("Rain Particles: " + this.listParticlesRain.size() + "/" + this.particleLimitRain);
        return debugInfo;
    }
}

