/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.client.gui.elements;

import java.util.UUID;
import net.mrbt0907.weather2.api.weather.IWeatherDetectable;
import net.mrbt0907.weather2.api.weather.IWeatherStaged;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.weather.storm.FrontObject;
import net.mrbt0907.weather2.weather.storm.SandstormObject;
import net.mrbt0907.weather2.weather.storm.StormObject;

public class GuiRadarObject {
    public String name;
    public String typeName;
    public UUID uuid;
    public Maths.Vec3 pos;
    public int stage;
    public int type;
    public float size;
    public float angle;
    public float motion;
    public boolean isDying;
    public boolean isRaining;
    public boolean isHailing;

    public GuiRadarObject(IWeatherDetectable wo) {
        this.name = wo.getName();
        this.typeName = wo.getTypeName();
        this.uuid = wo.getUUID();
        this.pos = wo.getPos();
        this.isDying = wo.isDying();
        this.size = 0.0f;
        this.angle = wo.getAngle();
        this.motion = wo.getSpeed();
        if (wo instanceof IWeatherStaged) {
            this.stage = wo.getStage();
        }
        if (wo instanceof FrontObject) {
            this.type = 0;
        } else if (wo instanceof StormObject) {
            this.type = ((StormObject)wo).stormType == 0 ? 1 : 2;
            this.isRaining = ((StormObject)wo).hasDownfall();
            this.isHailing = ((StormObject)wo).isHailing();
            this.size = ((StormObject)wo).funnelSize;
        } else if (wo instanceof SandstormObject) {
            SandstormObject sso = (SandstormObject)wo;
            this.isDying = !sso.isFrontGrowing;
            this.type = 3;
        }
    }
}

