/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.mrbt0907.weather2.api.WindReader;
import net.mrbt0907.weather2.api.weather.AbstractWeatherRenderer;
import net.mrbt0907.weather2.client.event.ClientTickHandler;
import net.mrbt0907.weather2.client.weather.WeatherManagerClient;
import net.mrbt0907.weather2.config.ConfigParticle;
import net.mrbt0907.weather2.item.ItemSensor;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.util.WeatherUtil;
import net.mrbt0907.weather2.util.WeatherUtilGui;
import org.lwjgl.opengl.GL11;

public class GuiWeather
extends WeatherUtilGui {
    private final Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
        WeatherManagerClient manager;
        if (!event.getType().equals((Object)RenderGameOverlayEvent.ElementType.HOTBAR) || this.mc.field_71441_e == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)2977);
        GL11.glBlendFunc((int)770, (int)771);
        if (this.mc.field_71439_g != null && (manager = ClientTickHandler.weatherManager) != null) {
            ItemStack stack = this.mc.field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
            if (ConfigParticle.enable_debug_renderer) {
                for (int i = 0; i < AbstractWeatherRenderer.renderDebugInfo.size(); ++i) {
                    this.func_73731_b(this.mc.field_71466_p, AbstractWeatherRenderer.renderDebugInfo.get(i), 0, 2 + 10 * i, -256);
                }
            }
            if (stack.func_77973_b() instanceof ItemSensor) {
                boolean enabled;
                ItemSensor item = (ItemSensor)stack.func_77973_b();
                NBTTagCompound nbt = stack.func_77978_p();
                boolean bl = enabled = nbt == null ? false : nbt.func_74767_n("enabled");
                if (enabled) {
                    Maths.Vec3 pos = new Maths.Vec3(this.mc.field_71439_g.field_70165_t, this.mc.field_71439_g.field_70163_u, this.mc.field_71439_g.field_70161_v);
                    BlockPos bPos = new BlockPos(this.mc.field_71439_g.field_70165_t, this.mc.field_71439_g.field_70163_u, this.mc.field_71439_g.field_70161_v);
                    switch (item.getType()) {
                        case 1: {
                            this.func_73731_b(this.mc.field_71466_p, String.format("Temperature: %.2f\u00b0F,  %.02f\u00b0C", Float.valueOf(WeatherUtil.toFahrenheit(WeatherUtil.getTemperature((World)this.mc.field_71441_e, bPos))), Float.valueOf(WeatherUtil.toCelsius(WeatherUtil.getTemperature((World)this.mc.field_71441_e, bPos)))), 0, 2, -1);
                            break;
                        }
                        case 2: {
                            this.func_73731_b(this.mc.field_71466_p, String.format("Humidity: %.02f%%", Float.valueOf(WeatherUtil.getHumidity((World)this.mc.field_71441_e, bPos) * 100.0f)), 0, 2, -1);
                            break;
                        }
                        case 3: {
                            float windAngle = WindReader.getWindAngle((World)this.mc.field_71441_e, pos);
                            float windSpeed = WindReader.getWindSpeed((World)this.mc.field_71441_e, pos);
                            this.func_73731_b(this.mc.field_71466_p, String.format("Wind Speed: %.2f Mph, %.2f Kph, %.2f M/s  (%.2f) (%s)", Float.valueOf(WeatherUtil.toMph(windSpeed)), Float.valueOf(WeatherUtil.toKph(windSpeed)), Float.valueOf(WeatherUtil.toMps(windSpeed)), Float.valueOf(windAngle), windAngle >= 315.0f ? "South" : (windAngle >= 225.0f ? "East" : (windAngle >= 135.0f ? "North" : (windAngle >= 45.0f ? "West" : "South")))), 0, 2, -1);
                        }
                    }
                }
            }
        }
        this.color(new float[0]);
        GL11.glPopMatrix();
    }
}

