/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.mrbt0907.configex.ConfigManager;
import net.mrbt0907.configex.gui.GuiConfigEditor;
import net.mrbt0907.weather2.ClientProxy;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.api.EZGuiAPI;
import net.mrbt0907.weather2.client.gui.elements.GuiButtonBoolean;
import net.mrbt0907.weather2.client.gui.elements.GuiButtonCycle;
import net.mrbt0907.weather2.config.EZConfigParser;
import net.mrbt0907.weather2.network.packets.PacketEZGUI;
import net.mrbt0907.weather2.util.TriMapEx;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.opengl.GL11;

public class GuiEZConfig
extends GuiScreen {
    public int xCenter;
    public int yCenter;
    public int xStart;
    public int yStart;
    protected int xSize = 256;
    protected int ySize = 256;
    public ResourceLocation backgroundA = new ResourceLocation("weather2:textures/gui/ez_gui_2.png");
    public ResourceLocation[] backgroundB = new ResourceLocation[0];
    public int page = 0;
    public int subPage = 0;
    public int maxSubPages = 0;
    public int maxEntries = 6;
    private boolean send = false;
    private static final String[] PAGEL = new String[]{"graphics", "system", "storms", "dimensions"};
    private static final String[] FLAGL = new String[]{"flag.op", "flag.reload"};
    public static final String PREFIX = "btn_";
    public static final String B_EXIT = "m_exit";
    public static final String B_ADVANCED = "m_advanced";
    public static final String B_NEXT = "m_next";
    public static final String B_PREVIOUS = "m_previous";
    public static final String B_GRAPHICS = "m_graphics";
    public static final String B_SYSTEM = "m_system";
    public static final String B_STORM = "m_storm";
    public static final String B_DIMENSION = "m_dimension";
    List<String> settings = new ArrayList<String>();
    public HashMap<Integer, String> buttons = new HashMap();
    public NBTTagCompound nbtSendCache;

    public GuiEZConfig() {
        EZConfigParser.nbtRealServerData = new NBTTagCompound();
        PacketEZGUI.sync();
        this.nbtSendCache = new NBTTagCompound();
        ClientProxy.clientTickHandler.op = ConfigManager.getPermissionLevel() > 3;
        EZGuiAPI.refreshOptions();
    }

    public boolean func_73868_f() {
        return true;
    }

    public void func_146281_b() {
        super.func_146281_b();
    }

    public void resetGuiElements() {
        this.buttons.clear();
        this.field_146292_n.clear();
    }

    public void func_146278_c(int backgroundID) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.backgroundA);
        int x = (this.field_146294_l - this.xSize) / 2;
        int y = (this.field_146295_m - this.ySize) / 2;
        String title = this.format("title", new Object[0]) + " - " + this.format(PAGEL[this.page], new Object[0]);
        this.func_146270_b(0);
        GuiEZConfig.func_152125_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)256, (int)256, (float)1.0f, (float)1.0f);
        this.func_73731_b(this.field_146289_q, title, (int)((double)(this.xStart + 128) - (double)this.field_146289_q.func_78256_a(title) * 0.5), this.yStart + 15, 0xFFFFFF);
    }

    public void drawElements() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int buttonRowBX = 14;
        int buttonRowBY = 85;
        int buttonHeight = 25;
        int size = this.buttons.size();
        if (this.page != 3) {
            for (int i = 0; i < size; ++i) {
                this.func_73731_b(this.field_146289_q, this.format("button." + this.buttons.get(i + 8 + this.maxEntries * this.subPage) + ".tooltip", new Object[0]), this.xStart + buttonRowBX, this.yStart + buttonRowBY + buttonHeight * i, 0xFFFFFF);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                this.func_73731_b(this.field_146289_q, WordUtils.capitalize((String)String.valueOf(this.buttons.get(8 + (i + this.maxEntries * this.subPage) * 2)).replaceAll("\\_", " ")), this.xStart + buttonRowBX, this.yStart + buttonRowBY + buttonHeight * i, 0xFFFFFF);
            }
        }
        if (this.maxSubPages > 0) {
            this.func_73731_b(this.field_146289_q, this.format("misc.page", this.subPage + 1, this.maxSubPages + 1), this.xStart + 46, this.yStart + 238, 0xFFFFFF);
        }
    }

    protected <T extends GuiButton> T addButton(T button, String localization) {
        this.buttons.put(button.field_146127_k, localization);
        this.field_146292_n.add(button);
        return button;
    }

    protected <T extends GuiButton> T func_189646_b(T button) {
        this.field_146292_n.add(button);
        return button;
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146278_c(-1);
        this.drawElements();
        super.func_73863_a(par1, par2, par3);
    }

    protected void func_73869_a(char par1, int par2) {
        try {
            super.func_73869_a(par1, par2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        try {
            super.func_73864_a(par1, par2, par3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.send) {
            this.send();
        }
        this.resetGuiElements();
        ScaledResolution sr = new ScaledResolution(this.field_146297_k);
        int scaledWidth = sr.func_78326_a();
        int scaledHeight = sr.func_78328_b();
        int buttonWidth = 56;
        int buttonHeight = 20;
        int buttonRowAY = 48;
        int buttonRowBX = 187;
        int buttonRowBY = 80;
        int buttonRowCY = 232;
        this.xSize = 256;
        this.ySize = 256;
        this.xCenter = (int)((float)scaledWidth * 0.5f);
        this.yCenter = (int)((float)scaledHeight * 0.5f);
        this.xStart = (int)((float)this.xCenter - (float)this.xSize * 0.5f);
        this.yStart = (int)((float)this.yCenter - (float)this.ySize * 0.5f);
        this.maxSubPages = 1;
        this.func_189646_b(new GuiButton(0, this.xStart + 193, this.yStart + buttonRowCY, buttonWidth, buttonHeight, this.format(EZGuiAPI.BUTTON_LIST[4], new Object[0])));
        this.func_189646_b(new GuiButton(1, this.xStart + 110, this.yStart + buttonRowCY, buttonWidth + 20, buttonHeight, this.format(EZGuiAPI.BUTTON_LIST[5], new Object[0])));
        this.func_189646_b(new GuiButton(2, this.xStart + 8, this.yStart + buttonRowAY, buttonWidth, buttonHeight, this.format(EZGuiAPI.BUTTON_LIST[25], new Object[0])));
        this.func_189646_b(new GuiButton(3, this.xStart + 69, this.yStart + buttonRowAY, buttonWidth, buttonHeight, this.format(EZGuiAPI.BUTTON_LIST[26], new Object[0])));
        this.func_189646_b(new GuiButton(4, this.xStart + 130, this.yStart + buttonRowAY, buttonWidth, buttonHeight, this.format(EZGuiAPI.BUTTON_LIST[27], new Object[0])));
        this.func_189646_b(new GuiButton(5, this.xStart + 191, this.yStart + buttonRowAY, buttonWidth, buttonHeight, this.format(EZGuiAPI.BUTTON_LIST[28], new Object[0])));
        int size = 0;
        int startingIndex = this.maxEntries * this.subPage;
        if (this.page == 0 || EZConfigParser.isOp()) {
            try {
                switch (this.page) {
                    case 3: {
                        size = EZConfigParser.dimNames.size();
                        this.maxSubPages = size / this.maxEntries;
                        Object[] keys = EZConfigParser.dimNames.keySet().toArray();
                        Object[] values = EZConfigParser.dimNames.values().toArray();
                        int ii = 0;
                        int iii = 0;
                        if (ClientProxy.clientTickHandler.op) {
                            for (int i = startingIndex; i < size && i - startingIndex < this.maxEntries; ++i) {
                                int heightOffset = i - startingIndex;
                                ii = i + iii + 8 + startingIndex;
                                this.addButton(new GuiButtonCycle(ii, this.xStart + buttonRowBX - (buttonWidth + 5), this.yStart + buttonRowBY + (buttonHeight + 5) * heightOffset, buttonWidth, buttonHeight, EZGuiAPI.BL_WTOGGLE, EZConfigParser.isWeatherEnabled((Integer)keys[i]) ? 1 : 0), (String)values[i]);
                                this.func_189646_b(new GuiButtonCycle(ii + 1, this.xStart + buttonRowBX, this.yStart + buttonRowBY + (buttonHeight + 5) * heightOffset, buttonWidth, buttonHeight, EZGuiAPI.BL_ETOGGLE, EZConfigParser.isEffectsEnabled((Integer)keys[i]) ? 1 : 0));
                                ++iii;
                            }
                        }
                        break;
                    }
                    default: {
                        TriMapEx<String, List<String>, Integer> options = EZGuiAPI.getOptions();
                        Map<String, Integer> categories = EZGuiAPI.getOptionCategories();
                        this.settings.clear();
                        for (Map.Entry<String, Integer> entry : categories.entrySet()) {
                            if (entry.getValue() != this.page) continue;
                            this.settings.add(entry.getKey());
                        }
                        size = this.settings.size();
                        this.maxSubPages = (size - 1) / this.maxEntries;
                        for (int i = 0; i < size && i - startingIndex < this.maxEntries; ++i) {
                            if (i < startingIndex) continue;
                            String id = this.settings.get(i);
                            this.addButton(new GuiButtonCycle(i + 8, this.xStart + buttonRowBX, this.yStart + buttonRowBY + (buttonHeight + 5) * (i - startingIndex), buttonWidth, buttonHeight, options.getA(id), EZConfigParser.getConfigValue(id)), id);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.maxSubPages > 0) {
            if (this.subPage < this.maxSubPages) {
                this.func_189646_b(new GuiButton(6, this.xStart + 67, this.yStart + buttonRowCY, buttonWidth - 20, buttonHeight, this.format(EZGuiAPI.BUTTON_LIST[7], new Object[0])));
            }
            if (this.subPage > 0) {
                this.func_189646_b(new GuiButton(7, this.xStart + 7, this.yStart + buttonRowCY, buttonWidth - 20, buttonHeight, this.format(EZGuiAPI.BUTTON_LIST[8], new Object[0])));
            }
        }
    }

    protected void func_146284_a(GuiButton button) {
        int index = button.field_146127_k - 8;
        if (button instanceof GuiButtonBoolean) {
            ((GuiButtonBoolean)button).setBooleanToggle();
            switch (this.page) {
                case 0: {
                    if (!this.nbtSendCache.func_74764_b("client")) {
                        this.nbtSendCache.func_74782_a("client", (NBTBase)new NBTTagCompound());
                    }
                    this.nbtSendCache.func_74775_l("client").func_74768_a(PREFIX + this.settings.get(index), ((GuiButtonBoolean)button).field_146124_l ? 1 : 0);
                    break;
                }
                case 3: {
                    Object[] keys = EZConfigParser.dimNames.keySet().toArray();
                    if (!this.nbtSendCache.func_74764_b("server")) {
                        this.nbtSendCache.func_74782_a("server", (NBTBase)new NBTTagCompound());
                    }
                    if (!this.nbtSendCache.func_74775_l("server").func_74764_b("dimData")) {
                        this.nbtSendCache.func_74775_l("server").func_74782_a("dimData", (NBTBase)new NBTTagCompound());
                    }
                    this.nbtSendCache.func_74775_l("server").func_74775_l("dimData").func_74768_a((button.field_146127_k - 8) % 2 == 0 ? "dimb_" + keys[(int)((float)(button.field_146127_k - 8) * 0.5f)] : "dimc_" + keys[(int)((float)(button.field_146127_k - 8 - 1) * 0.5f)], ((GuiButtonBoolean)button).field_146124_l ? 1 : 0);
                    break;
                }
                default: {
                    if (!this.nbtSendCache.func_74764_b("server")) {
                        this.nbtSendCache.func_74782_a("server", (NBTBase)new NBTTagCompound());
                    }
                    this.nbtSendCache.func_74775_l("server").func_74768_a(PREFIX + this.settings.get(index), ((GuiButtonBoolean)button).field_146124_l ? 1 : 0);
                    break;
                }
            }
        } else if (button instanceof GuiButtonCycle) {
            ((GuiButtonCycle)button).cycleIndex();
            switch (this.page) {
                case 0: {
                    if (!this.nbtSendCache.func_74764_b("client")) {
                        this.nbtSendCache.func_74782_a("client", (NBTBase)new NBTTagCompound());
                    }
                    this.nbtSendCache.func_74775_l("client").func_74768_a(PREFIX + this.settings.get(index), ((GuiButtonCycle)button).index);
                    break;
                }
                case 3: {
                    Object[] keys = EZConfigParser.dimNames.keySet().toArray();
                    if (!this.nbtSendCache.func_74764_b("server")) {
                        this.nbtSendCache.func_74782_a("server", (NBTBase)new NBTTagCompound());
                    }
                    if (!this.nbtSendCache.func_74775_l("server").func_74764_b("dimData")) {
                        this.nbtSendCache.func_74775_l("server").func_74782_a("dimData", (NBTBase)new NBTTagCompound());
                    }
                    this.nbtSendCache.func_74775_l("server").func_74775_l("dimData").func_74768_a((button.field_146127_k - 8) % 2 == 0 ? "dimb_" + keys[(int)((float)(button.field_146127_k - 8) * 0.5f)] : "dimc_" + keys[(int)((float)(button.field_146127_k - 8 - 1) * 0.5f)], ((GuiButtonCycle)button).index);
                    break;
                }
                default: {
                    if (!this.nbtSendCache.func_74764_b("server")) {
                        this.nbtSendCache.func_74782_a("server", (NBTBase)new NBTTagCompound());
                    }
                    this.nbtSendCache.func_74775_l("server").func_74768_a(PREFIX + this.settings.get(index), ((GuiButtonCycle)button).index);
                }
            }
        }
        switch (button.field_146127_k) {
            case 0: {
                this.field_146297_k.field_71439_g.func_71053_j();
                if (!this.send) break;
                this.send();
                break;
            }
            case 1: {
                if (this.send) {
                    this.send();
                }
                this.field_146297_k.func_147108_a((GuiScreen)new GuiConfigEditor());
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.page = button.field_146127_k == 2 ? 0 : (button.field_146127_k == 3 ? 1 : (button.field_146127_k == 4 ? 2 : 3));
                this.subPage = 0;
                this.func_73866_w_();
                break;
            }
            case 6: {
                if (this.subPage < this.maxSubPages) {
                    ++this.subPage;
                }
                this.func_73866_w_();
                break;
            }
            case 7: {
                if (this.subPage > 0) {
                    --this.subPage;
                }
                this.func_73866_w_();
                break;
            }
            default: {
                if (button.field_146127_k > -1) {
                    this.send = true;
                    break;
                }
                Weather2.warn("Unknown GUI button was pressed (ID:" + button.field_146127_k + ")");
            }
        }
    }

    public int sanitize(int val) {
        return this.sanitize(val, 0, 9999);
    }

    public int sanitize(int val, int min, int max) {
        if (val > max) {
            val = max;
        }
        if (val < min) {
            val = min;
        }
        return val;
    }

    public void func_73729_b(int x, int y, int textureX, int textureY, int width, int height) {
        float f = 0.001953125f;
        float f1 = 0.001953125f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)(x + 0), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + 0), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + 0), (double)(y + 0), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    private void send() {
        Weather2.debug("Preparing to send packets... " + this.nbtSendCache);
        boolean bl = ClientProxy.clientTickHandler.op = ConfigManager.getPermissionLevel() > 3;
        if (this.nbtSendCache.func_74764_b("client")) {
            Weather2.debug("Sending config packet to client");
            this.nbtSendCache.func_74775_l("client").func_74768_a("server", 0);
            EZConfigParser.nbtReceiveClient(this.nbtSendCache.func_74775_l("client"));
            this.nbtSendCache.func_82580_o("client");
        }
        if (this.nbtSendCache.func_74764_b("server") && ClientProxy.clientTickHandler.op) {
            Weather2.debug("Sending config packet to server");
            PacketEZGUI.apply(this.nbtSendCache.func_74775_l("server"));
            this.nbtSendCache.func_82580_o("server");
        }
        this.send = false;
        PacketEZGUI.sync();
    }

    private String format(String local, Object ... args) {
        return I18n.func_135052_a((String)("config.ezgui." + local), (Object[])args);
    }
}

