/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.client.foliage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.mrbt0907.weather2.client.foliage.FoliageEnhancerShader;

public abstract class FoliageReplacerBase {
    public IBlockState state;
    public List<TextureAtlasSprite> sprites = new ArrayList<TextureAtlasSprite>();
    public int expectedHeight = 1;
    public Material baseMaterial = Material.field_151577_b;
    public boolean biomeColorize = true;
    public boolean randomizeCoord = true;
    public boolean stateSensitive = false;
    public HashMap<IProperty, Comparable> lookupPropertiesToComparable = new HashMap();
    public int animationID;
    public float looseness = 1.0f;

    public FoliageReplacerBase(IBlockState state) {
        this.state = state;
    }

    public FoliageReplacerBase setSprites(List<TextureAtlasSprite> sprites) {
        this.sprites = sprites;
        return this;
    }

    public FoliageReplacerBase setSprite(TextureAtlasSprite sprite) {
        this.sprites.add(sprite);
        return this;
    }

    public FoliageReplacerBase setBaseMaterial(Material material) {
        this.baseMaterial = material;
        return this;
    }

    public FoliageReplacerBase setBiomeColorize(boolean val) {
        this.biomeColorize = val;
        return this;
    }

    public FoliageReplacerBase setRandomizeCoord(boolean val) {
        this.randomizeCoord = val;
        return this;
    }

    public FoliageReplacerBase setStateSensitive(boolean val) {
        this.stateSensitive = val;
        return this;
    }

    public FoliageReplacerBase addComparable(IProperty property, Comparable comparable) {
        this.lookupPropertiesToComparable.put(property, comparable);
        return this;
    }

    public abstract boolean validFoliageSpot(World var1, BlockPos var2);

    public abstract void addForPos(World var1, BlockPos var2);

    public void markMeshesDirty() {
        for (TextureAtlasSprite sprite : this.sprites) {
            FoliageEnhancerShader.markMeshDirty(sprite, true);
        }
    }

    public FoliageReplacerBase setLooseness(float val) {
        this.looseness = val;
        return this;
    }

    public boolean isActive() {
        return true;
    }
}

