/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.client.foliage;

import CoroUtil.config.ConfigCoroUtil;
import CoroUtil.util.CoroUtilBlockLightCache;
import CoroUtil.util.Vec3;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import extendedrenderer.EventHandler;
import extendedrenderer.ExtendedRenderer;
import extendedrenderer.foliage.Foliage;
import extendedrenderer.foliage.FoliageData;
import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.render.FoliageRenderer;
import extendedrenderer.render.RotatingParticleManager;
import extendedrenderer.shader.InstancedMeshFoliage;
import extendedrenderer.shader.MeshBufferManagerFoliage;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.BlockBeetroot;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.animation.AnimationItemOverrideList;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.client.foliage.FoliageLocationData;
import net.mrbt0907.weather2.client.foliage.FoliageReplacerBase;
import net.mrbt0907.weather2.client.foliage.FoliageReplacerCross;
import net.mrbt0907.weather2.client.foliage.FoliageReplacerCrossGrass;
import net.mrbt0907.weather2.client.foliage.FoliageReplacerCrossLeaves;
import net.mrbt0907.weather2.config.ConfigFoliage;
import net.mrbt0907.weather2.config.ConfigMisc;
import net.mrbt0907.weather2.config.EZConfigParser;
import org.lwjgl.BufferUtils;

public class FoliageEnhancerShader
implements Runnable {
    public static boolean useThread = true;
    public static List<FoliageReplacerBase> listFoliageReplacers = new ArrayList<FoliageReplacerBase>();
    public static ConcurrentHashMap<BlockPos, FoliageLocationData> lookupPosToFoliage = new ConcurrentHashMap();
    private static final Class multipartModelClass;
    private static final Class vanillaModelWrapperClass;
    private static final Field multipartPartModels;
    private static final Field modelWrapperModel;
    public static ModelLoader modelLoader;
    public static IRegistry<ModelResourceLocation, IBakedModel> modelRegistry;
    public static HashMap<ModelResourceLocation, IBakedModel> lookupBackupReplacedModels;

    public static void modelBakeEvent(ModelBakeEvent event) {
        modelLoader = event.getModelLoader();
        modelRegistry = event.getModelRegistry();
        FoliageEnhancerShader.processModels();
    }

    public static void liveReloadModels() {
        FoliageEnhancerShader.processModels();
        FoliageEnhancerShader.modelLoader.field_177610_k.func_178124_c();
        Minecraft.func_71410_x().field_71438_f.func_72712_a();
    }

    public static void processModels() {
        if (modelLoader == null || modelRegistry == null) {
            Weather2.error("modelLoader or modelRegistry null, aborting");
        }
        boolean hackyLiveReplace = false;
        boolean replaceVanillaModels = ConfigCoroUtil.foliageShaders && EventHandler.queryUseOfShaders() && !ConfigMisc.toaster_pc_mode;
        boolean textureFix = false;
        FoliageData.backupBakedModelStore.clear();
        if (replaceVanillaModels) {
            lookupBackupReplacedModels.clear();
            String str = "Weather2: Replacing shaderized models";
            Weather2.debug(str);
            ProgressManager.ProgressBar prog = ProgressManager.push((String)str, (int)modelRegistry.func_148742_b().size(), (boolean)true);
            Map stateModels = (Map)ReflectionHelper.getPrivateValue(ModelLoader.class, (Object)modelLoader, (String[])new String[]{"stateModels"});
            IBakedModel blank = (IBakedModel)modelRegistry.func_82594_a((Object)new ModelResourceLocation("coroutil:blank", "normal"));
            FoliageEnhancerShader.modelLoader.field_177610_k.func_178124_c();
            Weather2.debug("bakedModelStore size: " + FoliageEnhancerShader.modelLoader.field_177610_k.field_178129_a.size());
            for (Map.Entry entry : FoliageEnhancerShader.modelLoader.field_177610_k.field_178129_a.entrySet()) {
                IBlockState state = (IBlockState)entry.getKey();
                if (state instanceof IExtendedBlockState) {
                    state = ((IExtendedBlockState)state).getClean();
                }
                FoliageData.backupBakedModelStore.put(state, entry.getValue());
            }
            for (ModelResourceLocation res : modelRegistry.func_148742_b()) {
                prog.step(res.toString());
                IModel model = (IModel)stateModels.get(res);
                if (model == null) continue;
                try {
                    HashSet textures = Sets.newHashSet((Iterable)model.getTextures());
                    if (res.func_177518_c().equals("inventory")) continue;
                    for (FoliageReplacerBase replacer : listFoliageReplacers) {
                        for (TextureAtlasSprite sprite : replacer.sprites) {
                            for (ResourceLocation res2 : textures) {
                                AnimationItemOverrideList obj1;
                                IModel model1;
                                if (!res2.toString().equals(sprite.func_94215_i()) || res.toString().contains("flower_pot")) continue;
                                if (textureFix && blank.func_188617_f() instanceof AnimationItemOverrideList && vanillaModelWrapperClass.isAssignableFrom((model1 = (IModel)ReflectionHelper.getPrivateValue(AnimationItemOverrideList.class, (Object)(obj1 = (AnimationItemOverrideList)blank.func_188617_f()), (String[])new String[]{"model"})).getClass())) {
                                    ModelBlock model2 = (ModelBlock)ReflectionHelper.getPrivateValue((Class)vanillaModelWrapperClass, (Object)model1, (String[])new String[]{"model"});
                                    String tex = res2.toString().split(":")[1];
                                    model2.field_178318_c.put("particle", tex);
                                }
                                lookupBackupReplacedModels.put(res, (IBakedModel)modelRegistry.func_82594_a((Object)res));
                                modelRegistry.func_82595_a((Object)res, (Object)blank);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            ProgressManager.pop((ProgressManager.ProgressBar)prog);
        } else {
            if (!hackyLiveReplace) {
                return;
            }
            if (lookupBackupReplacedModels.size() == 0) {
                return;
            }
            Map stateModels = (Map)ReflectionHelper.getPrivateValue(ModelLoader.class, (Object)modelLoader, (String[])new String[]{"stateModels"});
            for (ModelResourceLocation res : modelRegistry.func_148742_b()) {
                IModel model = (IModel)stateModels.get(res);
                if (model == null) continue;
                try {
                    HashSet textures = Sets.newHashSet((Iterable)model.getTextures());
                    if (res.func_177518_c().equals("inventory")) continue;
                    for (FoliageReplacerBase replacer : listFoliageReplacers) {
                        for (TextureAtlasSprite sprite : replacer.sprites) {
                            for (ResourceLocation res2 : textures) {
                                if (!res2.toString().equals(sprite.func_94215_i()) || res.toString().contains("flower_pot")) continue;
                                modelRegistry.func_82595_a((Object)res, (Object)lookupBackupReplacedModels.get(res));
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void shadersInit() {
        FoliageEnhancerShader.setupReplacers();
        Weather2.debug("Weather2: Setting up meshes for foliage shader");
        for (FoliageReplacerBase replacer : listFoliageReplacers) {
            for (TextureAtlasSprite sprite : replacer.sprites) {
                MeshBufferManagerFoliage.setupMeshIfMissing((TextureAtlasSprite)sprite);
            }
        }
    }

    public static void setupReplacersAndMeshes() {
    }

    public static void setupReplacers() {
        boolean extraLeaves;
        boolean colorize;
        Weather2.debug("Weather2: Setting up foliage replacers");
        listFoliageReplacers.clear();
        HashMap<Object, String> lookup = new HashMap<Object, String>();
        lookup.clear();
        lookup.put(BlockPlanks.EnumType.OAK, "minecraft:blocks/sapling_oak");
        lookup.put(BlockPlanks.EnumType.SPRUCE, "minecraft:blocks/sapling_spruce");
        lookup.put(BlockPlanks.EnumType.BIRCH, "minecraft:blocks/sapling_birch");
        lookup.put(BlockPlanks.EnumType.JUNGLE, "minecraft:blocks/sapling_jungle");
        lookup.put(BlockPlanks.EnumType.ACACIA, "minecraft:blocks/sapling_acacia");
        lookup.put(BlockPlanks.EnumType.DARK_OAK, "minecraft:blocks/sapling_roofed_oak");
        for (Map.Entry entrySet : lookup.entrySet()) {
            colorize = false;
            listFoliageReplacers.add(new FoliageReplacerCross(Blocks.field_150345_g.func_176223_P()).setSprite(FoliageEnhancerShader.getMeshAndSetupSprite((String)entrySet.getValue())).setStateSensitive(true).setBiomeColorize(colorize).addComparable((IProperty)BlockSapling.field_176480_a, (Comparable)entrySet.getKey()));
        }
        lookup.clear();
        lookup.put(BlockTallGrass.EnumType.DEAD_BUSH, "minecraft:blocks/deadbush");
        lookup.put(BlockTallGrass.EnumType.GRASS, "minecraft:blocks/tallgrass");
        lookup.put(BlockTallGrass.EnumType.FERN, "minecraft:blocks/fern");
        for (Map.Entry entrySet : lookup.entrySet()) {
            colorize = entrySet.getKey() != BlockTallGrass.EnumType.DEAD_BUSH;
            listFoliageReplacers.add(new FoliageReplacerCross(Blocks.field_150329_H.func_176223_P()).setSprite(FoliageEnhancerShader.getMeshAndSetupSprite((String)entrySet.getValue())).setStateSensitive(true).setRandomizeCoord(false).setBiomeColorize(colorize).addComparable((IProperty)BlockTallGrass.field_176497_a, (Comparable)entrySet.getKey()));
        }
        listFoliageReplacers.add(new FoliageReplacerCross(Blocks.field_150327_N.func_176223_P()).setSprite(FoliageEnhancerShader.getMeshAndSetupSprite("minecraft:blocks/flower_dandelion")).setRandomizeCoord(false).setBiomeColorize(false));
        lookup.clear();
        lookup.put(BlockFlower.EnumFlowerType.ALLIUM, "minecraft:blocks/flower_allium");
        lookup.put(BlockFlower.EnumFlowerType.BLUE_ORCHID, "minecraft:blocks/flower_blue_orchid");
        lookup.put(BlockFlower.EnumFlowerType.HOUSTONIA, "minecraft:blocks/flower_houstonia");
        lookup.put(BlockFlower.EnumFlowerType.ORANGE_TULIP, "minecraft:blocks/flower_tulip_orange");
        lookup.put(BlockFlower.EnumFlowerType.OXEYE_DAISY, "minecraft:blocks/flower_oxeye_daisy");
        lookup.put(BlockFlower.EnumFlowerType.PINK_TULIP, "minecraft:blocks/flower_tulip_pink");
        lookup.put(BlockFlower.EnumFlowerType.POPPY, "minecraft:blocks/flower_rose");
        lookup.put(BlockFlower.EnumFlowerType.RED_TULIP, "minecraft:blocks/flower_tulip_red");
        lookup.put(BlockFlower.EnumFlowerType.WHITE_TULIP, "minecraft:blocks/flower_tulip_white");
        for (Map.Entry entrySet : lookup.entrySet()) {
            colorize = false;
            listFoliageReplacers.add(new FoliageReplacerCross(Blocks.field_150328_O.func_176223_P()).setSprite(FoliageEnhancerShader.getMeshAndSetupSprite((String)entrySet.getValue())).setRandomizeCoord(false).setStateSensitive(true).setBiomeColorize(colorize).addComparable(Blocks.field_150328_O.func_176494_l(), (Comparable)entrySet.getKey()));
        }
        for (int i = 0; i < 8; ++i) {
            int temp = i;
            listFoliageReplacers.add(new FoliageReplacerCross(Blocks.field_150464_aj.func_176223_P()).setBaseMaterial(Material.field_151578_c).setSprite(FoliageEnhancerShader.getMeshAndSetupSprite("minecraft:blocks/wheat_stage_" + temp)).setRandomizeCoord(false).setStateSensitive(true).addComparable((IProperty)BlockCrops.field_176488_a, Integer.valueOf(i)));
        }
        listFoliageReplacers.add(new FoliageReplacerCross(Blocks.field_150436_aH.func_176223_P(), -1).setSprite(FoliageEnhancerShader.getMeshAndSetupSprite("minecraft:blocks/reeds")).setBaseMaterial(Material.field_151595_p).setBiomeColorize(true).setRandomizeCoord(false).setLooseness(0.3f));
        HashMap<Integer, Integer> lookupStateToModel = new HashMap<Integer, Integer>();
        lookupStateToModel.put(0, 0);
        lookupStateToModel.put(1, 0);
        lookupStateToModel.put(2, 1);
        lookupStateToModel.put(3, 1);
        lookupStateToModel.put(4, 2);
        lookupStateToModel.put(5, 2);
        lookupStateToModel.put(6, 2);
        lookupStateToModel.put(7, 3);
        for (Map.Entry entrySet : lookupStateToModel.entrySet()) {
            listFoliageReplacers.add(new FoliageReplacerCross(Blocks.field_150459_bM.func_176223_P()).setBaseMaterial(Material.field_151578_c).setSprite(FoliageEnhancerShader.getMeshAndSetupSprite("minecraft:blocks/carrots_stage_" + entrySet.getValue())).setRandomizeCoord(false).setStateSensitive(true).addComparable((IProperty)BlockCrops.field_176488_a, (Comparable)entrySet.getKey()));
        }
        for (Map.Entry entrySet : lookupStateToModel.entrySet()) {
            listFoliageReplacers.add(new FoliageReplacerCross(Blocks.field_150469_bN.func_176223_P()).setBaseMaterial(Material.field_151578_c).setSprite(FoliageEnhancerShader.getMeshAndSetupSprite("minecraft:blocks/potatoes_stage_" + entrySet.getValue())).setRandomizeCoord(false).setStateSensitive(true).addComparable((IProperty)BlockCrops.field_176488_a, (Comparable)entrySet.getKey()));
        }
        for (int i = 0; i < 4; ++i) {
            listFoliageReplacers.add(new FoliageReplacerCross(Blocks.field_185773_cZ.func_176223_P()).setBaseMaterial(Material.field_151578_c).setSprite(FoliageEnhancerShader.getMeshAndSetupSprite("minecraft:blocks/beetroots_stage_" + i)).setRandomizeCoord(false).setStateSensitive(true).addComparable((IProperty)BlockBeetroot.field_185531_a, Integer.valueOf(i)));
        }
        ArrayList<Object> sprites = new ArrayList<TextureAtlasSprite>();
        sprites.add(FoliageEnhancerShader.getMeshAndSetupSprite("minecraft:blocks/double_plant_grass_bottom"));
        sprites.add(FoliageEnhancerShader.getMeshAndSetupSprite("minecraft:blocks/double_plant_grass_top"));
        listFoliageReplacers.add(new FoliageReplacerCross(Blocks.field_150398_cm.func_176223_P(), 2).setSprites(sprites).setStateSensitive(true).addComparable((IProperty)BlockDoublePlant.field_176493_a, (Comparable)BlockDoublePlant.EnumPlantType.GRASS));
        sprites = new ArrayList();
        sprites.add(FoliageEnhancerShader.getMeshAndSetupSprite("minecraft:blocks/double_plant_rose_bottom"));
        sprites.add(FoliageEnhancerShader.getMeshAndSetupSprite("minecraft:blocks/double_plant_rose_top"));
        listFoliageReplacers.add(new FoliageReplacerCross(Blocks.field_150398_cm.func_176223_P(), 2).setSprites(sprites).setBiomeColorize(false).setStateSensitive(true).addComparable((IProperty)BlockDoublePlant.field_176493_a, (Comparable)BlockDoublePlant.EnumPlantType.ROSE));
        sprites = new ArrayList();
        sprites.add(FoliageEnhancerShader.getMeshAndSetupSprite("minecraft:blocks/double_plant_fern_bottom"));
        sprites.add(FoliageEnhancerShader.getMeshAndSetupSprite("minecraft:blocks/double_plant_fern_top"));
        listFoliageReplacers.add(new FoliageReplacerCross(Blocks.field_150398_cm.func_176223_P(), 2).setSprites(sprites).setBiomeColorize(true).setStateSensitive(true).addComparable((IProperty)BlockDoublePlant.field_176493_a, (Comparable)BlockDoublePlant.EnumPlantType.FERN));
        sprites = new ArrayList();
        sprites.add(FoliageEnhancerShader.getMeshAndSetupSprite("minecraft:blocks/double_plant_paeonia_bottom"));
        sprites.add(FoliageEnhancerShader.getMeshAndSetupSprite("minecraft:blocks/double_plant_paeonia_top"));
        listFoliageReplacers.add(new FoliageReplacerCross(Blocks.field_150398_cm.func_176223_P(), 2).setSprites(sprites).setBiomeColorize(false).setStateSensitive(true).addComparable((IProperty)BlockDoublePlant.field_176493_a, (Comparable)BlockDoublePlant.EnumPlantType.PAEONIA));
        sprites = new ArrayList();
        sprites.add(FoliageEnhancerShader.getMeshAndSetupSprite("minecraft:blocks/double_plant_syringa_bottom"));
        sprites.add(FoliageEnhancerShader.getMeshAndSetupSprite("minecraft:blocks/double_plant_syringa_top"));
        listFoliageReplacers.add(new FoliageReplacerCross(Blocks.field_150398_cm.func_176223_P(), 2).setSprites(sprites).setBiomeColorize(false).setStateSensitive(true).addComparable((IProperty)BlockDoublePlant.field_176493_a, (Comparable)BlockDoublePlant.EnumPlantType.SYRINGA));
        if (ConfigFoliage.enable_extra_grass) {
            listFoliageReplacers.add(new FoliageReplacerCrossGrass(Blocks.field_150350_a.func_176223_P()){

                @Override
                public boolean isActive() {
                    return ConfigFoliage.enable_extra_grass;
                }
            }.setSprite(FoliageEnhancerShader.getMeshAndSetupSprite(ExtendedRenderer.modid + ":particles/grass")).setRandomizeCoord(true).setBiomeColorize(true));
        }
        if (extraLeaves = false) {
            listFoliageReplacers.add(new FoliageReplacerCrossLeaves(Blocks.field_150362_t.func_176223_P()).setSprite(FoliageEnhancerShader.getMeshAndSetupSprite("minecraft:blocks/tallgrass")).setBiomeColorize(true));
        }
    }

    public static void shadersReset() {
        lookupPosToFoliage.clear();
    }

    public static TextureAtlasSprite getMeshAndSetupSprite(String spriteLoc) {
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        TextureAtlasSprite sprite = map.func_110572_b(spriteLoc);
        return sprite;
    }

    @Override
    public void run() {
        if (useThread) {
            while (true) {
                try {
                    while (true) {
                        if (ConfigCoroUtil.foliageShaders && RotatingParticleManager.useShaders && !ConfigMisc.toaster_pc_mode) {
                            boolean gotLock = FoliageEnhancerShader.tickClientThreaded();
                            if (gotLock) {
                                Thread.sleep(ConfigFoliage.shader_process_delay);
                                continue;
                            }
                            Thread.sleep(20L);
                            continue;
                        }
                        Thread.sleep(5000L);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    public static boolean tickClientCloseToPlayer() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.field_71441_e != null && mc.field_71439_g != null && EZConfigParser.isEffectsEnabled(mc.field_71441_e.field_73011_w.getDimension())) {
            return FoliageEnhancerShader.tickFoliage(5, false);
        }
        return true;
    }

    public static boolean tickClientThreaded() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.field_71441_e != null && mc.field_71439_g != null && EZConfigParser.isEffectsEnabled(mc.field_71441_e.field_73011_w.getDimension())) {
            return FoliageEnhancerShader.tickFoliage(ConfigFoliage.shader_range, true);
        }
        return true;
    }

    public static boolean tickFoliage(int radialRange, boolean trimRange) {
        if (ExtendedRenderer.foliageRenderer.lockVBO2.tryLock()) {
            try {
                boolean bl = FoliageEnhancerShader.profileForFoliageShader(radialRange, trimRange);
                return bl;
            }
            finally {
                ExtendedRenderer.foliageRenderer.lockVBO2.unlock();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean profileForFoliageShader(int radialRange, boolean trimRange) {
        Object mesh;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityPlayerSP entityIn = Minecraft.func_71410_x().field_71439_g;
        BlockPos pos = entityIn.func_180425_c();
        boolean add = true;
        boolean trim = true;
        int xzRange = radialRange;
        int yRange = radialRange;
        Random rand = new Random();
        double centerX = entityIn.field_70165_t;
        double centerY = entityIn.field_70163_u;
        double centerZ = entityIn.field_70161_v;
        for (TextureAtlasSprite sprite : ExtendedRenderer.foliageRenderer.foliage.keySet()) {
            mesh = MeshBufferManagerFoliage.getMesh((TextureAtlasSprite)sprite);
            ((InstancedMeshFoliage)mesh).lastAdditionCount = 0;
            ((InstancedMeshFoliage)mesh).lastRemovalCount = 0;
        }
        if (trim) {
            Iterator<Map.Entry<BlockPos, FoliageLocationData>> it = lookupPosToFoliage.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<BlockPos, FoliageLocationData> entry = it.next();
                if (!entry.getValue().foliageReplacer.isActive() || !entry.getValue().foliageReplacer.validFoliageSpot((World)world, entry.getKey().func_177977_b())) {
                    it.remove();
                    for (Foliage entry2 : entry.getValue().listFoliage) {
                        entry.getValue().foliageReplacer.markMeshesDirty();
                        ExtendedRenderer.foliageRenderer.getFoliageForSprite(entry2.particleTexture).remove(entry2);
                        ++MeshBufferManagerFoliage.getMesh((TextureAtlasSprite)entry2.particleTexture).lastRemovalCount;
                    }
                    continue;
                }
                if (!trimRange || !(entry.getKey().func_177954_c(centerX, centerY, centerZ) > (double)(radialRange * radialRange))) continue;
                it.remove();
                for (Foliage entry2 : entry.getValue().listFoliage) {
                    entry.getValue().foliageReplacer.markMeshesDirty();
                    ExtendedRenderer.foliageRenderer.getFoliageForSprite(entry2.particleTexture).remove(entry2);
                    ++MeshBufferManagerFoliage.getMesh((TextureAtlasSprite)entry2.particleTexture).lastRemovalCount;
                }
            }
        }
        if (add) {
            for (int x = -xzRange; x <= xzRange; ++x) {
                for (int z = -xzRange; z <= xzRange; ++z) {
                    for (int y = -yRange; y <= yRange; ++y) {
                        FoliageReplacerBase replacer2;
                        BlockPos posScan = pos.func_177982_a(x, y, z);
                        if (lookupPosToFoliage.containsKey(posScan) || !(posScan.func_177954_c(centerX, centerY, centerZ) <= (double)(radialRange * radialRange))) continue;
                        boolean tryAll = true;
                        if (tryAll) {
                            for (FoliageReplacerBase replacer2 : listFoliageReplacers) {
                                if (!replacer2.isActive() || !replacer2.validFoliageSpot(entityIn.field_70170_p, posScan.func_177977_b())) continue;
                                replacer2.addForPos(entityIn.field_70170_p, posScan);
                                replacer2.markMeshesDirty();
                                for (TextureAtlasSprite sprite : replacer2.sprites) {
                                    ++MeshBufferManagerFoliage.getMesh((TextureAtlasSprite)sprite).lastAdditionCount;
                                }
                            }
                            continue;
                        }
                        int randTry = rand.nextInt(listFoliageReplacers.size());
                        replacer2 = listFoliageReplacers.get(randTry);
                        if (!replacer2.isActive() || !replacer2.validFoliageSpot(entityIn.field_70170_p, posScan.func_177977_b())) continue;
                        replacer2.addForPos(entityIn.field_70170_p, posScan);
                        replacer2.markMeshesDirty();
                    }
                }
            }
        }
        try {
            for (Map.Entry entry : ExtendedRenderer.foliageRenderer.foliage.entrySet()) {
                mesh = MeshBufferManagerFoliage.getMesh((TextureAtlasSprite)((TextureAtlasSprite)entry.getKey()));
                if (!((InstancedMeshFoliage)mesh).dirtyVBO2Flag) continue;
                ((InstancedMeshFoliage)mesh).interpPosXThread = entityIn.field_70165_t;
                ((InstancedMeshFoliage)mesh).interpPosYThread = entityIn.field_70163_u;
                ((InstancedMeshFoliage)mesh).interpPosZThread = entityIn.field_70161_v;
                FoliageEnhancerShader.updateVBO2Threaded((TextureAtlasSprite)entry.getKey());
            }
        }
        finally {
            return true;
        }
    }

    public static void markMeshDirty(TextureAtlasSprite sprite, boolean flag) {
        InstancedMeshFoliage mesh = MeshBufferManagerFoliage.getMesh((TextureAtlasSprite)sprite);
        if (mesh != null) {
            mesh.dirtyVBO2Flag = flag;
        } else {
            Weather2.debug("MESH NULL HERE, FIX INIT ORDER");
        }
    }

    public static void updateVBO2Threaded(TextureAtlasSprite sprite) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity entityIn = mc.func_175606_aa();
        float partialTicks = 1.0f;
        InstancedMeshFoliage mesh = MeshBufferManagerFoliage.getMesh((TextureAtlasSprite)sprite);
        if (mesh == null) {
            return;
        }
        int lastPos = mesh.curBufferPosVBO2;
        mesh.curBufferPosVBO2 = 0;
        mesh.instanceDataBufferVBO2.clear();
        int guessAtExtraMeshesPerFoliage = 4;
        int extraMeshes = mesh.lastAdditionCount * guessAtExtraMeshesPerFoliage - mesh.lastRemovalCount * guessAtExtraMeshesPerFoliage;
        if (lastPos + extraMeshes > mesh.numInstances) {
            mesh.numInstances = mesh.numInstances * 4 < lastPos + extraMeshes ? (int)(Math.ceil((float)(lastPos + extraMeshes) / 10000.0f) * 10000.0) : (mesh.numInstances *= 4);
            mesh.instanceDataBufferVBO2 = BufferUtils.createFloatBuffer((int)(mesh.numInstances * 24));
            mesh.instanceDataBufferVBO2.clear();
            mesh.instanceDataBufferVBO1 = BufferUtils.createFloatBuffer((int)(mesh.numInstances * 2));
        }
        for (Foliage foliage : ExtendedRenderer.foliageRenderer.getFoliageForSprite(sprite)) {
            foliage.updateQuaternion(entityIn);
            foliage.renderForShaderVBO2(mesh, ExtendedRenderer.foliageRenderer.transformation, null, entityIn, partialTicks);
        }
        if (FoliageRenderer.testStaticLimit) {
            mesh.instanceDataBufferVBO2.limit(30000 * 24);
        } else {
            mesh.instanceDataBufferVBO2.limit(mesh.curBufferPosVBO2 * 24);
        }
    }

    public static void addForPos(FoliageReplacerBase replacer, int height, BlockPos pos) {
        FoliageEnhancerShader.addForPos(replacer, height, pos, new Vec3(0.4, 0.0, 0.4), true, 0);
    }

    public static void addForPos(FoliageReplacerBase replacer, int height, BlockPos pos, Vec3 randPosVar, boolean biomeColorize) {
        FoliageEnhancerShader.addForPos(replacer, height, pos, randPosVar, biomeColorize, 0);
    }

    public static void addForPos(FoliageReplacerBase replacer, int height, BlockPos pos, Vec3 randPosVar, boolean biomeColorize, int colorizeOffset) {
        FoliageEnhancerShader.addForPos(replacer, height, pos, randPosVar, biomeColorize, colorizeOffset, null);
    }

    public static void addForPos(FoliageReplacerBase replacer, int height, BlockPos pos, Vec3 randPosVar, boolean biomeColorize, int colorizeOffset, Vec3 extraPos) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Random rand = new Random();
        FoliageLocationData data = new FoliageLocationData(replacer);
        float randX = 0.0f;
        float randZ = 0.0f;
        if (randPosVar != null) {
            randX = (rand.nextFloat() - rand.nextFloat()) * (float)randPosVar.xCoord;
            randZ = (rand.nextFloat() - rand.nextFloat()) * (float)randPosVar.zCoord;
        }
        int clutterSize = 2;
        int meshesPerLayer = 2;
        if (replacer instanceof FoliageReplacerCross) {
            clutterSize = 2 * height;
        }
        if (replacer instanceof FoliageReplacerCrossGrass) {
            clutterSize = 4;
        }
        for (int i = 0; i < clutterSize; ++i) {
            int heightIndex = i / meshesPerLayer;
            if (replacer instanceof FoliageReplacerCrossGrass) {
                heightIndex = 0;
            }
            TextureAtlasSprite sprite = replacer.sprites.get(0);
            if (replacer instanceof FoliageReplacerCross && heightIndex < replacer.sprites.size()) {
                sprite = replacer.sprites.get(heightIndex);
            }
            Foliage foliage = new Foliage(sprite);
            foliage.setPosition(pos.func_177982_a(0, 0, 0));
            foliage.prevPosY = foliage.posY;
            foliage.heightIndex = heightIndex;
            Vec3d vec = world.func_180495_p(pos).func_191059_e((IBlockAccess)world, pos);
            foliage.posX += (double)(0.5f + randX) + vec.field_72450_a;
            foliage.prevPosX = foliage.posX;
            foliage.posZ += (double)(0.5f + randZ) + vec.field_72449_c;
            if (extraPos != null) {
                foliage.posX += extraPos.xCoord;
                foliage.posZ += extraPos.zCoord;
            }
            foliage.prevPosZ = foliage.posZ;
            foliage.rotationYaw = 0.0f;
            foliage.rotationYaw = world.field_73012_v.nextInt(360);
            foliage.rotationYaw = 45.0f;
            if ((i + 1) % 2 == 0) {
                foliage.rotationYaw += 90.0f;
            }
            if (replacer instanceof FoliageReplacerCrossGrass) {
                foliage.rotationYaw = 45.0f;
                double dist = 0.17;
                if (i == 0) {
                    foliage.rotationYaw += 90.0f;
                    foliage.posX += dist;
                    foliage.posZ += dist;
                } else if (i == 1) {
                    foliage.rotationYaw += 90.0f;
                    foliage.posX -= dist;
                    foliage.posZ -= dist;
                } else if (i == 2) {
                    foliage.posX += dist;
                    foliage.posZ -= dist;
                } else if (i == 3) {
                    foliage.posX -= dist;
                    foliage.posZ += dist;
                }
            }
            foliage.looseness = replacer.looseness;
            foliage.particleScale = (float)((double)foliage.particleScale / 0.2);
            if (biomeColorize) {
                int color = Minecraft.func_71410_x().func_184125_al().func_186724_a(world.func_180495_p(pos.func_177981_b(colorizeOffset)), (IBlockAccess)world, pos.func_177981_b(colorizeOffset), 0);
                foliage.particleRed = (float)(color >> 16 & 0xFF) / 255.0f;
                foliage.particleGreen = (float)(color >> 8 & 0xFF) / 255.0f;
                foliage.particleBlue = (float)(color & 0xFF) / 255.0f;
                if (replacer instanceof FoliageReplacerCrossGrass) {
                    color = Minecraft.func_71410_x().func_184125_al().func_186724_a(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS), (IBlockAccess)world, pos.func_177981_b(colorizeOffset), 0);
                    foliage.particleRed = (float)(color >> 16 & 0xFF) / 255.0f;
                    foliage.particleGreen = (float)(color >> 8 & 0xFF) / 255.0f;
                    foliage.particleBlue = (float)(color & 0xFF) / 255.0f;
                }
            }
            foliage.brightnessCache = CoroUtilBlockLightCache.brightnessPlayer;
            if ((i + 1) % 2 == 0) {
                // empty if block
            }
            data.listFoliage.add(foliage);
            ExtendedRenderer.foliageRenderer.getFoliageForSprite(sprite).add(foliage);
        }
        lookupPosToFoliage.put(pos, data);
    }

    public void addForPosSeaweed(BlockPos pos) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Random rand = new Random();
        IBlockState state = world.func_180495_p(pos.func_177977_b());
        ArrayList<Foliage> listClutter = new ArrayList<Foliage>();
        int heightIndex = 0;
        float variance = 0.4f;
        float randX = (rand.nextFloat() - rand.nextFloat()) * variance;
        float randZ = (rand.nextFloat() - rand.nextFloat()) * variance;
        int clutterSize = 14;
        clutterSize = rand.nextInt(7) * 2;
        for (int i = 0; i < clutterSize; ++i) {
            heightIndex = i / 2;
            TextureAtlasSprite sprite = (TextureAtlasSprite)ParticleRegistry.listSeaweed.get(heightIndex);
            Foliage foliage = new Foliage(sprite);
            foliage.setPosition(pos.func_177982_a(0, 0, 0));
            foliage.posY += 0.0;
            foliage.prevPosY = foliage.posY;
            foliage.heightIndex = heightIndex;
            foliage.posX += (double)(0.5f + randX);
            foliage.prevPosX = foliage.posX;
            foliage.posZ += (double)(0.5f + randZ);
            foliage.prevPosZ = foliage.posZ;
            foliage.rotationYaw = 0.0f;
            foliage.rotationYaw = world.field_73012_v.nextInt(360);
            foliage.rotationYaw = 45.0f;
            if ((i + 1) % 2 == 0) {
                foliage.rotationYaw += 90.0f;
            }
            foliage.rotationYaw = 0.0f;
            if ((i + 1) % 2 == 0) {
                foliage.rotationYaw = 1.0f;
            }
            foliage.particleScale = (float)((double)foliage.particleScale / 0.2);
            int color = Minecraft.func_71410_x().func_184125_al().func_186724_a(state, (IBlockAccess)world, pos.func_177977_b(), 0);
            foliage.particleRed = (float)(color >> 16 & 0xFF) / 255.0f;
            foliage.particleGreen = (float)(color >> 8 & 0xFF) / 255.0f;
            foliage.particleBlue = (float)(color & 0xFF) / 255.0f;
            foliage.particleRed = 1.0f;
            foliage.particleGreen = 1.0f;
            foliage.particleBlue = 1.0f;
            foliage.brightnessCache = CoroUtilBlockLightCache.brightnessPlayer;
            if ((i + 1) % 2 == 0) {
                // empty if block
            }
            listClutter.add(foliage);
            ExtendedRenderer.foliageRenderer.getFoliageForSprite(sprite).add(foliage);
        }
    }

    static {
        try {
            multipartModelClass = Class.forName("net.minecraftforge.client.model.ModelLoader$MultipartModel");
            multipartPartModels = multipartModelClass.getDeclaredField("partModels");
            multipartPartModels.setAccessible(true);
            vanillaModelWrapperClass = Class.forName("net.minecraftforge.client.model.ModelLoader$VanillaModelWrapper");
            modelWrapperModel = vanillaModelWrapperClass.getDeclaredField("model");
            modelWrapperModel.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException | SecurityException e) {
            throw Throwables.propagate((Throwable)e);
        }
        lookupBackupReplacedModels = new HashMap();
    }
}

