/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.client.event;

import extendedrenderer.ExtendedRenderer;
import extendedrenderer.render.FoliageRenderer;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.mrbt0907.configex.ConfigManager;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.api.WindReader;
import net.mrbt0907.weather2.client.NewSceneEnhancer;
import net.mrbt0907.weather2.client.foliage.FoliageEnhancerShader;
import net.mrbt0907.weather2.client.gui.GuiEZConfig;
import net.mrbt0907.weather2.client.weather.WeatherManagerClient;
import net.mrbt0907.weather2.config.ClientConfigData;
import net.mrbt0907.weather2.config.ConfigFoliage;
import net.mrbt0907.weather2.config.ConfigMisc;
import net.mrbt0907.weather2.config.EZConfigParser;
import net.mrbt0907.weather2.network.packets.PacketData;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.util.WeatherUtilSound;
import net.mrbt0907.weather2.weather.EntityRendererEX;
import org.lwjgl.input.Mouse;

public class ClientTickHandler {
    public static World lastWorld;
    public static WeatherManagerClient weatherManager;
    public static FoliageEnhancerShader foliageEnhancer;
    public static ClientConfigData clientConfigData;
    public boolean hasOpenedConfig = false;
    public GuiButton configButton;
    public EntityRenderer oldRenderer;
    public float smoothAngle = 0.0f;
    public float smoothAngleRotationalVelAccel = 0.0f;
    public float smoothAngleAdj = 0.1f;
    public int prevDir = 0;
    public boolean extraGrassLast = ConfigFoliage.enable_extra_grass;
    public boolean op = false;

    public ClientTickHandler() {
        new Thread((Runnable)NewSceneEnhancer.instance(), "Weather2 New Scene Enhancer").start();
        if (foliageEnhancer == null) {
            foliageEnhancer = new FoliageEnhancerShader();
            new Thread((Runnable)foliageEnhancer, "Weather2 Foliage Enhancer").start();
        }
        clientConfigData = new ClientConfigData();
        this.op = ConfigManager.getPermissionLevel() > 3;
    }

    public void onRenderScreenTick() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.field_71462_r instanceof GuiIngameMenu) {
            ScaledResolution scaledresolution = new ScaledResolution(mc);
            int i = scaledresolution.func_78326_a();
            int j = scaledresolution.func_78328_b();
            int k = Mouse.getX() * i / mc.field_71443_c;
            int l = j - Mouse.getY() * j / mc.field_71440_d - 1;
            this.configButton = new GuiButton(0, i / 2 - 100, 0, 200, 20, "Weather2 EZ Config");
            this.configButton.func_191745_a(mc, k, l, 1.0f);
            if (k >= this.configButton.field_146128_h && l >= this.configButton.field_146129_i && k < this.configButton.field_146128_h + 200 && l < this.configButton.field_146129_i + 20 && Mouse.isButtonDown((int)0)) {
                mc.func_147108_a((GuiScreen)new GuiEZConfig());
            }
        }
    }

    public void onTickInGUI(GuiScreen guiscreen) {
    }

    public void onTickInGame() {
        if (ConfigMisc.toaster_pc_mode) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        WorldClient world = mc.field_71441_e;
        if (ConfigMisc.proxy_render_override) {
            if (!(mc.field_71460_t instanceof EntityRendererEX)) {
                this.oldRenderer = mc.field_71460_t;
                EntityRendererEX temp = new EntityRendererEX(mc, mc.func_110442_L());
                mc.field_71460_t = temp;
            }
        } else if (mc.field_71460_t instanceof EntityRendererEX) {
            mc.field_71460_t = this.oldRenderer != null ? this.oldRenderer : new EntityRenderer(mc, mc.func_110442_L());
        }
        if (world != null) {
            ClientTickHandler.checkClientWeather();
            weatherManager.tick();
            Weather2.clientChunkUtil.tick();
            if (!ConfigMisc.aesthetic_mode && ConfigMisc.enable_forced_clouds_off && world.field_73011_w.getDimension() == 0) {
                mc.field_71474_y.field_74345_l = 0;
            }
            if (EZConfigParser.isEffectsEnabled(world.field_73011_w.getDimension())) {
                NewSceneEnhancer.instance().tick();
            }
            if (!EZConfigParser.isWeatherEnabled(world.field_73011_w.getDimension()) && weatherManager.getFronts().size() > 1) {
                Weather2.debug("Removing all storms as the dimension weather is disabled");
                weatherManager.reset(false);
            }
            Maths.Vec3 pos = mc.field_71439_g == null ? null : new Maths.Vec3(mc.field_71439_g.func_180425_c());
            float windDir = WindReader.getWindAngle((World)world, pos);
            float windSpeed = WindReader.getWindSpeed((World)world, pos) * 0.25f;
            float diff = Math.abs(windDir - this.smoothAngle);
            if (diff > 10.0f) {
                if (this.smoothAngle > 180.0f) {
                    this.smoothAngle -= 360.0f;
                }
                if (this.smoothAngle < -180.0f) {
                    this.smoothAngle += 360.0f;
                }
                float bestMove = Maths.wrapDegrees(windDir - this.smoothAngle);
                this.smoothAngleAdj = windSpeed;
                if (Math.abs(bestMove) < 180.0f) {
                    float realAdj = this.smoothAngleAdj;
                    if (realAdj * 2.0f > windSpeed) {
                        if (bestMove > 0.0f) {
                            this.smoothAngleRotationalVelAccel -= realAdj;
                            if (this.prevDir < 0) {
                                this.smoothAngleRotationalVelAccel = 0.0f;
                            }
                            this.prevDir = 1;
                        } else if (bestMove < 0.0f) {
                            this.smoothAngleRotationalVelAccel += realAdj;
                            if (this.prevDir > 0) {
                                this.smoothAngleRotationalVelAccel = 0.0f;
                            }
                            this.prevDir = -1;
                        }
                    }
                    if ((double)this.smoothAngleRotationalVelAccel > 0.3 || (double)this.smoothAngleRotationalVelAccel < -0.3) {
                        this.smoothAngle += this.smoothAngleRotationalVelAccel * 0.3f;
                    }
                    this.smoothAngleRotationalVelAccel *= 0.8f;
                }
            }
            if (!Minecraft.func_71410_x().func_147113_T()) {
                ExtendedRenderer.foliageRenderer.windDir = this.smoothAngle;
                float rate = 0.005f;
                if (ExtendedRenderer.foliageRenderer.windSpeedSmooth != windSpeed) {
                    ExtendedRenderer.foliageRenderer.windSpeedSmooth = ExtendedRenderer.foliageRenderer.windSpeedSmooth < windSpeed ? (ExtendedRenderer.foliageRenderer.windSpeedSmooth + rate > windSpeed ? windSpeed : (ExtendedRenderer.foliageRenderer.windSpeedSmooth += rate)) : (ExtendedRenderer.foliageRenderer.windSpeedSmooth - rate < windSpeed ? windSpeed : (ExtendedRenderer.foliageRenderer.windSpeedSmooth -= rate));
                }
                float baseTimeChangeRate = 60.0f;
                FoliageRenderer.windTime = (long)((float)FoliageRenderer.windTime + (0.0f + baseTimeChangeRate * ExtendedRenderer.foliageRenderer.windSpeedSmooth));
            }
        } else {
            ClientTickHandler.resetClientWeather();
        }
    }

    public static void resetClientWeather() {
        if (weatherManager != null) {
            Weather2.debug("Weather2: Detected old WeatherManagerClient with unloaded world, clearing its data");
            WeatherUtilSound.reset();
            Weather2.clientChunkUtil.clearCache();
            weatherManager.reset(true);
            weatherManager = null;
        }
    }

    public static void checkClientWeather() {
        try {
            WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
            if (weatherManager == null || world != lastWorld) {
                ClientTickHandler.init((World)world);
            }
        }
        catch (Exception ex) {
            Weather2.debug("Weather2: Warning, client received packet before it was ready to use, and failed to init client weather due to null world");
        }
    }

    public static void init(World world) {
        if (weatherManager != null) {
            Weather2.debug("Weather2: Detected old WeatherManagerClient with active world, clearing its data");
            weatherManager.reset(true);
        }
        Weather2.debug("Weather2: Initializing WeatherManagerClient for client world and requesting full sync");
        lastWorld = world;
        weatherManager = new WeatherManagerClient(world);
        PacketData.sync();
    }

    static void getField(Field field, Object newValue) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, newValue);
    }
}

