/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.client.block;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.mrbt0907.weather2.api.weather.WeatherEnum;
import net.mrbt0907.weather2.block.TileRadar;
import net.mrbt0907.weather2.client.NewSceneEnhancer;
import net.mrbt0907.weather2.client.event.ClientTickHandler;
import net.mrbt0907.weather2.client.weather.WeatherManagerClient;
import net.mrbt0907.weather2.config.ConfigMisc;
import net.mrbt0907.weather2.config.ConfigStorm;
import net.mrbt0907.weather2.registry.ParticleRegistry;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.util.WeatherUtil;
import net.mrbt0907.weather2.weather.storm.StormObject;

public class RenderRadar
extends TileEntitySpecialRenderer<TileEntity> {
    public void func_192841_a(TileEntity tile, double x, double y, double z, float var8, int destroyStage, float alpha) {
        EntityPlayerSP player;
        TileRadar radar = (TileRadar)tile;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.1f), (float)((float)z + 0.5f));
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179132_a((boolean)false);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldrenderer.func_181662_b(-((double)radar.renderRange - 0.5), 0.0, -((double)radar.renderRange - 0.5)).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(-((double)radar.renderRange - 0.5), 0.0, (double)radar.renderRange - 0.5).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        worldrenderer.func_181662_b((double)radar.renderRange - 0.5, 0.0, (double)radar.renderRange - 0.5).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        worldrenderer.func_181662_b((double)radar.renderRange - 0.5, 0.0, -((double)radar.renderRange - 0.5)).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        float playerViewY = Minecraft.func_71410_x().func_175598_ae().field_78735_i;
        this.renderLivingLabel("\u00a76|", x, y + (double)1.2f, z, 1, 10, 10, playerViewY, 1.0f);
        if (ConfigMisc.debug_mode_radar && (player = Minecraft.func_71410_x().field_71439_g) != null && ClientTickHandler.weatherManager != null) {
            NewSceneEnhancer scene = NewSceneEnhancer.instance();
            WeatherManagerClient wm = ClientTickHandler.weatherManager;
            float precipStr = Math.abs(scene.rain);
            String overcast = Math.round(scene.overcast * 100.0f) + "%";
            this.renderLivingLabel("\u00a7 Fog Strength: " + Math.round(scene.fogMult * 300.0f) + "%", x, y + (double)1.8f, z, 1, 10, 10, playerViewY, 1.0f);
            this.renderLivingLabel("\u00a7 Vanilla Weather Time: " + wm.weatherRainTime, x, y + (double)1.9f, z, 1, 10, 10, playerViewY, 1.0f);
            this.renderLivingLabel("\u00a7 Client Weather: " + (player.field_70170_p.func_72911_I() ? "Thundering" : (precipStr >= 0.5f ? "Heavy Rain" : (precipStr >= 0.15f ? "Light Rain" : (precipStr > 0.01f ? "Drizzle" : "Clear")))), x, y + 2.0, z, 1, 10, 10, playerViewY, 1.0f);
            this.renderLivingLabel("\u00a7 Server Weather: " + (wm.weatherID == 2 ? "Thunder" : (wm.weatherID == 1 ? "Rain" : "Clear")), x, y + (double)2.1f, z, 1, 10, 10, playerViewY, 1.0f);
            this.renderLivingLabel("\u00a7 Precipitation Strength: " + Math.round(precipStr * 100.0f) + "%", x, y + (double)2.2f, z, 1, 10, 10, playerViewY, 1.0f);
            this.renderLivingLabel("\u00a7 Overcast Strength: " + overcast, x, y + (double)2.3f, z, 1, 10, 10, playerViewY, 1.0f);
            this.renderLivingLabel("\u00a7 -------------------------", x, y + (double)2.4f, z, 1, 10, 10, playerViewY, 1.0f);
            if (radar.system != null && radar.system instanceof StormObject) {
                StormObject system = (StormObject)radar.system;
                this.renderLivingLabel("\u00a7 Rain/Hail: " + Maths.clamp((float)Math.round((system.rain - 100.0f) * 10.0f / 3.0f) * 0.1f, 0.0f, 100.0f) + "%/" + Maths.clamp(system.hail - 100.0f, 0.0f, 100.0f) + "%", x, y + 2.5, z, 1, 10, 10, playerViewY, 1.0f);
                this.renderLivingLabel("\u00a7 Stage Complete: " + (system.intensity - (float)system.stage + 1.0f) * 100.0f + "%", x, y + (double)2.6f, z, 1, 10, 10, playerViewY, 1.0f);
                this.renderLivingLabel("\u00a7 Current Funnel Wind Speed: " + (long)WeatherUtil.toMph(system.windSpeed) + " MPH", x, y + (double)2.7f, z, 1, 10, 10, playerViewY, 1.0f);
                this.renderLivingLabel("\u00a7 Current Funnel Size: " + (long)system.funnelSize + " Blocks", x, y + (double)2.8f, z, 1, 10, 10, playerViewY, 1.0f);
                this.renderLivingLabel("\u00a7 Current Stage/MaxStage: " + system.stage + "/" + system.stageMax, x, y + (double)2.9f, z, 1, 10, 10, playerViewY, 1.0f);
                this.renderLivingLabel("\u00a7 Lifespan Multiplier: " + ConfigStorm.storm_lifespan_min / (double)system.intensityRate * 1000.0 + "%", x, y + 3.0, z, 1, 10, 10, playerViewY, 1.0f);
                this.renderLivingLabel("\u00a7 Size Multiplier: " + system.sizeRate * 100.0f + "%", x, y + (double)3.1f, z, 1, 10, 10, playerViewY, 1.0f);
                this.renderLivingLabel("\u00a7 Is Violent: " + system.isViolent, x, y + (double)3.2f, z, 1, 10, 10, playerViewY, 1.0f);
                this.renderLivingLabel("\u00a7 UUID: " + system.getUUID(), x, y + (double)3.3f, z, 1, 10, 10, playerViewY, 1.0f);
                String stage = radar.system.getName();
                if (system.isDying) {
                    stage = stage + "  (Dying)";
                }
                this.renderLivingLabel("\u00a7 " + TextFormatting.BOLD + stage, x, y + (double)3.4f, z, 1, 10, 10, playerViewY, 1.0f);
            }
            this.renderLivingLabel("\u00a7 Radar Tier " + radar.getTier() + " (R:" + radar.pingRange + ")", x, y + 3.5, z, 1, 10, 10, playerViewY, 1.0f);
        }
        BlockPos pos = radar.func_174877_v();
        radar.systems.forEach(so -> {
            GlStateManager.func_179094_E();
            Maths.Vec3 posRenderOffset = so.pos.copy();
            posRenderOffset.posX -= (double)pos.func_177958_n();
            posRenderOffset.posZ -= (double)pos.func_177952_p();
            posRenderOffset.posX /= radar.pingRange;
            posRenderOffset.posZ /= radar.pingRange;
            posRenderOffset.posX *= (double)radar.renderRange - 0.5;
            posRenderOffset.posZ *= (double)radar.renderRange - 0.5;
            GlStateManager.func_179137_b((double)posRenderOffset.posX, (double)0.0, (double)posRenderOffset.posZ);
            if (radar.showRating) {
                FontRenderer font = Minecraft.func_71410_x().func_175598_ae().func_78716_a();
                this.renderLivingLabel(so.typeName, x, y + (double)(so.type == 0 ? 1.54f : 1.5f), z, 1, font.func_78256_a(so.typeName), 5, playerViewY, radar.renderAlpha);
            }
            if (so.type == 1 || so.type == 2) {
                switch (so.stage) {
                    case 0: {
                        this.renderIconNew(x, y + (double)1.4f, z, 16, 16, 0.0f, playerViewY, 0.0f, radar.renderAlpha * 0.5f, ParticleRegistry.radarIconCloud);
                        break;
                    }
                    case 1: {
                        if (so.isRaining) {
                            if (so.name.toLowerCase().contains("snowstorm")) {
                                this.renderIconNew(x, y + (double)1.4f, z, 16, 16, 0.0f, playerViewY, 0.0f, radar.renderAlpha, ParticleRegistry.radarIconSnow);
                                break;
                            }
                            this.renderIconNew(x, y + (double)1.4f, z, 16, 16, 0.0f, playerViewY, 0.0f, radar.renderAlpha, ParticleRegistry.radarIconRain);
                            break;
                        }
                        this.renderIconNew(x, y + (double)1.4f, z, 16, 16, 0.0f, playerViewY, 0.0f, radar.renderAlpha, ParticleRegistry.radarIconCloud);
                        break;
                    }
                    case 2: {
                        this.renderIconNew(x, y + (double)1.4f, z, 16, 16, 0.0f, playerViewY, 0.0f, radar.renderAlpha, ParticleRegistry.radarIconLightning);
                        break;
                    }
                    case 3: {
                        this.renderIconNew(x, y + (double)1.4f, z, 16, 16, 0.0f, playerViewY, 0.0f, radar.renderAlpha, ParticleRegistry.radarIconLightning);
                        this.renderIconNew(x, y + (double)1.4f, z, 16, 16, 0.0f, playerViewY, 0.0f, radar.renderAlpha, ParticleRegistry.radarIconWind);
                        break;
                    }
                    default: {
                        if (so.type == 1) {
                            this.renderIconNew(x, y + (double)1.4f, z, 16, 16, 0.0f, playerViewY, 0.0f, radar.renderAlpha, ParticleRegistry.radarIconTornado);
                            break;
                        }
                        this.renderIconNew(x, y + (double)1.4f, z, 16, 16, 0.0f, playerViewY, 0.0f, radar.renderAlpha, ParticleRegistry.radarIconCyclone);
                    }
                }
                if (so.isHailing) {
                    this.renderIconNew(x, y + (double)1.4f, z, 16, 16, 0.0f, playerViewY, 0.0f, radar.renderAlpha, ParticleRegistry.radarIconHail);
                }
                if (ConfigMisc.debug_mode_radar && radar.system != null && so.uuid.equals(radar.system.getUUID())) {
                    this.renderLivingLabel(TextFormatting.GOLD + "" + TextFormatting.BOLD + "|", x, y + (double)1.2f, z, 1, 5, 5, playerViewY, radar.renderAlpha);
                } else if (so.stage == WeatherEnum.Stage.NORMAL.getStage()) {
                    this.renderLivingLabel(TextFormatting.GRAY + "|", x, y + (double)1.2f, z, 1, 5, 5, playerViewY, radar.renderAlpha * 0.35f);
                } else if (so.isDying) {
                    this.renderLivingLabel(TextFormatting.RED + "|", x, y + (double)1.2f, z, 1, 5, 5, playerViewY, radar.renderAlpha);
                } else {
                    this.renderLivingLabel(TextFormatting.GREEN + "|", x, y + (double)1.2f, z, 1, 5, 5, playerViewY, radar.renderAlpha);
                }
            } else if (so.type == 0) {
                int type = so.name.toLowerCase().contains("stationary") ? 0 : (so.name.toLowerCase().contains("warm") ? 2 : (so.name.toLowerCase().contains("cold") ? 1 : 3));
                this.renderIconNew(x, y + (double)1.12f, z, (int)(64.0f * radar.renderRange), (int)(64.0f * radar.renderRange), 90.0f, 0.0f, so.angle, radar.renderAlpha, type == 0 ? ParticleRegistry.radarIconStationaryFront : (type == 1 ? ParticleRegistry.radarIconColdFront : (type == 2 ? ParticleRegistry.radarIconWarmFront : ParticleRegistry.radarIconOccludedFront)));
                if (!so.isDying) {
                    this.renderLivingLabel(TextFormatting.BOLD + "" + TextFormatting.DARK_GREEN + "|", x, y + (double)1.22f, z, 1, 5, 5, playerViewY, radar.renderAlpha);
                } else {
                    this.renderLivingLabel(TextFormatting.BOLD + "" + TextFormatting.DARK_RED + "|", x, y + (double)1.22f, z, 1, 5, 5, playerViewY, radar.renderAlpha);
                }
            } else {
                this.renderIconNew(x, y + (double)1.4f, z, 16, 16, 0.0f, playerViewY, 0.0f, radar.renderAlpha, ParticleRegistry.radarIconSandstorm);
                if (!so.isDying) {
                    this.renderLivingLabel("\u00a72|", x, y + (double)1.2f, z, 1, 5, 5, playerViewY, radar.renderAlpha);
                } else {
                    this.renderLivingLabel("\u00a74|", x, y + (double)1.2f, z, 1, 5, 5, playerViewY, radar.renderAlpha);
                }
            }
            GlStateManager.func_179137_b((double)(-posRenderOffset.posX), (double)0.0, (double)(-posRenderOffset.posZ));
            GlStateManager.func_179121_F();
        });
    }

    protected void renderLivingLabel(String par2Str, double par3, double par5, double par7, int par9, float angle, float alpha) {
        this.renderLivingLabel(par2Str, par3, par5, par7, par9, 200, 80, angle, alpha);
    }

    protected void renderLivingLabel(String par2Str, double par3, double par5, double par7, int par9, int width, int height, float angle, float alpha) {
        int hexAlpha = (int)(255.0f * alpha) << 24;
        int c1 = 0xFFFFFF;
        c1 += hexAlpha;
        int borderSize = 2;
        GlStateManager.func_179129_p();
        GlStateManager.func_179090_x();
        FontRenderer var11 = Minecraft.func_71410_x().func_175598_ae().func_78716_a();
        float var12 = 0.6f;
        float var13 = 0.016666668f * var12;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(par3 + 0.5), (double)par5, (double)(par7 + 0.5));
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-angle), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-var13), (float)(-var13), (float)var13);
        GlStateManager.func_179140_f();
        if (par9 == 0) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            Tessellator var14 = Tessellator.func_178181_a();
            BufferBuilder worldrenderer = var14.func_178180_c();
            int var15 = 0;
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            worldrenderer.func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181662_b((double)(-width / 2 - borderSize), (double)(-borderSize + var15), 0.0).func_181675_d();
            worldrenderer.func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181662_b((double)(-width / 2 - borderSize), (double)(height + var15), 0.0).func_181675_d();
            worldrenderer.func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181662_b((double)(width / 2 + borderSize), (double)(height + var15), 0.0).func_181675_d();
            worldrenderer.func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181662_b((double)(width / 2 + borderSize), (double)(-borderSize + var15), 0.0).func_181675_d();
            var14.func_78381_a();
        }
        GlStateManager.func_179098_w();
        var11.func_78276_b(par2Str, -width / 2 + borderSize, 0, c1);
        GlStateManager.func_179145_e();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GlStateManager.func_179121_F();
        GlStateManager.func_179089_o();
    }

    public void renderIconNew(double x, double y, double z, int width, int height, float angleX, float angleY, float angleZ, float alpha, TextureAtlasSprite parIcon) {
        float f6 = parIcon.func_94209_e();
        float f7 = parIcon.func_94212_f();
        float f9 = parIcon.func_94206_g();
        float f8 = parIcon.func_94210_h();
        float var12 = 0.6f;
        float var13 = 0.016666668f * var12;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y), (float)((float)z + 0.5f));
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)angleX, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-angleY), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)angleZ, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)(-var13), (float)(-var13), (float)var13);
        int borderSize = 2;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        GlStateManager.func_179106_n();
        this.func_147499_a(TextureMap.field_110575_b);
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        worldrenderer.func_181662_b((double)(-width / 2 - borderSize), (double)(-borderSize), 0.0).func_187315_a((double)f6, (double)f9).func_181666_a(r, g, b, alpha).func_181675_d();
        worldrenderer.func_181662_b((double)(-width / 2 - borderSize), (double)height, 0.0).func_187315_a((double)f6, (double)f8).func_181666_a(r, g, b, alpha).func_181675_d();
        worldrenderer.func_181662_b((double)(width / 2 + borderSize), (double)height, 0.0).func_187315_a((double)f7, (double)f8).func_181666_a(r, g, b, alpha).func_181675_d();
        worldrenderer.func_181662_b((double)(width / 2 + borderSize), (double)(-borderSize), 0.0).func_187315_a((double)f7, (double)f9).func_181666_a(r, g, b, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }
}

