/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.client;

import CoroUtil.api.weather.IWindHandler;
import CoroUtil.config.ConfigCoroUtil;
import CoroUtil.util.ChunkCoordinatesBlock;
import CoroUtil.util.CoroUtilBlock;
import CoroUtil.util.CoroUtilEntOrParticle;
import CoroUtil.util.CoroUtilMisc;
import CoroUtil.util.CoroUtilPhysics;
import CoroUtil.util.Vec3;
import extendedrenderer.EventHandler;
import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.behavior.ParticleBehaviorFogGround;
import extendedrenderer.particle.behavior.ParticleBehaviorMiniTornado;
import extendedrenderer.particle.behavior.ParticleBehaviorSandstorm;
import extendedrenderer.particle.behavior.ParticleBehaviors;
import extendedrenderer.particle.entity.EntityRotFX;
import extendedrenderer.particle.entity.ParticleTexExtraRender;
import extendedrenderer.particle.entity.ParticleTexFX;
import extendedrenderer.particle.entity.ParticleTexLeafColor;
import extendedrenderer.render.RotatingParticleManager;
import extendedrenderer.shader.Matrix4fe;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleFlame;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.api.WindReader;
import net.mrbt0907.weather2.api.weather.WeatherEnum;
import net.mrbt0907.weather2.client.entity.particle.EntityWaterfallFX;
import net.mrbt0907.weather2.client.entity.particle.ParticleSandstorm;
import net.mrbt0907.weather2.client.event.ClientTickHandler;
import net.mrbt0907.weather2.client.foliage.FoliageEnhancerShader;
import net.mrbt0907.weather2.client.weather.WeatherManagerClient;
import net.mrbt0907.weather2.client.weather.tornado.TornadoFunnel;
import net.mrbt0907.weather2.config.ConfigMisc;
import net.mrbt0907.weather2.config.ConfigParticle;
import net.mrbt0907.weather2.config.ConfigStorm;
import net.mrbt0907.weather2.config.ConfigVolume;
import net.mrbt0907.weather2.config.EZConfigParser;
import net.mrbt0907.weather2.registry.SoundRegistry;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.util.WeatherUtil;
import net.mrbt0907.weather2.util.WeatherUtilBlock;
import net.mrbt0907.weather2.util.WeatherUtilEntity;
import net.mrbt0907.weather2.util.WeatherUtilParticle;
import net.mrbt0907.weather2.util.WeatherUtilSound;
import net.mrbt0907.weather2.weather.WindManager;
import net.mrbt0907.weather2.weather.storm.SandstormObject;
import net.mrbt0907.weather2.weather.storm.StormObject;
import net.mrbt0907.weather2.weather.storm.WeatherObject;

@SideOnly(value=Side.CLIENT)
public class SceneEnhancer
implements Runnable {
    public World lastWorldDetected = null;
    public static ParticleBehaviors pm;
    public static List<Particle> spawnQueueNormal;
    public static List<Particle> spawnQueue;
    public static long threadLastWorldTickTime;
    public static int lastTickFoundBlocks;
    public static long lastTickAmbient;
    public static long lastTickAmbientThreaded;
    public static ArrayList<ChunkCoordinatesBlock> soundLocations;
    public static HashMap<ChunkCoordinatesBlock, Long> soundTimeLocations;
    public static Block SOUNDMARKER_WATER;
    public static Block SOUNDMARKER_LEAVES;
    public static float curPrecipStr;
    public static float curPrecipStrTarget;
    public static float curOvercastStr;
    public static float curOvercastStrTarget;
    public static float curDampness;
    public static ParticleBehaviorMiniTornado miniTornado;
    public static ParticleBehaviorFogGround particleBehaviorFog;
    public static Vec3d vecWOP;
    public static double distToStormThreshold;
    public static double distToStorm;
    public static float fogRed;
    public static float fogRedTarget;
    public static float fogRedOrig;
    public static float fogGreen;
    public static float fogGreenTarget;
    public static float fogGreenOrig;
    public static float fogBlue;
    public static float fogBlueTarget;
    public static float fogBlueOrig;
    public static float fogDensity;
    public static float fogDensityTarget;
    public static float fogStart;
    public static float fogEnd;
    public static float fogMult;
    public static float fogMultTarget;
    public static float fogDistance;
    public static float adjustAmountTargetPocketSandOverride;
    public static boolean isPlayerOutside;
    public static ParticleBehaviorSandstorm particleBehavior;
    public static ParticleTexExtraRender testParticle;
    public static EntityRotFX testParticle2;
    private static List<BlockPos> listPosRandom;
    public static List<EntityRotFX> testParticles;
    public static Matrix4fe matrix;
    public static Matrix4fe matrix2;
    public static Vector3f vec;
    public static Vector3f vec2;
    public static TornadoFunnel funnel;
    private static WeatherObject wo;

    public SceneEnhancer() {
        pm = new ParticleBehaviors(null);
        listPosRandom.clear();
        listPosRandom.add(new BlockPos(0, -1, 0));
        listPosRandom.add(new BlockPos(1, 0, 0));
        listPosRandom.add(new BlockPos(-1, 0, 0));
        listPosRandom.add(new BlockPos(0, 0, 1));
        listPosRandom.add(new BlockPos(0, 0, -1));
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.tickClientThreaded();
                    Thread.sleep(ConfigParticle.scene_enhancer_thread_delay);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void tickClient() {
        if (!WeatherUtil.isPaused() && !ConfigMisc.toaster_pc_mode) {
            Minecraft mc = FMLClientHandler.instance().getClient();
            mc.field_71424_I.func_76320_a("particleSpawning");
            this.tryParticleSpawning();
            mc.field_71424_I.func_76318_c("tickRain");
            SceneEnhancer.tickRainRates();
            mc.field_71424_I.func_76318_c("tickPrecipitation");
            this.tickParticlePrecipitation();
            mc.field_71424_I.func_76318_c("tickSoundA");
            this.trySoundPlaying();
            mc.field_71424_I.func_76318_c("tickSoundB");
            SceneEnhancer.tickSounds();
            if (mc.field_71441_e != null && this.lastWorldDetected != mc.field_71441_e) {
                this.lastWorldDetected = mc.field_71441_e;
                this.reset();
            }
            mc.field_71424_I.func_76318_c("tickWind");
            SceneEnhancer.tryWind((World)mc.field_71441_e);
            mc.field_71424_I.func_76318_c("tickFog");
            SceneEnhancer.tickFog();
            mc.field_71424_I.func_76318_c("tickStormFog");
            SceneEnhancer.tickStormFog();
            mc.field_71424_I.func_76318_c("tickParticle");
            if (particleBehavior == null) {
                particleBehavior = new ParticleBehaviorSandstorm(null);
            }
            particleBehavior.tickUpdateList();
            if (ConfigCoroUtil.foliageShaders && EventHandler.queryUseOfShaders()) {
                if (!FoliageEnhancerShader.useThread && mc.field_71441_e.func_82737_E() % 40L == 0L) {
                    FoliageEnhancerShader.tickClientThreaded();
                }
                if (mc.field_71441_e.func_82737_E() % 5L == 0L) {
                    FoliageEnhancerShader.tickClientCloseToPlayer();
                }
            }
            mc.field_71424_I.func_76319_b();
        }
    }

    public void tickClientThreaded() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.field_71441_e != null && mc.field_71439_g != null && EZConfigParser.isEffectsEnabled(mc.field_71441_e.field_73011_w.getDimension()) && ClientTickHandler.weatherManager != null) {
            if (mc.field_71441_e.func_82737_E() % 10L == 0L) {
                wo = ClientTickHandler.weatherManager.getClosestWeather(new Maths.Vec3(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v), ConfigParticle.extended_render_distance);
            }
            this.profileSurroundings();
            SceneEnhancer.tryAmbientSounds();
        }
    }

    public static void tickFog() {
        Minecraft mc = Minecraft.func_71410_x();
        float sunBrightness = mc.field_71441_e.func_72971_b(1.0f);
        float fogBoundary = fogDistance;
        float fogBoundaryClose = fogBoundary - fogBoundary * 0.3f;
        fogMultTarget = (float)(1.0 - distToStorm / distToStormThreshold);
        if ((fogMultTarget *= isPlayerOutside ? 2.0f : 1.0f) < 0.0f) {
            fogMultTarget = 0.0f;
        } else if (fogMultTarget > 1.0f) {
            fogMultTarget = 1.0f;
        }
        fogMult = CoroUtilMisc.adjVal((float)fogMult, (float)fogMultTarget, (float)0.003f);
        fogRed = CoroUtilMisc.adjVal((float)fogRed, (float)(fogRedTarget * sunBrightness), (float)0.006f);
        fogGreen = CoroUtilMisc.adjVal((float)fogGreen, (float)(fogGreenTarget * sunBrightness), (float)0.006f);
        fogBlue = CoroUtilMisc.adjVal((float)fogBlue, (float)(fogBlueTarget * sunBrightness), (float)0.006f);
        fogDensity = CoroUtilMisc.adjVal((float)fogDensity, (float)(fogDensityTarget * fogMult), (float)0.006f);
        fogStart = CoroUtilMisc.adjVal((float)fogStart, (float)(fogBoundaryClose - fogBoundaryClose * fogDensity * fogMult), (float)(fogBoundary * 0.5f));
        fogEnd = CoroUtilMisc.adjVal((float)fogEnd, (float)(fogBoundary - fogBoundary * fogDensity * fogMult), (float)(fogBoundary * 0.5f));
        if (mc.field_71441_e.func_82737_E() % 200L == 0L) {
            try {
                Object fogState = ObfuscationReflectionHelper.getPrivateValue(GlStateManager.class, null, (String)"field_179155_g");
                Class<?> innerClass = Class.forName("net.minecraft.client.renderer.GlStateManager$FogState");
                Field fieldEnd = null;
                try {
                    fieldEnd = innerClass.getField("field_179046_e");
                    fieldEnd.setAccessible(true);
                }
                catch (Exception e) {
                    fieldEnd = innerClass.getField("end");
                    fieldEnd.setAccessible(true);
                }
                fogEnd = fieldEnd.getFloat(fogState);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void trySoundPlaying() {
        try {
            if (lastTickAmbient < System.currentTimeMillis()) {
                lastTickAmbient = System.currentTimeMillis() + 500L;
                Minecraft mc = FMLClientHandler.instance().getClient();
                WorldClient worldRef = mc.field_71441_e;
                EntityPlayerSP player = mc.field_71439_g;
                int size = 32;
                int curX = (int)player.field_70165_t;
                int curY = (int)player.field_70163_u;
                int curZ = (int)player.field_70161_v;
                Random rand = new Random();
                for (int i = 0; i < soundLocations.size(); ++i) {
                    ChunkCoordinatesBlock cCor = soundLocations.get(i);
                    if (Math.sqrt(cCor.getDistanceSquared((double)curX, (double)curY, (double)curZ)) > (double)size) {
                        soundLocations.remove(i--);
                        soundTimeLocations.remove(cCor);
                        continue;
                    }
                    Block block = SceneEnhancer.getBlock((World)worldRef, cCor.posX, cCor.posY, cCor.posZ);
                    if (block == null || block.func_149688_o(block.func_176223_P()) != Material.field_151586_h && block.func_149688_o(block.func_176223_P()) != Material.field_151584_j) {
                        soundLocations.remove(i);
                        soundTimeLocations.remove(cCor);
                        continue;
                    }
                    long lastPlayTime = 0L;
                    if (soundTimeLocations.containsKey(cCor)) {
                        lastPlayTime = soundTimeLocations.get(cCor);
                    }
                    if (lastPlayTime >= System.currentTimeMillis()) continue;
                    if (cCor.block == SOUNDMARKER_WATER) {
                        soundTimeLocations.put(cCor, System.currentTimeMillis() + 2500L + (long)rand.nextInt(50));
                        mc.field_71441_e.func_184156_a(cCor.toBlockPos(), SoundRegistry.waterfall, SoundCategory.AMBIENT, (float)ConfigVolume.waterfall, 0.75f + rand.nextFloat() * 0.05f, false);
                        continue;
                    }
                    if (cCor.block != SOUNDMARKER_LEAVES) continue;
                    float windSpeed = WindReader.getWindSpeed((World)mc.field_71441_e, new Maths.Vec3(cCor.posX, cCor.posY, cCor.posZ));
                    soundTimeLocations.put(cCor, System.currentTimeMillis() + 12000L + (long)rand.nextInt(50));
                    mc.field_71441_e.func_184156_a(cCor.toBlockPos(), SoundRegistry.leaves, SoundCategory.AMBIENT, (float)((double)(windSpeed * 2.0f) * ConfigVolume.leaves), 0.7f + rand.nextFloat() * 0.1f, false);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Weather2: Error handling sound play queue: ");
            ex.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void tryAmbientSounds() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        WorldClient worldRef = mc.field_71441_e;
        EntityPlayerSP player = mc.field_71439_g;
        if (lastTickAmbientThreaded < System.currentTimeMillis()) {
            lastTickAmbientThreaded = System.currentTimeMillis() + 500L;
            int size = 32;
            int hsize = size / 2;
            int curX = (int)player.field_70165_t;
            int curY = (int)player.field_70163_u;
            int curZ = (int)player.field_70161_v;
            for (int xx = curX - hsize; xx < curX + hsize; ++xx) {
                for (int yy = curY - hsize / 2; yy < curY + hsize; ++yy) {
                    for (int zz = curZ - hsize; zz < curZ + hsize; ++zz) {
                        Block block = SceneEnhancer.getBlock((World)worldRef, xx, yy, zz);
                        if (block == null) continue;
                        if (ConfigParticle.enable_waterfall_splash && block.func_149688_o(block.func_176223_P()) == Material.field_151586_h) {
                            Block id2;
                            int meta = SceneEnhancer.getBlockMetadata((World)worldRef, xx, yy, zz);
                            if ((meta & 8) == 0) continue;
                            int bottomY = yy;
                            int index = 0;
                            while (yy - index > 0 && ((id2 = SceneEnhancer.getBlock((World)worldRef, xx, yy - index, zz)) == null || id2.func_149688_o(id2.func_176223_P()) == Material.field_151586_h)) {
                                ++index;
                            }
                            bottomY = yy - index + 1;
                            int meta2 = SceneEnhancer.getBlockMetadata((World)worldRef, xx, bottomY + 10, zz);
                            Block block2 = SceneEnhancer.getBlock((World)worldRef, xx, bottomY + 10, zz);
                            if (index < 4 || block2 == null || block2.func_149688_o(block2.func_176223_P()) != Material.field_151586_h || (meta2 & 8) == 0) continue;
                            boolean proxFail = false;
                            for (int j = 0; j < soundLocations.size(); ++j) {
                                if (!(Math.sqrt(soundLocations.get(j).getDistanceSquared((double)xx, (double)bottomY, (double)zz)) < 5.0)) continue;
                                proxFail = true;
                                break;
                            }
                            if (proxFail) continue;
                            soundLocations.add(new ChunkCoordinatesBlock(xx, bottomY, zz, SOUNDMARKER_WATER, 0));
                            continue;
                        }
                        if (!(ConfigVolume.leaves > 0.0) || block.func_149688_o(block.func_176223_P()) != Material.field_151584_j) continue;
                        boolean proxFail = false;
                        for (int j = 0; j < soundLocations.size(); ++j) {
                            if (!(Math.sqrt(soundLocations.get(j).getDistanceSquared((double)xx, (double)yy, (double)zz)) < 15.0)) continue;
                            proxFail = true;
                            break;
                        }
                        if (proxFail) continue;
                        soundLocations.add(new ChunkCoordinatesBlock(xx, yy, zz, SOUNDMARKER_LEAVES, 0));
                    }
                }
            }
        }
    }

    public void reset() {
        curPrecipStr = 0.0f;
        curPrecipStrTarget = 0.0f;
        curOvercastStr = 0.0f;
        curOvercastStrTarget = 0.0f;
        curDampness = 0.0f;
        wo = null;
        this.lastWorldDetected.field_73007_j.clear();
        if (WeatherUtilParticle.fxLayers == null) {
            WeatherUtilParticle.getFXLayers();
        }
    }

    public void tickParticlePrecipitation() {
        block18: {
            int spawnAreaSize;
            int safetyCutout;
            int spawnNeed;
            double particleAmp;
            Random rand;
            World world;
            float curPrecipVal;
            EntityPlayerSP entP;
            block19: {
                if (!ConfigParticle.enable_precipitation) break block18;
                entP = FMLClientHandler.instance().getClient().field_71439_g;
                if (entP.field_70163_u >= (double)ConfigStorm.cloud_layer_0_height) {
                    return;
                }
                WeatherManagerClient weatherMan = ClientTickHandler.weatherManager;
                if (weatherMan == null) {
                    return;
                }
                WindManager windMan = weatherMan.windManager;
                if (windMan == null) {
                    return;
                }
                curPrecipVal = SceneEnhancer.getRainStrengthAndControlVisuals((EntityPlayer)entP);
                boolean shouldSnow = curPrecipVal <= 0.0f;
                float maxPrecip = 1.0f;
                Biome biomegenbase = entP.field_70170_p.func_180494_b(new BlockPos(MathHelper.func_76128_c((double)entP.field_70165_t), 0, MathHelper.func_76128_c((double)entP.field_70161_v)));
                world = entP.field_70170_p;
                rand = entP.field_70170_p.field_73012_v;
                particleAmp = 1.0;
                if (RotatingParticleManager.useShaders && ConfigCoroUtil.particleShaders) {
                    particleAmp = 1.0;
                }
                if (funnel == null) {
                    funnel = new TornadoFunnel();
                    SceneEnhancer.funnel.pos = new Vec3d(entP.field_70165_t, entP.field_70163_u, entP.field_70161_v);
                }
                if (biomegenbase == null || !biomegenbase.func_76738_d() && !biomegenbase.func_76746_c() || !((curPrecipVal = Math.min(maxPrecip, Math.abs(curPrecipVal))) > 0.0f)) break block18;
                spawnNeed = (int)((double)(curPrecipVal * 20.0f) * ConfigParticle.precipitation_particle_rate * particleAmp);
                safetyCutout = 100;
                int extraRenderCount = 15;
                if ((double)curPrecipVal < 0.1 && ConfigParticle.precipitation_particle_rate > 0.0) {
                    int oldVal = extraRenderCount;
                    extraRenderCount = spawnNeed;
                    spawnNeed = oldVal;
                }
                if (shouldSnow) break block19;
                int spawnCount = 0;
                spawnAreaSize = 20;
                if (spawnNeed > 0) {
                    for (int i = 0; i < safetyCutout; ++i) {
                        BlockPos pos = new BlockPos(entP.field_70165_t + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2), entP.field_70163_u - 5.0 + (double)rand.nextInt(25), entP.field_70161_v + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2));
                        if (!SceneEnhancer.canPrecipitateAt(world, pos)) continue;
                        ParticleTexExtraRender rain = new ParticleTexExtraRender(entP.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0, 0.0, 0.0, ParticleRegistry.rain_white);
                        rain.setKillWhenUnderTopmostBlock(true);
                        rain.setCanCollide(false);
                        rain.killWhenUnderCameraAtLeast = 5;
                        rain.setTicksFadeOutMaxOnDeath(5.0f);
                        rain.setDontRenderUnderTopmostBlock(true);
                        rain.setExtraParticlesBaseAmount(extraRenderCount);
                        rain.fastLight = true;
                        rain.setSlantParticleToWind(true);
                        rain.windWeight = 1.0f;
                        if (!RotatingParticleManager.useShaders || !ConfigCoroUtil.particleShaders) {
                            rain.setFacePlayer(true);
                            rain.setSlantParticleToWind(true);
                        } else {
                            rain.setFacePlayer(false);
                            rain.extraYRotation = (float)rain.getWorld().field_73012_v.nextInt(360) - 180.0f;
                        }
                        rain.setScale(2.0f);
                        rain.isTransparent = true;
                        rain.setGravity(2.5f);
                        rain.func_187114_a(50);
                        rain.setTicksFadeInMax(5.0f);
                        rain.func_82338_g(0.0f);
                        rain.rotationYaw = (float)rain.getWorld().field_73012_v.nextInt(360) - 180.0f;
                        rain.setMotionY(-0.5);
                        rain.renderOrder = 2;
                        rain.spawnAsWeatherEffect();
                        ClientTickHandler.weatherManager.addEffectedParticle((Particle)rain);
                        if (++spawnCount >= spawnNeed) break;
                    }
                }
                boolean groundSplash = ConfigParticle.enable_precipitation_splash;
                boolean downfall = ConfigParticle.enable_heavy_precipitation;
                spawnAreaSize = 100;
                if (groundSplash && curPrecipVal > 0.15f) {
                    int i = 0;
                    while ((double)i < (double)(30.0f * curPrecipVal) * ConfigParticle.precipitation_particle_rate * particleAmp * 5.0) {
                        BlockPos pos = new BlockPos(entP.field_70165_t + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2), entP.field_70163_u - 5.0 + (double)rand.nextInt(15), entP.field_70161_v + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2));
                        pos = world.func_175725_q(pos).func_177977_b();
                        IBlockState state = world.func_180495_p(pos);
                        AxisAlignedBB axisalignedbb = state.func_185900_c((IBlockAccess)world, pos);
                        if (!(pos.func_185332_f(MathHelper.func_76128_c((double)entP.field_70165_t), MathHelper.func_76128_c((double)entP.field_70163_u), MathHelper.func_76128_c((double)entP.field_70161_v)) > (double)(spawnAreaSize / 2)) && SceneEnhancer.canPrecipitateAt(world, pos.func_177984_a())) {
                            ParticleTexFX rain = new ParticleTexFX(entP.field_70170_p, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)pos.func_177956_o() + 0.01 + axisalignedbb.field_72337_e, (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, ParticleRegistry.cloud256_6);
                            rain.setKillWhenUnderTopmostBlock(true);
                            rain.setCanCollide(false);
                            rain.killWhenUnderCameraAtLeast = 5;
                            boolean upward = rand.nextBoolean();
                            rain.windWeight = 20.0f;
                            rain.setFacePlayer(upward);
                            rain.setScale(3.0f + rand.nextFloat() * 3.0f);
                            rain.func_187114_a(15);
                            rain.setGravity(-0.0f);
                            rain.setTicksFadeInMax(0.0f);
                            rain.func_82338_g(0.0f);
                            rain.setTicksFadeOutMax(4.0f);
                            rain.rotationYaw = (float)rain.getWorld().field_73012_v.nextInt(360) - 180.0f;
                            rain.rotationPitch = 90.0f;
                            rain.setMotionY(0.0);
                            rain.setMotionX((double)((rand.nextFloat() - 0.5f) * 0.01f));
                            rain.setMotionZ((double)((rand.nextFloat() - 0.5f) * 0.01f));
                            rain.spawnAsWeatherEffect();
                            ClientTickHandler.weatherManager.addEffectedParticle((Particle)rain);
                        }
                        ++i;
                    }
                }
                spawnAreaSize = 20;
                if (!downfall || !((double)curPrecipVal >= 0.45)) break block18;
                int scanAheadRange = 0;
                scanAheadRange = entP.field_70170_p.func_175710_j(entP.func_180425_c()) ? 3 : 10;
                int i = 0;
                while ((double)i < (double)(1.0f * curPrecipVal) * ConfigParticle.precipitation_particle_rate) {
                    BlockPos pos = new BlockPos(entP.field_70165_t + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2), entP.field_70163_u + 5.0 + (double)rand.nextInt(15), entP.field_70161_v + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2));
                    if (!(entP.func_174818_b(pos) < 100.0) && SceneEnhancer.canPrecipitateAt(world, pos.func_177981_b(-scanAheadRange))) {
                        ParticleTexExtraRender rain = new ParticleTexExtraRender(entP.field_70170_p, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)(pos.func_177956_o() - 1) + 0.01, (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, ParticleRegistry.downfall3);
                        rain.setCanCollide(false);
                        rain.killWhenUnderCameraAtLeast = 5;
                        rain.setKillWhenUnderTopmostBlock(true);
                        rain.setKillWhenUnderTopmostBlock_ScanAheadRange(scanAheadRange);
                        rain.setTicksFadeOutMaxOnDeath(10.0f);
                        rain.noExtraParticles = true;
                        rain.windWeight = 16.0f;
                        rain.setFacePlayer(true);
                        rain.facePlayerYaw = true;
                        rain.setScale(90.0f + rand.nextFloat() * 3.0f);
                        rain.func_187114_a(60);
                        rain.setGravity(0.35f);
                        rain.setTicksFadeInMax(20.0f);
                        rain.func_82338_g(0.0f);
                        rain.setTicksFadeOutMax(20.0f);
                        rain.rotationYaw = (float)rain.getWorld().field_73012_v.nextInt(360) - 180.0f;
                        rain.rotationPitch = 90.0f;
                        rain.rotationPitch = 0.0f;
                        rain.setMotionY(-0.3);
                        rain.setMotionX((double)((rand.nextFloat() - 0.5f) * 0.01f));
                        rain.setMotionZ((double)((rand.nextFloat() - 0.5f) * 0.01f));
                        rain.spawnAsWeatherEffect();
                        ClientTickHandler.weatherManager.addEffectedParticle((Particle)rain);
                    }
                    ++i;
                }
                break block18;
            }
            int spawnCount = 0;
            spawnNeed = (int)((double)(curPrecipVal * 40.0f) * ConfigParticle.precipitation_particle_rate * particleAmp);
            spawnAreaSize = 50;
            if (spawnNeed > 0) {
                for (int i = 0; i < safetyCutout; ++i) {
                    BlockPos pos = new BlockPos(entP.field_70165_t + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2), entP.field_70163_u - 5.0 + (double)rand.nextInt(25), entP.field_70161_v + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2));
                    if (!SceneEnhancer.canPrecipitateAt(world, pos)) continue;
                    ParticleTexExtraRender snow = new ParticleTexExtraRender(entP.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0, 0.0, 0.0, ParticleRegistry.snow);
                    snow.setCanCollide(false);
                    snow.setKillWhenUnderTopmostBlock(true);
                    snow.setTicksFadeOutMaxOnDeath(5.0f);
                    snow.setDontRenderUnderTopmostBlock(true);
                    snow.setExtraParticlesBaseAmount(10);
                    snow.killWhenFarFromCameraAtLeast = 20;
                    snow.setMotionY(-0.1);
                    snow.setScale(1.3f);
                    snow.setGravity(0.1f);
                    snow.windWeight = 0.2f;
                    snow.func_187114_a(40);
                    snow.setFacePlayer(false);
                    snow.setTicksFadeInMax(5.0f);
                    snow.func_82338_g(0.0f);
                    snow.setTicksFadeOutMax(5.0f);
                    snow.rotationYaw = (float)snow.getWorld().field_73012_v.nextInt(360) - 180.0f;
                    snow.spawnAsWeatherEffect();
                    ClientTickHandler.weatherManager.addEffectedParticle((Particle)snow);
                    if (++spawnCount < spawnNeed) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    public static boolean canPrecipitateAt(World world, BlockPos strikePosition) {
        return world.func_175725_q(strikePosition).func_177956_o() <= strikePosition.func_177956_o();
    }

    public static float getRainStrengthAndControlVisuals(EntityPlayer entP) {
        return SceneEnhancer.getRainStrengthAndControlVisuals(entP, false);
    }

    public static float getRainStrengthAndControlVisuals(EntityPlayer entP, boolean forOvercast) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        double stormDist = 9999.0;
        float tempAdj = 1.0f;
        float sizeToUse = 0.0f;
        float overcastModeMinPrecip = (float)ConfigStorm.min_overcast_rain;
        Maths.Vec3 plPos = new Maths.Vec3(entP.field_70165_t, (double)ConfigStorm.cloud_layer_0_height, entP.field_70161_v);
        StormObject storm = null;
        ClientTickHandler.checkClientWeather();
        if (EZConfigParser.isWeatherEnabled(ClientTickHandler.weatherManager.getDimension())) {
            if (wo instanceof StormObject) {
                storm = (StormObject)wo;
            }
            if (storm != null) {
                sizeToUse = (float)storm.size * 0.5f;
                if (forOvercast) {
                    sizeToUse *= 2.0f;
                }
                stormDist = Math.max(storm.pos.distanceSq(plPos) - (double)sizeToUse, 0.0);
                double overcastIntensity = 1.0 - Math.min(stormDist / 100.0, 1.0);
                curOvercastStrTarget = (float)overcastIntensity;
                if (storm.hasDownfall() && (double)sizeToUse > stormDist) {
                    double rainIntensity = ConfigParticle.enable_vanilla_rain ? 0.0 : overcastIntensity * (double)Math.min((storm.rain - 100.0f) / 300.0f, 1.0f);
                    tempAdj = WeatherUtil.getTemperature((World)mc.field_71441_e, mc.field_71439_g.func_180425_c());
                    if (storm.stage < WeatherEnum.Stage.THUNDER.getStage() && rainIntensity > 0.35) {
                        rainIntensity = 0.35;
                    }
                    if (ConfigMisc.overcast_mode && rainIntensity < (double)overcastModeMinPrecip) {
                        rainIntensity = overcastModeMinPrecip;
                    }
                    mc.field_71441_e.func_72912_H().func_76084_b(true);
                    mc.field_71441_e.func_72912_H().func_76069_a(true);
                    curPrecipStrTarget = Math.min((float)rainIntensity, 1.0f);
                } else if (!ConfigMisc.overcast_mode) {
                    mc.field_71441_e.func_72912_H().func_76084_b(false);
                    mc.field_71441_e.func_72912_H().func_76069_a(false);
                    curPrecipStrTarget = 0.0f;
                } else if (ClientTickHandler.weatherManager.weatherID >= 1) {
                    mc.field_71441_e.func_72912_H().func_76084_b(true);
                    mc.field_71441_e.func_72912_H().func_76069_a(true);
                    if (forOvercast) {
                        curOvercastStrTarget = overcastModeMinPrecip;
                    } else {
                        curPrecipStrTarget = overcastModeMinPrecip;
                    }
                } else {
                    curPrecipStrTarget = 0.0f;
                }
            } else {
                curPrecipStrTarget = 0.0f;
                curOvercastStrTarget = 0.0f;
            }
        } else {
            switch (ClientTickHandler.weatherManager.weatherID) {
                case 1: {
                    curOvercastStrTarget = 0.8f;
                    curPrecipStrTarget = 0.3f;
                    break;
                }
                case 2: {
                    curOvercastStrTarget = 1.0f;
                    curPrecipStrTarget = 1.0f;
                    break;
                }
                default: {
                    curOvercastStrTarget = 0.0f;
                    curPrecipStrTarget = 0.0f;
                }
            }
        }
        if (forOvercast) {
            if ((double)curOvercastStr < 0.001 && curOvercastStr > -0.001f) {
                return 0.0f;
            }
            return curOvercastStr * tempAdj;
        }
        if ((double)curPrecipStr < 0.001 && curPrecipStr > -0.001f) {
            return 0.0f;
        }
        return curPrecipStr * tempAdj;
    }

    public static void tickRainRates() {
        float rateChange = (float)((double)5.0E-4f * ConfigParticle.rain_change_mult);
        curOvercastStr = CoroUtilMisc.adjVal((float)curOvercastStr, (float)curOvercastStrTarget, (float)rateChange);
        if ((curPrecipStr = CoroUtilMisc.adjVal((float)curPrecipStr, (float)curPrecipStrTarget, (float)rateChange)) > 0.1f && curDampness < 1.0f) {
            curDampness += 0.01f;
        } else if (curDampness > 0.0f) {
            curDampness -= 0.01f;
        }
    }

    public static float getPrecipStrength(EntityPlayer entP, boolean forOvercast) {
        StormObject storm = SceneEnhancer.getClosestStormCached(entP);
        if (storm != null) {
            float tempAdj;
            float f = tempAdj = storm.temperature > 0.0f ? 1.0f : -1.0f;
            if (forOvercast) {
                return curOvercastStr * tempAdj;
            }
            return curPrecipStr * tempAdj;
        }
        return 0.0f;
    }

    public static void controlVanillaPrecipVisuals(EntityPlayer entP, boolean forOvercast) {
    }

    public static StormObject getClosestStormCached(EntityPlayer entP) {
        if (WeatherManagerClient.closestStormCached == null || entP.field_70170_p.func_82737_E() % 5L == 0L) {
            double maxStormDist = 384.0;
            Maths.Vec3 plPos = new Maths.Vec3(entP.field_70165_t, (double)ConfigStorm.cloud_layer_0_height, entP.field_70161_v);
            ClientTickHandler.checkClientWeather();
            WeatherManagerClient.closestStormCached = (StormObject)ClientTickHandler.weatherManager.getClosestWeather(plPos, maxStormDist, WeatherEnum.Stage.TORNADO.getStage(), Integer.MAX_VALUE, WeatherEnum.Type.BLIZZARD, WeatherEnum.Type.SANDSTORM);
        }
        return WeatherManagerClient.closestStormCached;
    }

    public synchronized void tryParticleSpawning() {
        if (spawnQueue.size() > 0) {
            // empty if block
        }
        try {
            Particle ent;
            int i;
            for (i = 0; i < spawnQueue.size(); ++i) {
                ent = spawnQueue.get(i);
                if (ent == null) continue;
                if (ent instanceof EntityRotFX) {
                    ((EntityRotFX)ent).spawnAsWeatherEffect();
                }
                ClientTickHandler.weatherManager.addEffectedParticle(ent);
            }
            for (i = 0; i < spawnQueueNormal.size(); ++i) {
                ent = spawnQueueNormal.get(i);
                if (ent == null) continue;
                Minecraft.func_71410_x().field_71452_i.func_78873_a(ent);
            }
        }
        catch (Exception ex) {
            Weather2.error("Weather2: Error handling particle spawn queue: ");
            ex.printStackTrace();
        }
        spawnQueue.clear();
        spawnQueueNormal.clear();
    }

    public void profileSurroundings() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        World world = this.lastWorldDetected;
        EntityPlayerSP player = FMLClientHandler.instance().getClient().field_71439_g;
        WeatherManagerClient manager = ClientTickHandler.weatherManager;
        if (world == null || player == null || manager == null || manager.windManager == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return;
        }
        if (threadLastWorldTickTime == world.func_82737_E()) {
            return;
        }
        threadLastWorldTickTime = world.func_82737_E();
        Random rand = new Random();
        int size = 40;
        int hsize = size / 2;
        int curX = (int)player.field_70165_t;
        int curY = (int)player.field_70163_u;
        int curZ = (int)player.field_70161_v;
        float windStr = WindReader.getWindSpeed(world, new Maths.Vec3(curX, curY, curZ));
        if (!ConfigParticle.enable_falling_leaves && !ConfigParticle.enable_waterfall_splash) {
            return;
        }
        int spawnRate = (int)(30.0 / ((double)windStr + 0.001));
        float lastBlockCount = lastTickFoundBlocks;
        float particleCreationRate = (float)ConfigParticle.ambient_particle_rate;
        float maxScaleSample = 15000.0f;
        if (lastBlockCount > maxScaleSample) {
            lastBlockCount = maxScaleSample - 1.0f;
        }
        float scaleRate = (maxScaleSample - lastBlockCount) / maxScaleSample;
        spawnRate = (int)((float)spawnRate / (scaleRate + 0.001f) / (particleCreationRate + 0.001f));
        int BlockCountRate = (int)((300.0f / scaleRate + 0.001f) / (particleCreationRate + 0.001f));
        spawnRate *= mc.field_71474_y.field_74362_aa + 1;
        BlockCountRate *= mc.field_71474_y.field_74362_aa + 1;
        if ((spawnRate /= 2) < 40) {
            spawnRate = 40;
        }
        if (BlockCountRate < 80) {
            BlockCountRate = 80;
        }
        if (BlockCountRate > 5000) {
            BlockCountRate = 5000;
        }
        lastTickFoundBlocks = 0;
        double particleAmp = 1.0;
        if (RotatingParticleManager.useShaders && ConfigCoroUtil.particleShaders) {
            particleAmp = 2.0;
        }
        spawnRate = (int)((double)spawnRate / particleAmp);
        for (int xx = curX - hsize; xx < curX + hsize; ++xx) {
            for (int yy = curY - hsize / 2; yy < curY + hsize; ++yy) {
                for (int zz = curZ - hsize; zz < curZ + hsize; ++zz) {
                    Block block = SceneEnhancer.getBlock(world, xx, yy, zz);
                    if (block == null) continue;
                    Material material = block.func_176223_P().func_185904_a();
                    if (material == Material.field_151584_j || material == Material.field_151582_l || material == Material.field_151585_k) {
                        ++lastTickFoundBlocks;
                        if (world.field_73012_v.nextInt(spawnRate) == 0) {
                            double relAdj = 0.7;
                            BlockPos pos = SceneEnhancer.getRandomWorkingPos(world, new BlockPos(xx, yy, zz));
                            double xRand = 0.0;
                            double yRand = 0.0;
                            double zRand = 0.0;
                            if (pos != null) {
                                float particleAABB = 0.1f;
                                float particleAABBAndBuffer = particleAABB + 0.05f;
                                float invert = 1.0f - particleAABBAndBuffer * 2.0f;
                                if (pos.func_177956_o() != 0) {
                                    xRand = (double)particleAABBAndBuffer + (rand.nextDouble() - 0.5) * (double)invert;
                                    zRand = (double)particleAABBAndBuffer + (rand.nextDouble() - 0.5) * (double)invert;
                                } else if (pos.func_177958_n() != 0) {
                                    yRand = (double)particleAABBAndBuffer + (rand.nextDouble() - 0.5) * (double)invert;
                                    zRand = (double)particleAABBAndBuffer + (rand.nextDouble() - 0.5) * (double)invert;
                                } else if (pos.func_177952_p() != 0) {
                                    yRand = (double)particleAABBAndBuffer + (rand.nextDouble() - 0.5) * (double)invert;
                                    xRand = (double)particleAABBAndBuffer + (rand.nextDouble() - 0.5) * (double)invert;
                                }
                                ParticleTexLeafColor var31 = new ParticleTexLeafColor(world, (double)xx, (double)yy, (double)zz, 0.0, 0.0, 0.0, ParticleRegistry.leaf);
                                var31.func_187109_b((double)xx + 0.5 + (double)pos.func_177958_n() * relAdj + xRand, (double)yy + 0.5 + (double)pos.func_177956_o() * relAdj + yRand, (double)zz + 0.5 + (double)pos.func_177952_p() * relAdj + zRand);
                                var31.setPrevPosX(var31.field_187126_f);
                                var31.setPrevPosY(var31.field_187127_g);
                                var31.setPrevPosZ(var31.field_187128_h);
                                var31.setMotionX(0.0);
                                var31.setMotionY(0.0);
                                var31.setMotionZ(0.0);
                                var31.setGravity(0.05f);
                                var31.setCanCollide(true);
                                var31.setKillOnCollide(false);
                                var31.collisionSpeedDampen = false;
                                var31.killWhenUnderCameraAtLeast = 20;
                                var31.killWhenFarFromCameraAtLeast = 20;
                                var31.isTransparent = false;
                                var31.rotationYaw = rand.nextInt(360);
                                var31.rotationPitch = rand.nextInt(360);
                                var31.updateQuaternion(null);
                                spawnQueue.add((Particle)var31);
                            }
                        }
                    } else if (ConfigParticle.enable_waterfall_splash && player.func_70011_f((double)xx, (double)yy, (double)zz) < 16.0 && block != null && block.func_149688_o(block.func_176223_P()) == Material.field_151586_h) {
                        int meta = SceneEnhancer.getBlockMetadata(world, xx, yy, zz);
                        if ((meta & 8) != 0) {
                            lastTickFoundBlocks += 70;
                            int chance = (int)(1.0f + (float)BlockCountRate / 120.0f);
                            Block block2 = SceneEnhancer.getBlock(world, xx, yy - 1, zz);
                            int meta2 = SceneEnhancer.getBlockMetadata(world, xx, yy - 1, zz);
                            Block block3 = SceneEnhancer.getBlock(world, xx, yy + 10, zz);
                            if ((block2 == null || block2.func_176223_P().func_185904_a() != Material.field_151586_h || (meta2 & 8) == 0) && block3 != null && block3.func_176223_P().func_185904_a() == Material.field_151586_h || world.field_73012_v.nextInt(chance) == 0) {
                                float range = 0.5f;
                                EntityWaterfallFX waterP = new EntityWaterfallFX(world, (double)xx + 0.5 + (double)(rand.nextFloat() * range - range / 2.0f), (double)yy + 0.5 + (double)(rand.nextFloat() * range - range / 2.0f), (double)zz + 0.5 + (double)(rand.nextFloat() * range - range / 2.0f), 0.0, 0.0, 0.0, 6.0, 2);
                                if ((block2 == null || block2.func_176223_P().func_185904_a() != Material.field_151586_h || (meta2 & 8) == 0) && block3 != null && block3.func_176223_P().func_185904_a() == Material.field_151586_h) {
                                    range = 2.0f;
                                    float speed = 0.2f;
                                    for (int i = 0; i < 10; ++i) {
                                        if (world.field_73012_v.nextInt(chance / 2) != 0) continue;
                                        waterP = new EntityWaterfallFX(world, (double)xx + 0.5 + (double)(rand.nextFloat() * range - range / 2.0f), (double)yy + (double)0.7f + (double)(rand.nextFloat() * range - range / 2.0f), (double)zz + 0.5 + (double)(rand.nextFloat() * range - range / 2.0f), rand.nextFloat() * speed - speed / 2.0f, rand.nextFloat() * speed - speed / 2.0f, rand.nextFloat() * speed - speed / 2.0f, 2.0, 3);
                                        waterP.setMotionY(4.5);
                                        spawnQueueNormal.add((Particle)waterP);
                                    }
                                } else {
                                    waterP = new EntityWaterfallFX(world, (double)xx + 0.5 + (double)(rand.nextFloat() * range - range / 2.0f), (double)yy + 0.5 + (double)(rand.nextFloat() * range - range / 2.0f), (double)zz + 0.5 + (double)(rand.nextFloat() * range - range / 2.0f), 0.0, 0.0, 0.0, 6.0, 2);
                                    waterP.setMotionY(0.5);
                                    spawnQueueNormal.add((Particle)waterP);
                                }
                            }
                        }
                    } else if (ConfigParticle.enable_fire_particle && block == Blocks.field_150480_ab) {
                        ++lastTickFoundBlocks;
                        if (world.field_73012_v.nextInt(Math.max(1, spawnRate / 100)) == 0) {
                            double speed = 0.15;
                            EntityRotFX entityfx = pm.spawnNewParticleIconFX(world, ParticleRegistry.smoke, (double)xx + rand.nextDouble(), (double)yy + 0.2 + rand.nextDouble() * 0.2, (double)zz + rand.nextDouble(), (rand.nextDouble() - rand.nextDouble()) * speed, 0.03, (rand.nextDouble() - rand.nextDouble()) * speed);
                            ParticleBehaviors.setParticleRandoms((EntityRotFX)entityfx, (boolean)true, (boolean)true);
                            ParticleBehaviors.setParticleFire((EntityRotFX)entityfx);
                            entityfx.func_187114_a(100 + rand.nextInt(300));
                            spawnQueueNormal.add((Particle)entityfx);
                        }
                    }
                    if (!ConfigParticle.enable_wind_particle || !(windStr > 3.0f) || !(curDampness < 0.35f) || material != Material.field_151577_b && material != Material.field_151578_c && material != Material.field_151595_p) continue;
                    ++lastTickFoundBlocks;
                    float windStrAlt = Math.min(windStr * 0.6f, 1.0f);
                    if (world.field_73012_v.nextInt((int)((double)((float)spawnRate * (2.0f - windStrAlt)) / ConfigParticle.wind_particle_rate) / 4) != 0) continue;
                    BlockPos pos = new BlockPos(xx, yy, zz);
                    AxisAlignedBB axisalignedbb = block.func_176223_P().func_185900_c((IBlockAccess)world, pos);
                    if (!SceneEnhancer.canPrecipitateAt(world, pos.func_177984_a())) continue;
                    ParticleTexFX rain = new ParticleTexFX(world, (double)((float)xx + rand.nextFloat()), (double)yy + 1.01 + axisalignedbb.field_72337_e, (double)((float)zz + rand.nextFloat()), 0.0, 0.0, 0.0, ParticleRegistry.cloud256_6);
                    rain.setKillWhenUnderTopmostBlock(true);
                    rain.setCanCollide(false);
                    rain.windWeight = 12.0f;
                    rain.setFacePlayer(false);
                    rain.setScale((10.0f + rand.nextFloat() * 10.0f) * windStrAlt);
                    rain.func_187114_a(60);
                    rain.setMotionY((double)(Maths.random(0.01f, 0.05f) * windStrAlt));
                    rain.setGravity(-0.01f * windStrAlt);
                    rain.setTicksFadeInMax(4.0f);
                    rain.func_82338_g(0.0f);
                    rain.func_70538_b(0.4f, 0.35f, 0.25f);
                    rain.setTicksFadeOutMax(4.0f);
                    rain.renderOrder = 2;
                    rain.rotationYaw = (float)rain.getWorld().field_73012_v.nextInt(360) - 180.0f;
                    rain.rotationPitch = Maths.random(0.0f, 90.0f);
                    rain.spawnAsWeatherEffect();
                    ClientTickHandler.weatherManager.addEffectedParticle((Particle)rain);
                }
            }
        }
    }

    public static BlockPos getRandomWorkingPos(World world, BlockPos posOrigin) {
        Collections.shuffle(listPosRandom);
        for (BlockPos posRel : listPosRandom) {
            Block blockCheck = SceneEnhancer.getBlock(world, posOrigin.func_177971_a((Vec3i)posRel));
            if (blockCheck == null || !CoroUtilBlock.isAir((Block)blockCheck)) continue;
            return posRel;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static void tryWind(World world) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        WeatherManagerClient weatherMan = ClientTickHandler.weatherManager;
        if (weatherMan == null) {
            return;
        }
        WindManager windMan = weatherMan.windManager;
        if (windMan == null) {
            return;
        }
        Random rand = new Random();
        int handleCount = 0;
        mc.field_71424_I.func_76320_a("effectWeather");
        for (int i = 0; i < ClientTickHandler.weatherManager.effectedParticles.size(); ++i) {
            EntityRotFX entity1;
            Particle particle = ClientTickHandler.weatherManager.effectedParticles.get(i);
            if (particle == null || !particle.func_187113_k()) {
                ClientTickHandler.weatherManager.effectedParticles.remove(i--);
                continue;
            }
            Maths.Vec3 vec3 = new Maths.Vec3(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            if (!((double)WindReader.getWindSpeed(world, vec3) >= 0.1)) continue;
            ++handleCount;
            if (!(particle instanceof EntityRotFX) || (entity1 = (EntityRotFX)particle) == null) continue;
            if (WeatherUtilBlock.getPrecipitationHeightSafe(world, new BlockPos(MathHelper.func_76128_c((double)entity1.getPosX()), 0, MathHelper.func_76128_c((double)entity1.getPosZ()))).func_177956_o() - 1 < (int)entity1.getPosY() + 1 || entity1 instanceof ParticleTexFX) {
                if (entity1 instanceof IWindHandler) {
                    if (entity1.getParticleDecayExtra() > 0 && WeatherUtilParticle.getParticleAge((Particle)entity1) % 2 == 0) {
                        WeatherUtilParticle.setParticleAge((Particle)entity1, WeatherUtilParticle.getParticleAge((Particle)entity1) + entity1.getParticleDecayExtra());
                    }
                } else if (WeatherUtilParticle.getParticleAge((Particle)entity1) % 2 == 0) {
                    WeatherUtilParticle.setParticleAge((Particle)entity1, WeatherUtilParticle.getParticleAge((Particle)entity1) + 1);
                }
                if (entity1 instanceof ParticleTexFX && ((ParticleTexFX)entity1).getParticleTexture() == ParticleRegistry.leaf) {
                    if (entity1.getMotionX() < (double)0.01f && entity1.getMotionZ() < (double)0.01f) {
                        entity1.setMotionY(entity1.getMotionY() + rand.nextDouble() * 0.02 * (double)((ParticleTexFX)entity1).field_70545_g);
                    }
                    entity1.setMotionY(entity1.getMotionY() - (double)(0.01f * ((ParticleTexFX)entity1).field_70545_g));
                }
            }
            windMan.getEntityWindVectors(entity1, 0.05f, 5.0f);
        }
        mc.field_71424_I.func_76318_c("effectParticle");
        if (WeatherUtilParticle.fxLayers != null && (double)windMan.windSpeed >= 0.1) {
            for (int layer = 0; layer < WeatherUtilParticle.fxLayers.length; ++layer) {
                for (int i = 0; i < WeatherUtilParticle.fxLayers[layer].length; ++i) {
                    for (Particle entity1 : WeatherUtilParticle.fxLayers[layer][i]) {
                        String className;
                        if (ConfigParticle.enable_vanilla_rain && !(className = entity1.getClass().getName()).contains("net.minecraft.") && !className.contains("weather2.") || WeatherUtilBlock.getPrecipitationHeightSafe(world, new BlockPos(MathHelper.func_76128_c((double)CoroUtilEntOrParticle.getPosX((Object)entity1)), 0, MathHelper.func_76128_c((double)CoroUtilEntOrParticle.getPosZ((Object)entity1)))).func_177956_o() - 1 >= (int)CoroUtilEntOrParticle.getPosY((Object)entity1) + 1 && !(entity1 instanceof ParticleTexFX)) continue;
                        if (entity1 instanceof ParticleFlame) {
                            if ((double)windMan.windSpeed >= 0.2) {
                                ++entity1.field_70546_d;
                            }
                        } else if (entity1 instanceof IWindHandler && ((IWindHandler)entity1).getParticleDecayExtra() > 0 && WeatherUtilParticle.getParticleAge(entity1) % 2 == 0) {
                            entity1.field_70546_d += ((IWindHandler)entity1).getParticleDecayExtra();
                        }
                        if (!(entity1 instanceof EntityWaterfallFX) && CoroUtilEntOrParticle.getMotionX((Object)entity1) < (double)0.01f && CoroUtilEntOrParticle.getMotionZ((Object)entity1) < (double)0.01f) {
                            CoroUtilEntOrParticle.setMotionY((Object)entity1, (double)(CoroUtilEntOrParticle.getMotionY((Object)entity1) + rand.nextDouble() * 0.02));
                        }
                        windMan.getEntityWindVectors(entity1, 0.05f, 0.5f);
                    }
                }
            }
        }
        mc.field_71424_I.func_76319_b();
    }

    @SideOnly(value=Side.CLIENT)
    private static Block getBlock(World parWorld, BlockPos pos) {
        return SceneEnhancer.getBlock(parWorld, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @SideOnly(value=Side.CLIENT)
    private static Block getBlock(World parWorld, int x, int y, int z) {
        try {
            if (!parWorld.func_175667_e(new BlockPos(x, 0, z))) {
                return null;
            }
            return parWorld.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static int getBlockMetadata(World parWorld, int x, int y, int z) {
        if (!parWorld.func_175667_e(new BlockPos(x, 0, z))) {
            return 0;
        }
        IBlockState state = parWorld.func_180495_p(new BlockPos(x, y, z));
        return state.func_177230_c().func_176201_c(state);
    }

    public static void tickTest() {
        Minecraft mc = Minecraft.func_71410_x();
        if (miniTornado == null) {
            miniTornado = new ParticleBehaviorMiniTornado(new Vec3(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v));
        }
        for (int i = 0; i < 1; ++i) {
            ParticleTexFX part = new ParticleTexFX((World)mc.field_71441_e, SceneEnhancer.miniTornado.coordSource.xCoord, SceneEnhancer.miniTornado.coordSource.yCoord, SceneEnhancer.miniTornado.coordSource.zCoord, 0.0, 0.0, 0.0, ParticleRegistry.squareGrey);
            miniTornado.initParticle((EntityRotFX)part);
            SceneEnhancer.miniTornado.particles.add(part);
            part.spawnAsWeatherEffect();
        }
        miniTornado.tickUpdateList();
    }

    public static void tickTestFog() {
        Minecraft mc = Minecraft.func_71410_x();
        if (particleBehaviorFog == null) {
            particleBehaviorFog = new ParticleBehaviorFogGround(new Vec3(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v));
        } else {
            SceneEnhancer.particleBehaviorFog.coordSource = new Vec3(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u + 0.5, mc.field_71439_g.field_70161_v);
        }
        if (mc.field_71441_e.func_82737_E() % 300L == 0L && SceneEnhancer.particleBehaviorFog.particles.size() <= 10000) {
            for (int i = 0; i < 1; ++i) {
                ParticleTexFX part = new ParticleTexFX((World)mc.field_71441_e, SceneEnhancer.particleBehaviorFog.coordSource.xCoord, SceneEnhancer.particleBehaviorFog.coordSource.yCoord, SceneEnhancer.particleBehaviorFog.coordSource.zCoord, 0.0, 0.0, 0.0, ParticleRegistry.cloud256);
                part.setMotionX(-1.0);
                part.setMotionY(0.1);
                particleBehaviorFog.initParticle((EntityRotFX)part);
                part.spawnAsWeatherEffect();
                part.windWeight = 5.0f;
                part.debugID = 1;
                part.func_187114_a(280);
                part.setVanillaMotionDampen(false);
                ClientTickHandler.weatherManager.addEffectedParticle((Particle)part);
            }
        }
        particleBehaviorFog.tickUpdateList();
    }

    public static void tickTestSandstormParticles() {
        Minecraft mc = Minecraft.func_71410_x();
        if (vecWOP == null) {
            particleBehaviorFog = new ParticleBehaviorFogGround(new Vec3(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v));
            vecWOP = new Vec3d(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v);
        }
        for (int i = 0; i < 0; ++i) {
            ParticleTexFX part = new ParticleTexFX((World)mc.field_71441_e, SceneEnhancer.vecWOP.field_72450_a, SceneEnhancer.vecWOP.field_72448_b, SceneEnhancer.vecWOP.field_72449_c, 0.0, 0.0, 0.0, ParticleRegistry.cloud256);
            particleBehaviorFog.initParticle((EntityRotFX)part);
            part.setFacePlayer(false);
            part.spawnAsWeatherEffect();
        }
        boolean derp = false;
        if (derp) {
            IBlockState state = mc.field_71441_e.func_180495_p(new BlockPos(mc.field_71439_g.field_70165_t, mc.field_71439_g.func_174813_aQ().field_72338_b - 1.0, mc.field_71439_g.field_70161_v));
            int id = Block.func_176210_f((IBlockState)state);
            id = 12520;
            double speed = 0.2;
            Random rand = mc.field_71441_e.field_73012_v;
            mc.field_71441_e.func_175688_a(EnumParticleTypes.BLOCK_DUST, mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v, (rand.nextDouble() - rand.nextDouble()) * speed, rand.nextDouble() * speed * 2.0, (rand.nextDouble() - rand.nextDouble()) * speed, new int[]{id});
        }
    }

    public static void tickStormFog() {
        if (adjustAmountTargetPocketSandOverride > 0.0f) {
            adjustAmountTargetPocketSandOverride -= 0.01f;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        WorldClient world = mc.field_71441_e;
        Maths.Vec3 posPlayer = new Maths.Vec3(mc.field_71439_g.field_70165_t, 0.0, mc.field_71439_g.field_70161_v);
        SandstormObject sandstorm = ClientTickHandler.weatherManager.getClosestSandstormByIntensity(posPlayer);
        WeatherObject storm = ClientTickHandler.weatherManager.getClosestWeather(posPlayer, 1000.0, WeatherEnum.Stage.THUNDER.getStage(), Integer.MAX_VALUE, WeatherEnum.Type.BLIZZARD, WeatherEnum.Type.SANDSTORM);
        WindManager windMan = ClientTickHandler.weatherManager.windManager;
        if (sandstorm != null) {
            if (mc.field_71441_e.func_82737_E() % 40L == 0L) {
                isPlayerOutside = WeatherUtilEntity.isEntityOutside((Entity)mc.field_71439_g);
            }
            List<Vec3> points = sandstorm.getSandstormAsShape();
            boolean inStorm = CoroUtilPhysics.isInConvexShape((Vec3)posPlayer.toVec3Coro(), points);
            distToStorm = inStorm ? 0.0 : CoroUtilPhysics.getDistanceToShape((Vec3)posPlayer.toVec3Coro(), points);
        } else if (storm != null && storm instanceof StormObject && ((StormObject)storm).isRaining()) {
            distToStorm = CoroUtilPhysics.distBetween((double)posPlayer.posX, (double)posPlayer.posZ, (double)storm.pos.posX, (double)storm.pos.posZ);
            fogRedTarget = 0.45f;
            fogGreenTarget = 0.55f;
            fogBlueTarget = 0.65f;
            fogDensityTarget = 0.7f;
        } else {
            distToStorm = distToStormThreshold + 10.0;
        }
        if (fogMultTarget < adjustAmountTargetPocketSandOverride) {
            fogMultTarget = adjustAmountTargetPocketSandOverride;
        }
        EventHandler.sandstormFogAmount = fogMult;
        if (sandstorm != null && fogMultTarget > 0.0f) {
            fogRedTarget = 0.35f;
            fogGreenTarget = 0.22f;
            fogBlueTarget = 0.1f;
            fogDensityTarget = 0.98f;
        } else if (storm == null || !(storm instanceof StormObject) || !((StormObject)storm).isRaining()) {
            fogRedTarget = fogRedOrig;
            fogGreenTarget = fogGreenOrig;
            fogBlueTarget = fogBlueOrig;
            fogDensityTarget = 1.0f;
        }
        if (fogMult > 0.75f && sandstorm != null) {
            float brightnessMulti;
            ParticleSandstorm part;
            TextureAtlasSprite sprite;
            BlockPos pos;
            Maths.Vec3 windForce = windMan.getWindForce();
            Random rand = mc.field_71441_e.field_73012_v;
            int spawnAreaSize = 80;
            double sandstormParticleRateDebris = ConfigParticle.sandstorm_debris_particle_rate;
            double sandstormParticleRateDust = ConfigParticle.sandstorm_dust_particle_rate;
            float adjustAmountSmooth75 = fogMult * 8.0f - 7.0f;
            int i = 0;
            while ((double)i < (double)(30.0f * adjustAmountSmooth75) * sandstormParticleRateDust) {
                pos = new BlockPos(player.field_70165_t + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2), player.field_70163_u - 2.0 + (double)rand.nextInt(10), player.field_70161_v + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2));
                if (SceneEnhancer.canPrecipitateAt((World)world, pos)) {
                    sprite = ParticleRegistry.cloud256;
                    part = new ParticleSandstorm((World)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.0, 0.0, 0.0, sprite);
                    particleBehavior.initParticle((EntityRotFX)part);
                    part.setMotionX(windForce.posX);
                    part.setMotionZ(windForce.posZ);
                    part.setFacePlayer(false);
                    part.isTransparent = true;
                    part.rotationYaw = rand.nextInt(360);
                    part.rotationPitch = rand.nextInt(360);
                    part.func_187114_a(40);
                    part.setGravity(0.09f);
                    part.func_82338_g(0.0f);
                    brightnessMulti = 1.0f - rand.nextFloat() * 0.5f;
                    part.func_70538_b(0.65f * brightnessMulti, 0.6f * brightnessMulti, 0.3f * brightnessMulti);
                    part.setScale(40.0f);
                    part.aboveGroundHeight = 0.2;
                    part.setKillOnCollide(true);
                    part.windWeight = 1.0f;
                    SceneEnhancer.particleBehavior.particles.add(part);
                    ClientTickHandler.weatherManager.addEffectedParticle((Particle)part);
                    part.spawnAsWeatherEffect();
                }
                ++i;
            }
            i = 0;
            while ((double)i < (double)(1.0f * adjustAmountSmooth75) * sandstormParticleRateDebris) {
                pos = new BlockPos(player.field_70165_t + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2), player.field_70163_u - 2.0 + (double)rand.nextInt(10), player.field_70161_v + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2));
                if (SceneEnhancer.canPrecipitateAt((World)world, pos)) {
                    sprite = ParticleRegistry.tumbleweed;
                    part = new ParticleSandstorm((World)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.0, 0.0, 0.0, sprite);
                    particleBehavior.initParticle((EntityRotFX)part);
                    part.setMotionX(windForce.posX);
                    part.setMotionZ(windForce.posZ);
                    part.setFacePlayer(true);
                    part.isTransparent = true;
                    part.rotationYaw = rand.nextInt(360);
                    part.rotationPitch = rand.nextInt(360);
                    part.func_187114_a(80);
                    part.setGravity(0.3f);
                    part.func_82338_g(0.0f);
                    brightnessMulti = 1.0f - rand.nextFloat() * 0.2f;
                    part.func_70538_b(1.0f * brightnessMulti, 1.0f * brightnessMulti, 1.0f * brightnessMulti);
                    part.setScale(8.0f);
                    part.aboveGroundHeight = 0.5;
                    part.collisionSpeedDampen = false;
                    part.bounceSpeed = 0.03;
                    part.bounceSpeedAhead = 0.03;
                    part.setKillOnCollide(false);
                    part.windWeight = 1.0f;
                    SceneEnhancer.particleBehavior.particles.add(part);
                    ClientTickHandler.weatherManager.addEffectedParticle((Particle)part);
                    part.spawnAsWeatherEffect();
                }
                ++i;
            }
            i = 0;
            while ((double)i < (double)(8.0f * adjustAmountSmooth75) * sandstormParticleRateDebris) {
                pos = new BlockPos(player.field_70165_t + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2), player.field_70163_u - 2.0 + (double)rand.nextInt(10), player.field_70161_v + (double)rand.nextInt(spawnAreaSize) - (double)(spawnAreaSize / 2));
                if (SceneEnhancer.canPrecipitateAt((World)world, pos)) {
                    sprite = null;
                    int tex = rand.nextInt(3);
                    if (tex == 0) {
                        sprite = ParticleRegistry.debris_1;
                    } else if (tex == 1) {
                        sprite = ParticleRegistry.debris_2;
                    } else if (tex == 2) {
                        sprite = ParticleRegistry.debris_3;
                    }
                    ParticleSandstorm part2 = new ParticleSandstorm((World)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.0, 0.0, 0.0, sprite);
                    particleBehavior.initParticle((EntityRotFX)part2);
                    part2.setMotionX(windForce.posX);
                    part2.setMotionZ(windForce.posZ);
                    part2.setFacePlayer(false);
                    part2.spinFast = true;
                    part2.isTransparent = true;
                    part2.rotationYaw = rand.nextInt(360);
                    part2.rotationPitch = rand.nextInt(360);
                    part2.func_187114_a(80);
                    part2.setGravity(0.3f);
                    part2.func_82338_g(0.0f);
                    float brightnessMulti2 = 1.0f - rand.nextFloat() * 0.5f;
                    part2.func_70538_b(1.0f * brightnessMulti2, 1.0f * brightnessMulti2, 1.0f * brightnessMulti2);
                    part2.setScale(8.0f);
                    part2.aboveGroundHeight = 0.5;
                    part2.collisionSpeedDampen = false;
                    part2.bounceSpeed = 0.03;
                    part2.bounceSpeedAhead = 0.03;
                    part2.setKillOnCollide(false);
                    part2.windWeight = 1.0f;
                    SceneEnhancer.particleBehavior.particles.add(part2);
                    ClientTickHandler.weatherManager.addEffectedParticle((Particle)part2);
                    part2.spawnAsWeatherEffect();
                }
                ++i;
            }
        }
    }

    public static boolean isFogOverridding() {
        Minecraft mc = Minecraft.func_71410_x();
        IBlockState iblockstate = ActiveRenderInfo.func_186703_a((World)mc.field_71441_e, (Entity)mc.func_175606_aa(), (float)1.0f);
        if (iblockstate.func_185904_a().func_76224_d()) {
            return false;
        }
        return ConfigParticle.enable_extended_render_distance && EZConfigParser.isWeatherEnabled(ClientTickHandler.weatherManager.getDimension());
    }

    public static void renderWorldLast(RenderWorldLastEvent event) {
    }

    public static void renderTick(TickEvent.RenderTickEvent event) {
        if (ConfigMisc.toaster_pc_mode) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = FMLClientHandler.instance().getClient();
            EntityPlayerSP entP = mc.field_71439_g;
            if (entP != null) {
                float curRainStr = SceneEnhancer.getRainStrengthAndControlVisuals((EntityPlayer)entP, true);
                curRainStr = Math.abs(curRainStr);
                mc.field_71441_e.func_72894_k(curRainStr);
            }
        }
    }

    public static void tickSounds() {
        Minecraft mc = Minecraft.func_71410_x();
        Maths.Vec3 pos = new Maths.Vec3(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v);
        List<WeatherObject> weather = ClientTickHandler.weatherManager.getWeatherObjects();
        float windSpeed = WindReader.getWindSpeed((World)mc.field_71441_e, pos);
        int size = weather.size();
        int success = 0;
        WeatherUtilSound.tick();
        for (int i = 0; i < size && success < 4; ++i) {
            WeatherObject wo = weather.get(i);
            if (wo instanceof StormObject && success < 3) {
                if (!((StormObject)wo).isDeadly() || !(((StormObject)wo).pos_funnel_base.distanceSq(pos) - (double)wo.size + 200.0 <= 0.0)) continue;
                WeatherUtilSound.play2DSound(SoundRegistry.windFast, SoundCategory.WEATHER, ((StormObject)wo).pos_funnel_base, 1000 + i, (float)ConfigVolume.cyclone, ((StormObject)wo).isViolent ? 0.7f : 0.8f, ((StormObject)wo).funnelSize + 350.0f, false);
                WeatherUtilSound.play2DSound(SoundRegistry.debris, SoundCategory.WEATHER, ((StormObject)wo).pos_funnel_base, 2000 + i, (float)ConfigVolume.debris, 1.0f, ((StormObject)wo).funnelSize + 150.0f, false);
                success += 2;
                continue;
            }
            if (!(wo.pos.distanceSq(pos) - (double)wo.size + 100.0 <= 0.0)) continue;
            WeatherUtilSound.play2DSound(SoundRegistry.sandstorm, SoundCategory.WEATHER, wo, 3000 + i, (float)ConfigVolume.cyclone, 1.0f, (float)wo.size + 100.0f, false);
            ++success;
        }
        if (windSpeed > 6.5f) {
            if (WeatherUtilSound.isSoundActive(0, SoundRegistry.wind)) {
                WeatherUtilSound.stopSound(0);
            }
            WeatherUtilSound.playSound(SoundRegistry.windFast, SoundCategory.WEATHER, 0, (float)ConfigVolume.wind, 1.0f, false);
        } else if (windSpeed > 1.4f) {
            if (WeatherUtilSound.isSoundActive(0, SoundRegistry.windFast)) {
                WeatherUtilSound.stopSound(0);
            }
            WeatherUtilSound.playSound(SoundRegistry.wind, SoundCategory.WEATHER, 0, (float)ConfigVolume.wind, 1.0f, false);
        }
    }

    static {
        spawnQueueNormal = new ArrayList<Particle>();
        spawnQueue = new ArrayList<Particle>();
        soundLocations = new ArrayList();
        soundTimeLocations = new HashMap();
        SOUNDMARKER_WATER = Blocks.field_150355_j;
        SOUNDMARKER_LEAVES = Blocks.field_150362_t;
        curPrecipStr = 0.0f;
        curPrecipStrTarget = 0.0f;
        curOvercastStr = 0.0f;
        curOvercastStrTarget = 0.0f;
        vecWOP = null;
        distToStormThreshold = 100.0;
        distToStorm = distToStormThreshold + 50.0;
        fogRed = 0.0f;
        fogRedTarget = 0.0f;
        fogRedOrig = 0.0f;
        fogGreen = 0.0f;
        fogGreenTarget = 0.0f;
        fogGreenOrig = 0.0f;
        fogBlue = 0.0f;
        fogBlueTarget = 0.0f;
        fogBlueOrig = 0.0f;
        fogDensity = 0.0f;
        fogDensityTarget = 0.0f;
        fogStart = 0.0f;
        fogEnd = 0.0f;
        fogMult = 0.0f;
        fogMultTarget = 0.0f;
        fogDistance = 0.0f;
        adjustAmountTargetPocketSandOverride = 0.0f;
        isPlayerOutside = true;
        listPosRandom = new ArrayList<BlockPos>();
        testParticles = new ArrayList<EntityRotFX>();
        matrix = new Matrix4fe();
        matrix2 = new Matrix4fe();
        vec = new Vector3f();
        vec2 = new Vector3f();
    }
}

