/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.client;

import CoroUtil.api.weather.IWindHandler;
import CoroUtil.config.ConfigCoroUtil;
import CoroUtil.util.CoroUtilEntOrParticle;
import extendedrenderer.EventHandler;
import extendedrenderer.particle.behavior.ParticleBehaviors;
import extendedrenderer.particle.entity.EntityRotFX;
import extendedrenderer.particle.entity.ParticleTexExtraRender;
import extendedrenderer.particle.entity.ParticleTexFX;
import extendedrenderer.particle.entity.ParticleTexLeafColor;
import extendedrenderer.render.RotatingParticleManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleFlame;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.api.WindReader;
import net.mrbt0907.weather2.api.weather.IWeatherRain;
import net.mrbt0907.weather2.api.weather.WeatherEnum;
import net.mrbt0907.weather2.client.entity.particle.EntityWaterfallFX;
import net.mrbt0907.weather2.client.event.ClientTickHandler;
import net.mrbt0907.weather2.client.foliage.FoliageEnhancerShader;
import net.mrbt0907.weather2.client.weather.WeatherManagerClient;
import net.mrbt0907.weather2.config.ConfigMisc;
import net.mrbt0907.weather2.config.ConfigParticle;
import net.mrbt0907.weather2.config.ConfigStorm;
import net.mrbt0907.weather2.config.ConfigVolume;
import net.mrbt0907.weather2.config.EZConfigParser;
import net.mrbt0907.weather2.registry.ParticleRegistry;
import net.mrbt0907.weather2.registry.SoundRegistry;
import net.mrbt0907.weather2.util.BlockSESnapshot;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.util.WeatherUtil;
import net.mrbt0907.weather2.util.WeatherUtilBlock;
import net.mrbt0907.weather2.util.WeatherUtilEntity;
import net.mrbt0907.weather2.util.WeatherUtilParticle;
import net.mrbt0907.weather2.util.WeatherUtilSound;
import net.mrbt0907.weather2.weather.WindManager;
import net.mrbt0907.weather2.weather.storm.SandstormObject;
import net.mrbt0907.weather2.weather.storm.StormObject;
import net.mrbt0907.weather2.weather.storm.WeatherObject;

public class NewSceneEnhancer
implements Runnable {
    private static final NewSceneEnhancer INSTANCE = new NewSceneEnhancer();
    private final List<BlockPos> RANDOM_POS;
    private volatile boolean run = true;
    private int errors = 0;
    private int errorsThreaded = 0;
    protected final Minecraft MC;
    protected volatile WeatherObject cachedSystem;
    protected volatile double cachedSystemDistance = -1.0;
    protected volatile double cachedFunnelDistance = -1.0;
    protected volatile float cachedWindSpeed;
    protected volatile float cachedWindDirection;
    protected long ticksExisted;
    protected long ticksThreadExisted;
    protected volatile boolean inGame;
    public final List<BlockSESnapshot> queue = new ArrayList<BlockSESnapshot>();
    public final ParticleBehaviors behavior;
    public float rain;
    public float rainTarget;
    public float overcast;
    public float overcastTarget;
    public float overcastMult;
    public float overcastTargetMult;
    public float fogMult;
    public boolean enableFog;
    public float fogDensity;
    public float fogRed = -1.0f;
    public float fogRedTarget = -1.0f;
    public float fogGreen = -1.0f;
    public float fogGreenTarget = -1.0f;
    public float fogBlue = -1.0f;
    public float fogBlueTarget = -1.0f;
    public float dampness;
    public float renderDistance;

    NewSceneEnhancer() {
        this.MC = FMLClientHandler.instance().getClient();
        this.behavior = new ParticleBehaviors(null);
        this.RANDOM_POS = new ArrayList<BlockPos>();
        this.RANDOM_POS.add(new BlockPos(0, -1, 0));
        this.RANDOM_POS.add(new BlockPos(1, 0, 0));
        this.RANDOM_POS.add(new BlockPos(-1, 0, 0));
        this.RANDOM_POS.add(new BlockPos(0, 0, 1));
        this.RANDOM_POS.add(new BlockPos(0, 0, -1));
    }

    public static NewSceneEnhancer instance() {
        return INSTANCE;
    }

    protected void tickThread() {
        if (this.MC.field_71441_e != null && this.MC.field_71439_g != null && EZConfigParser.isEffectsEnabled(this.MC.field_71441_e.field_73011_w.getDimension())) {
            Maths.Vec3 playerPos = new Maths.Vec3(this.MC.field_71439_g.field_70165_t, this.MC.field_71439_g.field_70163_u, this.MC.field_71439_g.field_70161_v);
            Maths.Vec playerPos2D = new Maths.Vec(this.MC.field_71439_g.field_70165_t, this.MC.field_71439_g.field_70161_v);
            if (this.ticksThreadExisted % 2L == 0L) {
                WeatherObject weatherObject = this.cachedSystem = ClientTickHandler.weatherManager != null ? ClientTickHandler.weatherManager.getClosestWeather(playerPos, this.renderDistance, 0, Integer.MAX_VALUE, WeatherEnum.Type.CLOUD) : null;
            }
            if (this.cachedSystem != null) {
                this.cachedSystemDistance = this.cachedSystem.pos.distanceSq(playerPos2D);
                if (this.cachedSystem instanceof StormObject) {
                    this.cachedFunnelDistance = ((StormObject)this.cachedSystem).pos_funnel_base.distanceSq(playerPos);
                }
            } else {
                if (this.cachedSystemDistance >= 0.0) {
                    this.cachedSystemDistance = -1.0;
                }
                if (this.cachedFunnelDistance >= 0.0) {
                    this.cachedFunnelDistance = -1.0;
                }
            }
            this.cachedWindDirection = WindReader.getWindAngle((World)this.MC.field_71441_e, playerPos);
            this.cachedWindSpeed = WindReader.getWindSpeed((World)this.MC.field_71441_e, playerPos);
            this.tickQueuePrecipitation();
            this.tickQueueFog();
            this.tickQueueParticles();
            this.tickQueueSounds();
        }
    }

    protected void tickQueueFog() {
        if (this.cachedSystem != null) {
            float max = 0.1f;
            if (this.cachedSystem instanceof SandstormObject) {
                this.fogDensity = (float)((1.0 - Math.min(this.cachedSystemDistance / 300.0, 1.0)) * (double)max * ConfigParticle.fog_mult);
                this.fogRedTarget = 0.35f;
                this.fogGreenTarget = 0.22f;
                this.fogBlueTarget = 0.1f;
                return;
            }
            if (this.rainTarget != 0.0f) {
                this.fogDensity = Math.max((Math.abs(this.rain) - 0.31f) / 0.69f, 0.0f) * max * (float)ConfigParticle.fog_mult;
                return;
            }
        }
        this.fogDensity = 0.0f;
    }

    protected void tickQueuePrecipitation() {
        if (this.cachedSystem != null && this.cachedSystem instanceof IWeatherRain) {
            IWeatherRain system = (IWeatherRain)((Object)this.cachedSystem);
            float size = (float)this.cachedSystem.size * 0.875f;
            int stage = this.cachedSystem.getStage();
            Vec3d playerPos = Minecraft.func_71410_x().field_71439_g.func_174791_d();
            if (this.cachedSystem.getPos().distanceSq(playerPos) > (double)size * 1.25) {
                this.overcastTarget = 0.0f;
                this.rainTarget = 0.0f;
                this.MC.field_71441_e.func_72912_H().func_76084_b(false);
                this.MC.field_71441_e.func_72912_H().func_76069_a(false);
                return;
            }
            this.overcastTarget = (stage == 0 ? 0.0f : (stage == 1 ? 0.35f : (stage == 2 ? 0.6f : 1.0f))) - (float)Maths.clamp((this.cachedSystemDistance - (double)size) / (double)this.cachedSystem.size, 0.0, 1.0);
            if (this.cachedSystem != null && this.cachedSystem instanceof StormObject) {
                StormObject storm = (StormObject)this.cachedSystem;
                float f = storm.isViolent ? 1.0f : (this.overcastTargetMult = stage >= 2 ? 0.4f : 0.0f);
            }
            if (system.hasDownfall()) {
                this.rainTarget = Math.min((system.getDownfall() - 100.0f) * this.overcast * 0.0034f, 1.0f);
                if (WeatherUtil.getTemperature((World)this.MC.field_71441_e, this.MC.field_71439_g.func_180425_c()) < 0.0f) {
                    this.rainTarget = -this.rainTarget;
                }
                this.MC.field_71441_e.func_72912_H().func_76084_b(true);
                this.MC.field_71441_e.func_72912_H().func_76069_a(true);
                return;
            }
        }
        if (ConfigMisc.overcast_mode && ClientTickHandler.weatherManager != null && ClientTickHandler.weatherManager.weatherID >= 1) {
            this.overcastTarget = (float)ConfigStorm.min_overcast_rain;
            this.overcastTargetMult = (float)ConfigStorm.min_overcast_rain;
            this.rainTarget = (float)ConfigStorm.min_overcast_rain;
            this.MC.field_71441_e.func_72912_H().func_76084_b(true);
            this.MC.field_71441_e.func_72912_H().func_76069_a(true);
            return;
        }
        this.overcastTarget = 0.0f;
        this.rainTarget = 0.0f;
        this.MC.field_71441_e.func_72912_H().func_76084_b(false);
        this.MC.field_71441_e.func_72912_H().func_76069_a(false);
    }

    protected void tickQueueParticles() {
        if (this.ticksThreadExisted % 10L == 0L) {
            int areaWidth = 20;
            int areaHeight = (int)((float)areaWidth * 0.5f);
            int posX = (int)this.MC.field_71439_g.field_70165_t;
            int posY = (int)this.MC.field_71439_g.field_70163_u;
            int posZ = (int)this.MC.field_71439_g.field_70161_v;
            ArrayList<BlockSESnapshot> snapshots = new ArrayList<BlockSESnapshot>();
            if (ConfigParticle.enable_falling_leaves || ConfigParticle.enable_waterfall_splash || ConfigParticle.enable_fire_particle) {
                for (int x = posX - areaWidth; x < posX + areaWidth; ++x) {
                    for (int y = posY - areaHeight; y < posY + areaHeight; ++y) {
                        for (int z = posZ - areaWidth; z < posZ + areaWidth; ++z) {
                            IBlockState state = this.getBlockState(x, y, z);
                            Block block = state.func_177230_c();
                            if (block.equals(Blocks.field_150350_a)) continue;
                            BlockPos pos = new BlockPos(x, y, z);
                            BlockPos neighborPos = this.getRandomNeighbor(pos);
                            Material material = state.func_185904_a();
                            int meta = block.func_176201_c(state);
                            if (ConfigParticle.enable_falling_leaves && (material.equals(Material.field_151584_j) || material.equals(Material.field_151582_l) || material.equals(Material.field_151585_k)) && neighborPos != null) {
                                snapshots.add(new BlockSESnapshot(state, pos, neighborPos, 0));
                                continue;
                            }
                            if (ConfigParticle.enable_waterfall_splash && material.equals(Material.field_151586_h)) {
                                if ((meta & 8) == 0) continue;
                                IBlockState state2 = this.getBlockState(x, y - 1, z);
                                IBlockState state3 = this.getBlockState(x, y + 10, z);
                                int meta2 = state2.func_177230_c().func_176201_c(state2);
                                if (state2 != null && state2.func_185904_a().equals(Material.field_151586_h) && (meta2 & 8) != 0 || state3 == null || state3.func_185904_a() != Material.field_151586_h) continue;
                                snapshots.add(new BlockSESnapshot(state, pos, null, 1));
                                continue;
                            }
                            if (!ConfigParticle.enable_fire_particle || block != Blocks.field_150480_ab) continue;
                            snapshots.add(new BlockSESnapshot(state, pos, null, 2));
                        }
                    }
                }
                this.queue.clear();
                this.queue.addAll(snapshots);
            } else if (!this.queue.isEmpty()) {
                this.queue.clear();
            }
        }
    }

    protected void tickQueueSounds() {
    }

    public void tickRender(TickEvent.RenderTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START) && this.MC.field_71441_e != null) {
            this.MC.field_71441_e.func_72894_k(Math.abs(this.overcast));
            this.MC.field_71441_e.func_147442_i(this.overcastMult);
        }
    }

    protected void tickNonThread() {
        if (this.inGame && this.MC.field_71441_e == null) {
            this.inGame = false;
            this.reset();
        } else if (!this.inGame && this.MC.field_71441_e != null && ClientTickHandler.weatherManager != null) {
            this.inGame = true;
            Weather2.debug("Scene Enhancer is online!");
        }
        if (this.inGame && !this.MC.func_147113_T()) {
            if (ConfigParticle.camera_shake_mult > 0.0) {
                float strength;
                float windStrength;
                float tornadoStrength = 0.0f;
                float f = windStrength = WeatherUtilEntity.isEntityOutside((Entity)this.MC.field_71439_g, true) ? 0.1f * Maths.clamp((this.cachedWindSpeed - 4.0f) * 0.2f, 0.0f, 1.0f) : 0.0f;
                if (this.cachedSystem != null && this.cachedSystem instanceof StormObject) {
                    StormObject storm = (StormObject)this.cachedSystem;
                    if (storm.type.equals((Object)WeatherEnum.Type.TORNADO)) {
                        tornadoStrength = (1.0f - (float)Math.min((this.cachedFunnelDistance - (double)storm.funnelSize) / (double)(storm.funnelSize + 64.0f), 1.0)) * Math.min((float)storm.stage * 0.1f, 1.0f);
                    }
                }
                if ((strength = tornadoStrength + windStrength) > 0.0f) {
                    this.shakeCamera(strength * (float)ConfigParticle.camera_shake_mult);
                }
            }
            this.tickFog();
            this.tickPrecipitation();
            this.tickAmbiance();
            this.tickParticles();
            this.tickSounds();
            if (ConfigCoroUtil.foliageShaders && EventHandler.queryUseOfShaders()) {
                if (!FoliageEnhancerShader.useThread && this.MC.field_71441_e.func_82737_E() % 40L == 0L) {
                    FoliageEnhancerShader.tickClientThreaded();
                }
                if (this.MC.field_71441_e.func_82737_E() % 5L == 0L) {
                    FoliageEnhancerShader.tickClientCloseToPlayer();
                }
            }
        }
    }

    protected void tickPrecipitation() {
        block13: {
            int particleCountSplash;
            float rate = 5.0E-4f * Math.abs((float)ConfigParticle.rain_change_mult);
            if (this.rainTarget < 0.0f && this.rain > 0.0f || this.rainTarget >= 0.0f && this.rain < 0.0f) {
                this.rain = -this.rain;
            }
            if (this.rain != this.rainTarget) {
                this.rain = Maths.adjust(this.rain, this.rainTarget, rate);
            }
            if (this.overcast != this.overcastTarget) {
                this.overcast = Maths.adjust(this.overcast, this.overcastTarget, rate);
            }
            if (this.overcastMult != this.overcastTargetMult) {
                this.overcastMult = Maths.adjust(this.overcastMult, this.overcastTargetMult, rate);
            }
            if (ConfigParticle.enable_vanilla_rain || !(ConfigParticle.precipitation_particle_rate > 0.0) || this.rain == 0.0f) break block13;
            boolean snowing = this.rain < 0.0f;
            int particleCount = (int)Math.abs((double)(this.rain * 15.0f) * ConfigParticle.precipitation_particle_rate);
            int spawnArea = 20;
            if (particleCount > 200) {
                particleCount = 200;
            }
            int particleCountSheet = ConfigParticle.enable_heavy_precipitation && this.rain > 0.5f ? (int)((float)(particleCount += 5) * 0.2f) : 0;
            int n = particleCountSplash = ConfigParticle.enable_precipitation_splash ? particleCount * 4 : 0;
            if (snowing) {
                spawnArea = 50;
                for (int i = 0; i < particleCount; ++i) {
                    BlockPos pos = new BlockPos(this.MC.field_71439_g.field_70165_t + (double)this.MC.field_71441_e.field_73012_v.nextInt(spawnArea) - (double)this.MC.field_71441_e.field_73012_v.nextInt(spawnArea), this.MC.field_71439_g.field_70163_u - 5.0 + (double)this.MC.field_71441_e.field_73012_v.nextInt(25), this.MC.field_71439_g.field_70161_v + (double)this.MC.field_71441_e.field_73012_v.nextInt(spawnArea) - (double)this.MC.field_71441_e.field_73012_v.nextInt(spawnArea));
                    BlockPos posPrecip = this.MC.field_71441_e.func_175725_q(pos);
                    if (posPrecip.func_177956_o() > pos.func_177956_o()) continue;
                    ParticleTexExtraRender snow = new ParticleTexExtraRender((World)this.MC.field_71441_e, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0, 0.0, 0.0, extendedrenderer.particle.ParticleRegistry.snow);
                    snow.setCanCollide(false);
                    snow.setKillWhenUnderTopmostBlock(true);
                    snow.setTicksFadeOutMaxOnDeath(5.0f);
                    snow.setDontRenderUnderTopmostBlock(true);
                    snow.setExtraParticlesBaseAmount(10);
                    snow.killWhenFarFromCameraAtLeast = 20;
                    snow.setMotionY(-0.1);
                    snow.setScale(1.3f);
                    snow.setGravity(0.1f);
                    snow.windWeight = 2.5f;
                    snow.func_187114_a(40);
                    snow.setFacePlayer(false);
                    snow.setTicksFadeInMax(5.0f);
                    snow.func_82338_g(0.0f);
                    snow.setTicksFadeOutMax(5.0f);
                    snow.rotationYaw = (float)snow.getWorld().field_73012_v.nextInt(360) - 180.0f;
                    this.spawnParticle((Particle)snow, false);
                }
            } else {
                ParticleTexExtraRender particle;
                BlockPos posPrecip;
                BlockPos pos;
                int i;
                int type = this.rain > 0.6f ? 2 : (this.rain > 0.3f ? 1 : 0);
                for (i = 0; i < particleCount; ++i) {
                    pos = new BlockPos(this.MC.field_71439_g.field_70165_t + (double)this.MC.field_71441_e.field_73012_v.nextInt(spawnArea) - (double)this.MC.field_71441_e.field_73012_v.nextInt(spawnArea), this.MC.field_71439_g.field_70163_u - 5.0 + (double)this.MC.field_71441_e.field_73012_v.nextInt(25), this.MC.field_71439_g.field_70161_v + (double)this.MC.field_71441_e.field_73012_v.nextInt(spawnArea) - (double)this.MC.field_71441_e.field_73012_v.nextInt(spawnArea));
                    posPrecip = this.MC.field_71441_e.func_175725_q(pos);
                    if (posPrecip.func_177956_o() > pos.func_177956_o()) continue;
                    particle = new ParticleTexExtraRender((World)this.MC.field_71441_e, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0, 0.0, 0.0, type == 2 ? ParticleRegistry.rainHeavy : (type == 1 ? extendedrenderer.particle.ParticleRegistry.rain_white : ParticleRegistry.rainLight));
                    particle.setKillWhenUnderTopmostBlock(true);
                    particle.setCanCollide(false);
                    particle.killWhenUnderCameraAtLeast = 5;
                    particle.setTicksFadeOutMaxOnDeath(5.0f);
                    particle.setDontRenderUnderTopmostBlock(true);
                    particle.setExtraParticlesBaseAmount(15);
                    particle.fastLight = true;
                    particle.setSlantParticleToWind(true);
                    particle.windWeight = 1.0f;
                    if (!RotatingParticleManager.useShaders || !ConfigCoroUtil.particleShaders) {
                        particle.setFacePlayer(true);
                        particle.setSlantParticleToWind(true);
                    } else {
                        particle.setFacePlayer(false);
                        particle.extraYRotation = (float)this.MC.field_71441_e.field_73012_v.nextInt(360) - 180.0f;
                    }
                    particle.setScale(type == 2 ? 6.0f : 2.0f);
                    particle.isTransparent = true;
                    particle.setGravity(2.5f);
                    particle.func_187114_a(50);
                    particle.setTicksFadeInMax(5.0f);
                    particle.func_82338_g(0.0f);
                    particle.rotationYaw = (float)this.MC.field_71441_e.field_73012_v.nextInt(360) - 180.0f;
                    particle.setMotionY(-0.5);
                    particle.renderOrder = 2;
                    this.spawnParticle((Particle)particle, false);
                }
                spawnArea = 50;
                for (i = 0; i < particleCountSplash; ++i) {
                    pos = new BlockPos(this.MC.field_71439_g.field_70165_t + (double)this.MC.field_71441_e.field_73012_v.nextInt(spawnArea) - (double)((float)spawnArea * 0.5f), this.MC.field_71439_g.field_70163_u - 5.0 + (double)this.MC.field_71441_e.field_73012_v.nextInt(15), this.MC.field_71439_g.field_70161_v + (double)this.MC.field_71441_e.field_73012_v.nextInt(spawnArea) - (double)((float)spawnArea * 0.5f));
                    pos = this.MC.field_71441_e.func_175725_q(pos).func_177977_b();
                    IBlockState state = this.MC.field_71441_e.func_180495_p(pos);
                    AxisAlignedBB axisalignedbb = state.func_185900_c((IBlockAccess)this.MC.field_71441_e, pos);
                    if (this.MC.field_71441_e.func_175725_q(pos).func_177956_o() > pos.func_177984_a().func_177956_o()) continue;
                    particle = new ParticleTexFX(this.MC.field_71439_g.field_70170_p, (double)((float)pos.func_177958_n() + this.MC.field_71441_e.field_73012_v.nextFloat()), (double)pos.func_177956_o() + 0.01 + axisalignedbb.field_72337_e, (double)((float)pos.func_177952_p() + this.MC.field_71441_e.field_73012_v.nextFloat()), 0.0, 0.0, 0.0, ParticleRegistry.rainSplash);
                    particle.setKillWhenUnderTopmostBlock(true);
                    particle.setCanCollide(false);
                    particle.killWhenUnderCameraAtLeast = 5;
                    boolean upward = this.MC.field_71441_e.field_73012_v.nextBoolean();
                    particle.windWeight = 20.0f;
                    particle.setFacePlayer(upward);
                    particle.setScale(1.0f + this.MC.field_71441_e.field_73012_v.nextFloat());
                    particle.func_187114_a(15);
                    particle.setGravity(-0.0f);
                    particle.setTicksFadeInMax(0.0f);
                    particle.func_82338_g(0.0f);
                    particle.setTicksFadeOutMax(4.0f);
                    particle.rotationYaw = (float)this.MC.field_71441_e.field_73012_v.nextInt(360) - 180.0f;
                    particle.rotationPitch = 90.0f;
                    particle.setMotionY(0.0);
                    particle.setMotionX((double)((this.MC.field_71441_e.field_73012_v.nextFloat() - 0.5f) * 0.01f));
                    particle.setMotionZ((double)((this.MC.field_71441_e.field_73012_v.nextFloat() - 0.5f) * 0.01f));
                    this.spawnParticle((Particle)particle, false);
                }
                spawnArea = 60;
                for (i = 0; i < particleCountSheet; ++i) {
                    pos = new BlockPos(this.MC.field_71439_g.field_70165_t + (double)this.MC.field_71441_e.field_73012_v.nextInt(spawnArea) - (double)((float)spawnArea * 0.5f), this.MC.field_71439_g.field_70163_u - 5.0 + (double)this.MC.field_71441_e.field_73012_v.nextInt(35), this.MC.field_71439_g.field_70161_v + (double)this.MC.field_71441_e.field_73012_v.nextInt(spawnArea) - (double)((float)spawnArea * 0.5f));
                    posPrecip = this.MC.field_71441_e.func_175725_q(pos);
                    if (posPrecip.func_177956_o() > pos.func_177956_o()) continue;
                    particle = new ParticleTexExtraRender(this.MC.field_71439_g.field_70170_p, (double)((float)pos.func_177958_n() + this.MC.field_71441_e.field_73012_v.nextFloat()), (double)(pos.func_177956_o() - 1) + 0.01, (double)((float)pos.func_177952_p() + this.MC.field_71441_e.field_73012_v.nextFloat()), 0.0, 0.0, 0.0, extendedrenderer.particle.ParticleRegistry.downfall3);
                    particle.setCanCollide(false);
                    particle.killWhenUnderCameraAtLeast = 5;
                    particle.setKillWhenUnderTopmostBlock(true);
                    particle.setKillWhenUnderTopmostBlock_ScanAheadRange(3);
                    particle.setTicksFadeOutMaxOnDeath(10.0f);
                    particle.noExtraParticles = true;
                    particle.windWeight = 19.0f;
                    particle.setFacePlayer(true);
                    particle.facePlayerYaw = true;
                    particle.setScale(200.0f + this.MC.field_71441_e.field_73012_v.nextFloat() * 3.0f);
                    particle.func_187114_a(60);
                    particle.setGravity(0.35f);
                    particle.setTicksFadeInMax(20.0f);
                    particle.func_82338_g(0.0f);
                    particle.setTicksFadeOutMax(20.0f);
                    particle.rotationYaw = (float)this.MC.field_71441_e.field_73012_v.nextInt(360) - 180.0f;
                    particle.rotationPitch = 90.0f;
                    particle.rotationPitch = 0.0f;
                    particle.setMotionY(-0.3);
                    particle.setMotionX((double)((this.MC.field_71441_e.field_73012_v.nextFloat() - 0.5f) * 0.01f));
                    particle.setMotionZ((double)((this.MC.field_71441_e.field_73012_v.nextFloat() - 0.5f) * 0.01f));
                    this.spawnParticle((Particle)particle, false);
                }
            }
        }
    }

    protected void tickFog() {
        float mult = (float)ConfigParticle.fog_change_rate;
        this.fogMult = Maths.adjust(this.fogMult, this.fogDensity, (this.fogMult < 0.1f ? 5.0E-5f : 0.001f) * mult);
        if (this.fogRed >= 0.0f && this.fogRed != this.fogRedTarget) {
            this.fogRed = Maths.adjust(this.fogRed, this.fogRedTarget, 0.001f * mult);
        }
        if (this.fogGreen >= 0.0f && this.fogGreen != this.fogGreenTarget) {
            this.fogGreen = Maths.adjust(this.fogGreen, this.fogGreenTarget, 0.001f * mult);
        }
        if (this.fogBlue >= 0.0f && this.fogBlue != this.fogBlueTarget) {
            this.fogBlue = Maths.adjust(this.fogBlue, this.fogBlueTarget, 0.001f * mult);
        }
    }

    protected void tickAmbiance() {
        ArrayList<BlockSESnapshot> snapshots = new ArrayList<BlockSESnapshot>(this.queue);
        int particleCount = (int)(160.0 / Maths.clamp(ConfigParticle.ambient_particle_rate, 1.0E-4, 159.0));
        block5: for (BlockSESnapshot snapshot : snapshots) {
            if (this.MC.field_71441_e.field_73012_v.nextInt(particleCount) != 0) continue;
            switch (snapshot.type) {
                case 0: {
                    Object particle = new ParticleTexLeafColor((World)this.MC.field_71441_e, (double)snapshot.x, (double)snapshot.y, (double)snapshot.z, 0.0, 0.0, 0.0, extendedrenderer.particle.ParticleRegistry.leaf);
                    particle.func_187109_b((double)snapshot.x + (double)snapshot.rX * (0.04 + Maths.random(0.75)), (double)snapshot.y + (double)snapshot.rY * (0.04 + Maths.random(0.75)), (double)snapshot.z + (double)snapshot.rZ * (0.04 + Maths.random(0.75)));
                    particle.setPrevPosX(particle.field_187126_f);
                    particle.setPrevPosY(particle.field_187127_g);
                    particle.setPrevPosZ(particle.field_187128_h);
                    particle.setMotionX(0.0);
                    particle.setMotionY(0.0);
                    particle.setMotionZ(0.0);
                    particle.setGravity(0.05f);
                    particle.setCanCollide(true);
                    particle.setKillOnCollide(false);
                    particle.windWeight = 10.0f;
                    particle.collisionSpeedDampen = false;
                    particle.killWhenUnderCameraAtLeast = 20;
                    particle.killWhenFarFromCameraAtLeast = 20;
                    particle.isTransparent = false;
                    particle.rotationYaw = this.MC.field_71441_e.field_73012_v.nextInt(360);
                    particle.rotationPitch = this.MC.field_71441_e.field_73012_v.nextInt(360);
                    particle.updateQuaternion(null);
                    this.spawnParticle((Particle)particle, false);
                    break;
                }
                case 1: {
                    Object particle;
                    for (int i = 0; i < 10; ++i) {
                        particle = new EntityWaterfallFX((World)this.MC.field_71441_e, (double)snapshot.x + 0.5 + (double)(this.MC.field_71441_e.field_73012_v.nextFloat() * 2.0f - 1.0f), (double)snapshot.y + (double)0.7f + (double)(this.MC.field_71441_e.field_73012_v.nextFloat() * 2.0f - 1.0f), (double)snapshot.z + 0.5 + (double)(this.MC.field_71441_e.field_73012_v.nextFloat() * 2.0f - 1.0f), this.MC.field_71441_e.field_73012_v.nextFloat() * 0.2f - 0.1f, this.MC.field_71441_e.field_73012_v.nextFloat() * 0.2f - 0.1f, this.MC.field_71441_e.field_73012_v.nextFloat() * 0.2f - 0.1f, 2.0, 3);
                        particle.setMotionY(4.5);
                        this.spawnParticle((Particle)particle, true);
                    }
                    continue block5;
                }
                case 2: {
                    double speed = 0.15;
                    Object particle = new ParticleTexFX((World)this.MC.field_71441_e, (double)snapshot.x + this.MC.field_71441_e.field_73012_v.nextDouble(), (double)snapshot.y + 0.2 + this.MC.field_71441_e.field_73012_v.nextDouble() * 0.2, (double)snapshot.z + this.MC.field_71441_e.field_73012_v.nextDouble(), (this.MC.field_71441_e.field_73012_v.nextDouble() - this.MC.field_71441_e.field_73012_v.nextDouble()) * speed, 0.03, (this.MC.field_71441_e.field_73012_v.nextDouble() - this.MC.field_71441_e.field_73012_v.nextDouble()) * speed, extendedrenderer.particle.ParticleRegistry.smoke);
                    ParticleBehaviors.setParticleRandoms((EntityRotFX)particle, (boolean)true, (boolean)true);
                    ParticleBehaviors.setParticleFire((EntityRotFX)particle);
                    particle.func_187114_a(100 + this.MC.field_71441_e.field_73012_v.nextInt(300));
                    this.spawnParticle((Particle)particle, true);
                }
            }
        }
        snapshots = null;
    }

    protected void tickParticles() {
        WeatherManagerClient weatherMan = ClientTickHandler.weatherManager;
        if (weatherMan == null) {
            return;
        }
        WindManager windMan = weatherMan.windManager;
        if (windMan == null) {
            return;
        }
        Random rand = this.MC.field_71441_e.field_73012_v;
        for (int i = 0; i < ClientTickHandler.weatherManager.effectedParticles.size(); ++i) {
            Particle particle = ClientTickHandler.weatherManager.effectedParticles.get(i);
            if (particle == null || !particle.func_187113_k()) {
                ClientTickHandler.weatherManager.effectedParticles.remove(i--);
                continue;
            }
            Maths.Vec3 vec3 = new Maths.Vec3(this.MC.field_71439_g.field_70165_t, this.MC.field_71439_g.field_70163_u, this.MC.field_71439_g.field_70161_v);
            if (!((double)WindReader.getWindSpeed((World)this.MC.field_71441_e, vec3) > 0.0) || !(particle instanceof EntityRotFX)) continue;
            EntityRotFX entity1 = (EntityRotFX)particle;
            if (WeatherUtilBlock.getPrecipitationHeightSafe((World)this.MC.field_71441_e, new BlockPos(MathHelper.func_76128_c((double)entity1.getPosX()), 0, MathHelper.func_76128_c((double)entity1.getPosZ()))).func_177956_o() - 1 < (int)entity1.getPosY() + 1 || entity1 instanceof ParticleTexFX) {
                if (entity1 instanceof IWindHandler) {
                    if (entity1.getParticleDecayExtra() > 0 && WeatherUtilParticle.getParticleAge((Particle)entity1) % 2 == 0) {
                        WeatherUtilParticle.setParticleAge((Particle)entity1, WeatherUtilParticle.getParticleAge((Particle)entity1) + entity1.getParticleDecayExtra());
                    }
                } else if (WeatherUtilParticle.getParticleAge((Particle)entity1) % 2 == 0) {
                    WeatherUtilParticle.setParticleAge((Particle)entity1, WeatherUtilParticle.getParticleAge((Particle)entity1) + 1);
                }
                if (entity1 instanceof ParticleTexFX && ((ParticleTexFX)entity1).getParticleTexture() == extendedrenderer.particle.ParticleRegistry.leaf) {
                    if (entity1.getMotionX() < (double)0.01f && entity1.getMotionZ() < (double)0.01f) {
                        entity1.setMotionY(entity1.getMotionY() + rand.nextDouble() * 0.02 * (double)((ParticleTexFX)entity1).field_70545_g);
                    }
                    entity1.setMotionY(entity1.getMotionY() - (double)(0.01f * ((ParticleTexFX)entity1).field_70545_g));
                }
            }
            windMan.getEntityWindVectors(entity1, 0.05f, 5.0f);
        }
        if (WeatherUtilParticle.fxLayers == null) {
            WeatherUtilParticle.getFXLayers();
        }
        for (int layer = 0; layer < WeatherUtilParticle.fxLayers.length; ++layer) {
            for (int i = 0; i < WeatherUtilParticle.fxLayers[layer].length; ++i) {
                for (Particle entity1 : WeatherUtilParticle.fxLayers[layer][i]) {
                    String className = entity1.getClass().getName();
                    if (className.equals("net.minecraft.client.particle.Barrier") || ConfigParticle.enable_vanilla_rain && className.equals("net.minecraft.client.particle.ParticleRain") || WeatherUtilBlock.getPrecipitationHeightSafe((World)this.MC.field_71441_e, new BlockPos(MathHelper.func_76128_c((double)CoroUtilEntOrParticle.getPosX((Object)entity1)), 0, MathHelper.func_76128_c((double)CoroUtilEntOrParticle.getPosZ((Object)entity1)))).func_177956_o() - 1 >= (int)CoroUtilEntOrParticle.getPosY((Object)entity1) + 1 && !(entity1 instanceof ParticleTexFX)) continue;
                    if (entity1 instanceof ParticleFlame) {
                        if ((double)windMan.windSpeed >= 0.2) {
                            ++entity1.field_70546_d;
                        }
                    } else if (entity1 instanceof IWindHandler && ((IWindHandler)entity1).getParticleDecayExtra() > 0 && WeatherUtilParticle.getParticleAge(entity1) % 2 == 0) {
                        entity1.field_70546_d += ((IWindHandler)entity1).getParticleDecayExtra();
                    }
                    if (!(entity1 instanceof EntityWaterfallFX) && CoroUtilEntOrParticle.getMotionX((Object)entity1) < (double)0.01f && CoroUtilEntOrParticle.getMotionZ((Object)entity1) < (double)0.01f) {
                        CoroUtilEntOrParticle.setMotionY((Object)entity1, (double)(CoroUtilEntOrParticle.getMotionY((Object)entity1) + rand.nextDouble() * 0.02));
                    }
                    windMan.getEntityWindVectors(entity1, 0.05f, 0.5f);
                }
            }
        }
    }

    protected void tickSounds() {
        Maths.Vec3 pos = new Maths.Vec3(this.MC.field_71439_g.field_70165_t, this.MC.field_71439_g.field_70163_u, this.MC.field_71439_g.field_70161_v);
        List<WeatherObject> weather = ClientTickHandler.weatherManager.getWeatherObjects();
        float windSpeed = WindReader.getWindSpeed((World)this.MC.field_71441_e, pos);
        int size = weather.size();
        int success = 0;
        WeatherUtilSound.tick();
        if (!ConfigParticle.enable_vanilla_rain) {
            BlockPos playerPos = this.MC.field_71439_g.func_180425_c();
            BlockPos groundPos = this.MC.field_71441_e.func_175725_q(playerPos);
            if (this.MC.field_71441_e.field_73012_v.nextInt(3) == 0 && playerPos.func_177951_i((Vec3i)groundPos) < 16.0 && (double)this.rain > 0.0) {
                int type = this.rain > 0.6f ? 2 : (this.rain > 0.3f ? 1 : 0);
                WeatherUtilSound.playForcedSound(type == 0 ? SoundRegistry.rainLight : SoundEvents.field_187918_gr, SoundCategory.WEATHER, this.MC.field_71439_g, type == 0 ? 1.0f : 0.1f + this.rain * 0.9f, 1.0f - this.rain * 0.1f, -1.0f, true, false);
            }
        }
        for (int i = 0; i < size && success < 4; ++i) {
            WeatherObject wo = weather.get(i);
            if (wo instanceof StormObject && success < 3) {
                if (!((StormObject)wo).isDeadly() || !(this.cachedFunnelDistance - (double)wo.size + 200.0 <= 0.0)) continue;
                WeatherUtilSound.play2DSound(SoundRegistry.windFast, SoundCategory.WEATHER, ((StormObject)wo).pos_funnel_base, 1000 + i, (float)ConfigVolume.cyclone, ((StormObject)wo).isViolent ? 0.7f : 0.8f, ((StormObject)wo).funnelSize + 350.0f, false);
                if (wo.type.equals((Object)WeatherEnum.Type.TORNADO)) {
                    WeatherUtilSound.play2DSound(SoundRegistry.debris, SoundCategory.WEATHER, ((StormObject)wo).pos_funnel_base, 2000 + i, (float)ConfigVolume.debris, 1.0f, ((StormObject)wo).funnelSize + 150.0f, false);
                }
                success += 2;
                continue;
            }
            if (!(wo.pos.distanceSq(pos) - (double)wo.size + 100.0 <= 0.0)) continue;
            WeatherUtilSound.play2DSound(SoundRegistry.sandstorm, SoundCategory.WEATHER, wo, 3000 + i, (float)ConfigVolume.cyclone, 1.0f, (float)wo.size + 100.0f, false);
            ++success;
        }
        if (windSpeed > 6.5f) {
            if (WeatherUtilSound.isSoundActive(0, SoundRegistry.wind)) {
                WeatherUtilSound.stopSound(0);
            }
            WeatherUtilSound.playSound(SoundRegistry.windFast, SoundCategory.WEATHER, 0, (float)ConfigVolume.wind, 1.0f, false);
        } else if (windSpeed > 1.4f) {
            if (WeatherUtilSound.isSoundActive(0, SoundRegistry.windFast)) {
                WeatherUtilSound.stopSound(0);
            }
            WeatherUtilSound.playSound(SoundRegistry.wind, SoundCategory.WEATHER, 0, (float)ConfigVolume.wind, 1.0f, false);
        }
    }

    public void shakeCamera(float magnitude) {
        this.MC.field_71439_g.field_70177_z += Maths.random(-magnitude, magnitude);
        this.MC.field_71439_g.field_70125_A += Maths.random(-magnitude, magnitude);
    }

    public void spawnParticle(Particle particle, boolean isNormalEffect) {
        if (isNormalEffect) {
            this.MC.field_71452_i.func_78873_a(particle);
        } else {
            if (particle instanceof EntityRotFX) {
                ((EntityRotFX)particle).spawnAsWeatherEffect();
            }
            ClientTickHandler.weatherManager.addEffectedParticle(particle);
        }
    }

    public boolean seesWeatherObject() {
        return this.cachedSystem != null;
    }

    public boolean shouldChangeFogColor() {
        return this.fogRedTarget >= 0.0f || this.fogGreenTarget >= 0.0f || this.fogBlueTarget >= 0.0f || this.fogRed >= 0.0f || this.fogGreen >= 0.0f || this.fogBlue >= 0.0f;
    }

    public boolean shouldChangeFog() {
        return this.fogMult > 0.0f;
    }

    public WeatherObject getWeatherObject() {
        return this.cachedSystem;
    }

    private IBlockState getBlockState(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        if (this.MC.field_71441_e.func_175667_e(pos)) {
            IBlockState state = Weather2.clientChunkUtil.getBlockState((World)this.MC.field_71441_e, pos);
            return state;
        }
        return null;
    }

    private BlockPos getRandomNeighbor(BlockPos pos) {
        Collections.shuffle(this.RANDOM_POS);
        for (BlockPos randPos : this.RANDOM_POS) {
            int z;
            int y;
            BlockPos neighborPos = pos.func_177971_a((Vec3i)randPos);
            int x = neighborPos.func_177958_n();
            IBlockState state = this.getBlockState(x, y = neighborPos.func_177956_o(), z = neighborPos.func_177952_p());
            if (state == null || !state.func_177230_c().equals(Blocks.field_150350_a)) continue;
            return randPos;
        }
        return null;
    }

    @Override
    public void run() {
        while (true) {
            if (!this.run) {
                continue;
            }
            try {
                this.tickThread();
                ++this.ticksThreadExisted;
                this.errorsThreaded = 0;
                Thread.sleep(ConfigParticle.scene_enhancer_thread_delay);
                continue;
            }
            catch (Throwable e) {
                if (this.errorsThreaded < 5) {
                    Weather2.warn("Scene Enhancer tickThread encountered an error. Attempting " + (5 - this.errorsThreaded) + " more time(s)...");
                } else {
                    Weather2.warn("Scene Enhancer tickThread has failed to run successfuly. Disaling scene enhancer...");
                    if (this.MC.field_71439_g != null) {
                        this.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Scene Enhancer has crashed on the scene thread! Disabling scene enhancer..."));
                    }
                    this.run = false;
                    this.reset();
                }
                Weather2.error(e);
                ++this.errorsThreaded;
                continue;
            }
            break;
        }
    }

    public void tick() {
        if (this.run) {
            try {
                this.tickNonThread();
                ++this.ticksExisted;
                this.errors = 0;
            }
            catch (Throwable e) {
                if (this.errors < 5) {
                    Weather2.warn("Scene Enhancer tickNonThread encountered an error. Attempting " + (5 - this.errors) + " more time(s)...");
                } else {
                    Weather2.warn("Scene Enhancer tickNonThread has failed to run successfuly. Disaling scene enhancer...");
                    if (this.MC.field_71439_g != null) {
                        this.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Scene Enhancer has crashed on the client thread! Disabling scene enhancer..."));
                    }
                    this.run = false;
                    this.reset();
                }
                Weather2.error(e);
                ++this.errors;
            }
        }
    }

    public synchronized void reset() {
        this.cachedSystem = null;
        this.errors = 0;
        this.errorsThreaded = 0;
        this.fogMult = 0.0f;
        this.fogDensity = 0.0f;
        this.overcastTargetMult = 0.0f;
        this.overcastMult = 0.0f;
        this.overcastTarget = 0.0f;
        this.overcast = 0.0f;
        this.rainTarget = 0.0f;
        this.rain = 0.0f;
        this.fogBlueTarget = -1.0f;
        this.fogBlue = -1.0f;
        this.fogGreenTarget = -1.0f;
        this.fogGreen = -1.0f;
        this.fogRedTarget = -1.0f;
        this.fogRed = -1.0f;
        if (WeatherUtilParticle.fxLayers == null) {
            WeatherUtilParticle.getFXLayers();
        }
        Weather2.debug("Scene Enhancer has been reset");
    }

    public synchronized void enable() {
        if (!this.run) {
            this.run = true;
            this.reset();
            Weather2.debug("Scene Enhancer has been re-enabled");
        } else {
            Weather2.warn("Scene Enhancer is already running, skipping enable...");
        }
    }
}

