/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.block;

import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.mrbt0907.weather2.api.weather.WeatherEnum;
import net.mrbt0907.weather2.config.ConfigStorm;
import net.mrbt0907.weather2.network.packets.PacketWeatherObject;
import net.mrbt0907.weather2.server.event.ServerTickHandler;
import net.mrbt0907.weather2.server.weather.WeatherManagerServer;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.weather.storm.WeatherObject;

public class TileWeatherDeflector
extends TileEntity
implements ITickable {
    public int mode = 0;
    public static final int MODE_KILLSTORMS = 0;
    public static final int MODE_NOBLOCKDAMAGE = 1;

    public void onLoad() {
        super.onLoad();
        this.maintainBlockDamageDeflect();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            WeatherManagerServer wm;
            if (this.mode == 0 && this.field_145850_b.func_82737_E() % 100L == 0L && (wm = ServerTickHandler.dimensionSystems.get(this.field_145850_b.field_73011_w.getDimension())) != null) {
                ArrayList<WeatherObject> storms = new ArrayList<WeatherObject>(wm.getWeatherSystems(new Maths.Vec3(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()), ConfigStorm.storm_deflector_range, ConfigStorm.storm_deflector_minimum_stage, Integer.MAX_VALUE, new WeatherEnum.Type[0]).keySet());
                int size = storms.size();
                for (int i = 0; i < size; ++i) {
                    WeatherObject wo = (WeatherObject)storms.get(i);
                    wo.front.removeWeatherObject(wo.getUUID());
                    PacketWeatherObject.remove(wm.getDimension(), wo);
                }
                storms.clear();
            }
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.maintainBlockDamageDeflect();
            }
        }
    }

    public void maintainBlockDamageDeflect() {
        WeatherManagerServer wm = ServerTickHandler.dimensionSystems.get(this.field_145850_b.field_73011_w.getDimension());
        if (wm != null) {
            long pos = this.func_174877_v().func_177986_g();
            switch (this.mode) {
                case 1: {
                    if (!wm.getListWeatherBlockDamageDeflector().contains(pos)) break;
                    wm.getListWeatherBlockDamageDeflector().remove(pos);
                    break;
                }
                default: {
                    if (wm.getListWeatherBlockDamageDeflector().contains(pos)) break;
                    wm.getListWeatherBlockDamageDeflector().add(pos);
                }
            }
        }
    }

    public void rightClicked(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        this.cycleMode();
        switch (this.mode) {
            case 1: {
                playerIn.func_145747_a((ITextComponent)new TextComponentString("Deflection Mode: Protect Blocks"));
                this.maintainBlockDamageDeflect();
                break;
            }
            default: {
                playerIn.func_145747_a((ITextComponent)new TextComponentString("Deflection Mode: Destroy Storms"));
            }
        }
    }

    public void cycleMode() {
        this.mode = (this.mode + 1) % 2;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound var1) {
        var1.func_74768_a("mode", this.mode);
        return super.func_189515_b(var1);
    }

    public void func_145839_a(NBTTagCompound var1) {
        super.func_145839_a(var1);
        this.mode = var1.func_74762_e("mode");
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            WeatherManagerServer wm = ServerTickHandler.dimensionSystems.get(this.field_145850_b.field_73011_w.getDimension());
            wm.getListWeatherBlockDamageDeflector().remove(this.func_174877_v().func_177986_g());
        }
    }
}

