/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.block;

import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.api.weather.WeatherEnum;
import net.mrbt0907.weather2.config.ConfigMisc;
import net.mrbt0907.weather2.config.ConfigStorm;
import net.mrbt0907.weather2.network.packets.PacketWeatherObject;
import net.mrbt0907.weather2.server.event.ServerTickHandler;
import net.mrbt0907.weather2.server.weather.WeatherManagerServer;
import net.mrbt0907.weather2.weather.storm.StormObject;
import net.mrbt0907.weather2.weather.storm.WeatherObject;

public class TileWeatherConstructor
extends TileEntity
implements ITickable {
    public int stage = 1;
    public int maxStage = 7;
    public StormObject lastTickStormObject = null;
    public UUID lastTickStormObjectID = null;

    public void cycleWeatherType(boolean reverse) {
        this.maxStage = ConfigStorm.disable_tornados || ConfigMisc.disable_weather_machine_cyclones ? 5 : 7;
        this.stage = (this.stage + (reverse ? -1 : 1)) % (this.maxStage + 1);
        if (this.stage < 0) {
            this.stage = this.maxStage;
        }
        this.setStormSettings();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.killStorm();
    }

    public void setStormSettings() {
        if (this.lastTickStormObject != null) {
            switch (this.stage) {
                case 1: {
                    this.lastTickStormObject.stormType = StormObject.StormType.LAND.ordinal();
                    this.lastTickStormObject.stage = WeatherEnum.Stage.NORMAL.getStage();
                    this.lastTickStormObject.intensity = 0.01f;
                    this.lastTickStormObject.updateType();
                    break;
                }
                case 2: {
                    this.lastTickStormObject.stormType = StormObject.StormType.LAND.ordinal();
                    this.lastTickStormObject.stage = WeatherEnum.Stage.RAIN.getStage();
                    this.lastTickStormObject.intensity = 0.99f;
                    this.lastTickStormObject.updateType();
                    break;
                }
                case 3: {
                    this.lastTickStormObject.stormType = StormObject.StormType.LAND.ordinal();
                    this.lastTickStormObject.stage = WeatherEnum.Stage.THUNDER.getStage();
                    this.lastTickStormObject.intensity = 1.99f;
                    this.lastTickStormObject.updateType();
                    break;
                }
                case 4: {
                    this.lastTickStormObject.stormType = StormObject.StormType.LAND.ordinal();
                    this.lastTickStormObject.stage = WeatherEnum.Stage.SEVERE.getStage();
                    this.lastTickStormObject.intensity = 2.99f;
                    this.lastTickStormObject.hail = 0.0f;
                    this.lastTickStormObject.updateType();
                    break;
                }
                case 5: {
                    this.lastTickStormObject.stormType = StormObject.StormType.LAND.ordinal();
                    this.lastTickStormObject.stage = WeatherEnum.Stage.SEVERE.getStage();
                    this.lastTickStormObject.intensity = 2.99f;
                    this.lastTickStormObject.hail = 150.0f;
                    this.lastTickStormObject.updateType();
                    break;
                }
                case 6: {
                    this.lastTickStormObject.stormType = StormObject.StormType.LAND.ordinal();
                    this.lastTickStormObject.stage = WeatherEnum.Stage.TORNADO.getStage() + 1;
                    this.lastTickStormObject.intensity = 4.99f;
                    this.lastTickStormObject.updateType();
                    break;
                }
                case 7: {
                    this.lastTickStormObject.stormType = StormObject.StormType.WATER.ordinal();
                    this.lastTickStormObject.stage = WeatherEnum.Stage.HURRICANE.getStage();
                    this.lastTickStormObject.intensity = 4.99f;
                    this.lastTickStormObject.updateType();
                    break;
                }
                default: {
                    if (this.lastTickStormObject == null) break;
                    this.killStorm();
                }
            }
        }
    }

    public void createStorm() {
        WeatherManagerServer manager;
        if (this.lastTickStormObject == null && !ConfigMisc.aesthetic_mode && (manager = ServerTickHandler.dimensionSystems.get(this.field_145850_b.field_73011_w.getDimension())) != null) {
            StormObject so = manager.getGlobalFront().createStorm(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177952_p(), 1, null);
            so.isNatural = false;
            so.canProgress = false;
            so.overrideMotion = true;
            so.overrideAngle = true;
            so.shouldConvert = false;
            so.shouldBuildHumidity = false;
            so.rain = 150.0f;
            so.temperature = 40.0f;
            so.stageMax = 5;
            PacketWeatherObject.create(manager.getDimension(), so);
            this.lastTickStormObject = so;
            this.lastTickStormObjectID = so.getUUID();
            this.setStormSettings();
        }
    }

    public void killStorm() {
        if (this.lastTickStormObject != null) {
            this.lastTickStormObject.setDead();
            this.lastTickStormObject = null;
        }
    }

    public void func_73660_a() {
        WeatherManagerServer manager;
        if (!this.field_145850_b.field_72995_K && this.stage > 0 && this.field_145850_b.func_82737_E() % 40L == 0L && (manager = ServerTickHandler.dimensionSystems.get(this.field_145850_b.field_73011_w.getDimension())) != null) {
            if (this.lastTickStormObject == null) {
                if (this.lastTickStormObjectID != null) {
                    WeatherObject system = manager.getGlobalFront().getWeatherObject(this.lastTickStormObjectID);
                    if (system != null) {
                        this.lastTickStormObject = (StormObject)system;
                        Weather2.debug("Weather machine reobtained storm " + system.getUUID());
                    } else {
                        this.createStorm();
                        Weather2.debug("Weather machine created storm " + this.lastTickStormObjectID + " because old storm no longer exists");
                    }
                } else {
                    this.createStorm();
                    Weather2.debug("Weather machine created storm " + this.lastTickStormObjectID);
                }
            } else if (this.lastTickStormObject.isDead) {
                this.lastTickStormObject = null;
                this.lastTickStormObjectID = null;
                this.createStorm();
                Weather2.debug("Weather machine created storm " + this.lastTickStormObjectID + " because old storm has died");
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound var1) {
        super.func_189515_b(var1);
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("weatherType", this.stage);
        if (this.lastTickStormObjectID != null) {
            data.func_186854_a("lastTickStormObjectID", this.lastTickStormObjectID);
        } else if (var1.func_74764_b("lastTickStormObjectID")) {
            data.func_82580_o("lastTickStormObjectID");
        }
        var1.func_74782_a("weatherMachine", (NBTBase)data);
        return var1;
    }

    public void func_145839_a(NBTTagCompound var1) {
        if (var1.func_74764_b("weatherMachine")) {
            NBTTagCompound data = var1.func_74775_l("weatherMachine");
            this.stage = data.func_74762_e("weatherType");
            if (data.func_186855_b("lastTickStormObjectID")) {
                this.lastTickStormObjectID = data.func_186857_a("lastTickStormObjectID");
            }
        }
        super.func_145839_a(var1);
    }
}

