/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.mrbt0907.weather2.api.weather.IWeatherDetectable;
import net.mrbt0907.weather2.api.weather.WeatherEnum;
import net.mrbt0907.weather2.client.event.ClientTickHandler;
import net.mrbt0907.weather2.client.gui.elements.GuiRadarObject;
import net.mrbt0907.weather2.config.ConfigMisc;
import net.mrbt0907.weather2.config.ConfigStorm;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.weather.storm.FrontObject;
import net.mrbt0907.weather2.weather.storm.WeatherObject;

public class TileRadar
extends TileEntity
implements ITickable {
    private int tier = 0;
    private int pingLength = 60;
    private int pingMaxLength = 60;
    public int pingRate = 200;
    public double pingRange = 1024.0;
    public int showType = 0;
    public boolean showRating = false;
    public boolean showEF = false;
    public boolean showDirection = false;
    public boolean showWindSpeed = false;
    public boolean liveRadar = false;
    public float fadeRate = 0.05f;
    public float renderAlpha = 1.0f;
    public float renderRange = 2.0f;
    public float smoothAngle = 0.0f;
    public float smoothSpeed = 0.0f;
    public float smoothAngleRotationalVel = 0.0f;
    public float smoothAngleRotationalVelAccel = 0.0f;
    public float smoothAngleAdj = 0.1f;
    public float smoothSpeedAdj = 0.1f;
    public IWeatherDetectable system = null;
    public List<GuiRadarObject> systems = new ArrayList<GuiRadarObject>();

    public TileRadar() {
    }

    public TileRadar(int tier) {
        this.tier = tier;
        this.refresh();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.tickClient();
        }
    }

    public int getTier() {
        return this.tier;
    }

    private void refresh() {
        this.showEF = ConfigStorm.enable_ef_scale ? true : this.tier > 1;
        switch (this.tier) {
            case 1: {
                this.pingRate = 150;
                this.pingRange = ConfigMisc.doppler_radar_range;
                this.renderRange = 2.0f;
                this.liveRadar = true;
                this.showRating = true;
                this.showDirection = true;
                this.showWindSpeed = true;
                this.liveRadar = true;
                break;
            }
            case 2: {
                this.pingRate = 100;
                this.pingRange = ConfigMisc.pulse_doppler_radar_range;
                this.renderRange = 3.0f;
                this.liveRadar = true;
                this.showRating = true;
                this.showDirection = false;
                this.showWindSpeed = false;
                this.liveRadar = false;
                break;
            }
            default: {
                this.pingRate = 200;
                this.pingRange = ConfigMisc.radar_range;
                this.renderRange = 1.0f;
                this.liveRadar = false;
                this.showType = 0;
                this.showRating = false;
                this.showDirection = false;
                this.showWindSpeed = false;
                this.liveRadar = false;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void tickClient() {
        if (this.field_145850_b.func_82737_E() % (long)this.pingRate == 0L) {
            WeatherObject system;
            this.system = ConfigMisc.debug_mode_radar ? ((system = ClientTickHandler.weatherManager.getClosestWeather(new Maths.Vec3(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()), this.pingRange)) == null || system.isDead ? null : system) : null;
            if (ConfigMisc.debug_mode_radar) {
                this.systems.clear();
                for (FrontObject front : ClientTickHandler.weatherManager.getFronts()) {
                    if (!front.isGlobal()) {
                        if (!(Maths.distanceSq(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), front.pos.posX, this.func_174877_v().func_177956_o(), front.pos.posZ) <= this.pingRange)) continue;
                        this.systems.add(new GuiRadarObject(front));
                        front.getWeatherObjects().forEach(so -> {
                            if (Maths.distanceSq(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), so.pos.posX, this.func_174877_v().func_177956_o(), so.pos.posZ) <= this.pingRange) {
                                this.systems.add(new GuiRadarObject((IWeatherDetectable)so));
                            }
                        });
                        continue;
                    }
                    front.getWeatherObjects().forEach(so -> {
                        if (Maths.distanceSq(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), so.pos.posX, this.func_174877_v().func_177956_o(), so.pos.posZ) <= this.pingRange) {
                            this.systems.add(new GuiRadarObject((IWeatherDetectable)so));
                        }
                    });
                }
            } else {
                this.systems.clear();
                for (FrontObject front : ClientTickHandler.weatherManager.getFronts()) {
                    if (!front.isGlobal()) {
                        if (!(Maths.distanceSq(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), front.pos.posX, this.func_174877_v().func_177956_o(), front.pos.posZ) <= this.pingRange)) continue;
                        this.systems.add(new GuiRadarObject(front));
                        front.getWeatherObjects().forEach(so -> {
                            if (!so.type.equals((Object)WeatherEnum.Type.CLOUD) && Maths.distanceSq(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), so.pos.posX, this.func_174877_v().func_177956_o(), so.pos.posZ) <= this.pingRange) {
                                this.systems.add(new GuiRadarObject((IWeatherDetectable)so));
                            }
                        });
                        continue;
                    }
                    front.getWeatherObjects().forEach(so -> {
                        if (!so.type.equals((Object)WeatherEnum.Type.CLOUD) && Maths.distanceSq(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), so.pos.posX, this.func_174877_v().func_177956_o(), so.pos.posZ) <= this.pingRange) {
                            this.systems.add(new GuiRadarObject((IWeatherDetectable)so));
                        }
                    });
                }
            }
            this.pingLength = this.pingMaxLength;
            this.renderAlpha = 1.0f;
        }
        if (this.pingLength == 0 && this.renderAlpha > 0.1f) {
            this.renderAlpha -= this.fadeRate;
        }
        if (this.pingLength > 0) {
            --this.pingLength;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public double getPingRange(int tier) {
        return tier == 1 ? ConfigMisc.doppler_radar_range : (tier == 2 ? ConfigMisc.pulse_doppler_radar_range : ConfigMisc.radar_range);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74768_a("tier", this.tier);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("tier")) {
            this.tier = tag.func_74762_e("tier");
            this.fadeRate = this.tier == 0 ? 0.0035f : (this.tier == 1 ? 0.001f : 5.0E-4f);
        }
        this.refresh();
    }
}

