/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.mrbt0907.weather2.api.weather.WeatherEnum;
import net.mrbt0907.weather2.config.ConfigMisc;
import net.mrbt0907.weather2.server.event.ServerTickHandler;
import net.mrbt0907.weather2.server.weather.WeatherManagerServer;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.weather.storm.WeatherObject;

public class BlockSensor
extends Block {
    public static final PropertyInteger POWER = PropertyInteger.func_177719_a((String)"power", (int)0, (int)15);

    public BlockSensor() {
        super(Material.field_151571_B);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.func_149711_c(0.6f);
        this.func_149752_b(10.0f);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        WeatherManagerServer wms = ServerTickHandler.dimensionSystems.get(world.field_73011_w.getDimension());
        if (wms != null) {
            WeatherObject wo = wms.getWorstWeather(new Maths.Vec3(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), ConfigMisc.sensor_scan_range, WeatherEnum.Stage.TORNADO.getStage(), Integer.MAX_VALUE, new WeatherEnum.Type[0]);
            if (wo != null) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(15)), 3);
            } else {
                world.func_180501_a(pos, state.func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(0)), 3);
            }
        }
        world.func_180497_b(pos, (Block)this, 100, 1);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        worldIn.func_180497_b(pos, (Block)this, 10, 1);
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Integer)blockState.func_177229_b((IProperty)POWER);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)POWER);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWER});
    }
}

