/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.registry.ItemRegistry;

public class BlockSandLayer
extends Block {
    public static final PropertyInteger LAYERS = PropertyInteger.func_177719_a((String)"layers", (int)1, (int)8);
    protected static final AxisAlignedBB[] SAND_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};

    public BlockSandLayer() {
        super(Material.field_151595_p);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LAYERS, (Comparable)Integer.valueOf(8)));
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149672_a(SoundType.field_185855_h);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAND_AABB[(Integer)state.func_177229_b((IProperty)LAYERS)];
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)LAYERS) < 5;
    }

    public boolean func_185481_k(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LAYERS) == 8;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        int i = (Integer)blockState.func_177229_b((IProperty)LAYERS);
        AxisAlignedBB axisalignedbb = blockState.func_185900_c(worldIn, pos);
        return new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72336_d, (double)((float)i * 0.125f), axisalignedbb.field_72334_f);
    }

    public boolean func_149662_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LAYERS) >= 8;
    }

    public boolean func_149686_d(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LAYERS) >= 8;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177977_b());
        Block block = iblockstate.func_177230_c();
        return iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, pos.func_177977_b()) ? true : (block == this && (Integer)iblockstate.func_177229_b((IProperty)LAYERS) >= 7 ? true : iblockstate.func_185914_p() && iblockstate.func_185904_a().func_76230_c());
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    private boolean checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.func_176196_c(worldIn, pos)) {
            worldIn.func_175698_g(pos);
            return false;
        }
        return true;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return (Integer)state.func_177229_b((IProperty)LAYERS) >= 8 ? Blocks.field_150354_m.func_180660_a(state, rand, fortune) : ItemRegistry.itemSandLayer;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.UP) {
            return true;
        }
        IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
        return iblockstate.func_177230_c() == this && (Integer)iblockstate.func_177229_b((IProperty)LAYERS) >= (Integer)blockState.func_177229_b((IProperty)LAYERS) ? true : super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LAYERS, (Comparable)Integer.valueOf((meta & 7) + 1));
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        IBlockState state = Weather2.getChunkUtil((World)worldIn).getBlockState((World)worldIn, pos);
        try {
            return state.func_177227_a().contains(LAYERS) ? (Integer)state.func_177229_b((IProperty)LAYERS) == 1 : false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LAYERS) - 1;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return (Integer)state.func_177229_b((IProperty)LAYERS) >= 8 ? Blocks.field_150354_m.quantityDropped(state, fortune, random) : ((Integer)state.func_177229_b((IProperty)LAYERS)).intValue();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LAYERS});
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }
}

