/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.api.weather.WeatherEnum;
import net.mrbt0907.weather2.block.BlockMachine;
import net.mrbt0907.weather2.config.ConfigMisc;
import net.mrbt0907.weather2.server.event.ServerTickHandler;
import net.mrbt0907.weather2.server.weather.WeatherManagerServer;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.util.WeatherUtil;
import net.mrbt0907.weather2.weather.storm.SandstormObject;
import net.mrbt0907.weather2.weather.storm.StormObject;
import net.mrbt0907.weather2.weather.storm.WeatherObject;

public class BlockNewSensor
extends BlockMachine {
    public static final PropertyInteger POWER = PropertyInteger.func_177719_a((String)"power", (int)0, (int)15);
    private int scanType;

    public BlockNewSensor(Material material, int scanType) {
        super(material);
        this.func_149647_a(Weather2.TAB);
        this.scanType = scanType;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        int power = 0;
        WeatherManagerServer manager = ServerTickHandler.dimensionSystems.get(world.field_73011_w.getDimension());
        if (manager != null) {
            WeatherObject so = manager.getWorstWeather(new Maths.Vec3(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), ConfigMisc.sensor_scan_range, WeatherEnum.Stage.RAIN.getStage(), Integer.MAX_VALUE, new WeatherEnum.Type[0]);
            block0 : switch (this.scanType) {
                case 0: {
                    if (so == null) break;
                    if (so instanceof StormObject) {
                        power = Maths.clamp(((StormObject)so).stage, 0, 15);
                        break;
                    }
                    if (!(so instanceof SandstormObject)) break;
                    power = 5;
                    break;
                }
                case 1: {
                    power = (int)(WeatherUtil.getHumidity(world, pos) * 15.0f);
                    break;
                }
                case 2: {
                    List<WeatherObject> wos = manager.getWeatherObjects();
                    power = 0;
                    for (WeatherObject wo : wos) {
                        if (!(wo instanceof StormObject) || !((StormObject)wo).hasDownfall()) continue;
                        Maths.Vec3 vec3 = new Maths.Vec3(pos);
                        if (!(wo.pos.distanceSq(vec3) < (double)wo.size)) continue;
                        power = 15;
                        break block0;
                    }
                    break;
                }
                case 3: {
                    power = (int)Maths.clamp(WeatherUtil.getTemperature(world, pos) * 15.0f * 0.7f, 0.0f, 15.0f);
                    break;
                }
                case 4: {
                    power = (int)Math.min((manager.windManager.windSpeed > manager.windManager.windSpeedGust ? manager.windManager.windSpeed : manager.windManager.windSpeedGust) * 0.072f * 15.0f, 15.0f);
                    break;
                }
                case 5: {
                    power = (int)Maths.clamp((WeatherUtil.getPressure(world, pos) - 900.0f) * 0.12f, 0.0f, 15.0f);
                }
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(Maths.clamp(power, 0, 15))), 3);
        }
        world.func_180497_b(pos, (Block)this, 100, 1);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        worldIn.func_180497_b(pos, (Block)this, 10, 1);
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Integer)blockState.func_177229_b((IProperty)POWER);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)POWER);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWER});
    }
}

