/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.api.weather;

import net.minecraftforge.common.util.EnumHelper;
import net.mrbt0907.weather2.util.StringUtils;

public class WeatherEnum {

    public static enum Stage {
        NORMAL(0),
        RAIN(1),
        THUNDER(2),
        SEVERE(3),
        TROPICAL_DISTURBANCE(2),
        TROPICAL_DEPRESSION(3),
        TROPICAL_STORM(4),
        TORNADO(4),
        HURRICANE(5);

        private int stage;

        private Stage(int stage) {
            this.stage = stage;
        }

        public static Stage add(Stage stageEnum, int stage) {
            EnumHelper.addEnum(Stage.class, (String)stageEnum.name(), (Class[])new Class[]{Integer.class}, (Object[])new Object[]{stage});
            return stageEnum;
        }

        public static Stage get(int id) {
            return Stage.values()[id];
        }

        public static int size() {
            return Stage.values().length;
        }

        public int getStage() {
            return this.stage;
        }

        public String toString() {
            return StringUtils.toUpperCaseAlt(super.toString().replaceAll("\\_", " ").toLowerCase());
        }
    }

    public static enum Type {
        CLOUD,
        RAIN,
        THUNDER,
        SUPERCELL,
        TORNADO(true),
        TROPICAL_DISTURBANCE,
        TROPICAL_DEPRESSION,
        TROPICAL_STORM(true),
        HURRICANE(true),
        SANDSTORM(true),
        BLIZZARD(true);

        private boolean isDangerous;

        private Type() {
            this(false);
        }

        private Type(boolean isDangerous) {
            this.isDangerous = isDangerous;
        }

        public static Type add(Type typeEnum, boolean isDangerous) {
            EnumHelper.addEnum(Type.class, (String)typeEnum.name(), (Class[])new Class[]{Boolean.class}, (Object[])new Object[]{isDangerous});
            return typeEnum;
        }

        public static Type get(int id) {
            return Type.values()[id];
        }

        public static int size() {
            return Type.values().length;
        }

        public boolean isDangerous() {
            return this.isDangerous;
        }

        public String toString() {
            return StringUtils.toUpperCaseAlt(super.toString().replaceAll("\\_", " ").toLowerCase());
        }
    }
}

