/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.api.weather;

import CoroUtil.config.ConfigCoroUtil;
import extendedrenderer.ExtendedRenderer;
import extendedrenderer.particle.behavior.ParticleBehaviorFog;
import extendedrenderer.particle.entity.EntityRotFX;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.api.WeatherAPI;
import net.mrbt0907.weather2.api.weather.AbstractDebugging;
import net.mrbt0907.weather2.api.weather.WeatherEnum;
import net.mrbt0907.weather2.client.entity.particle.ExtendedEntityRotFX;
import net.mrbt0907.weather2.client.event.ClientTickHandler;
import net.mrbt0907.weather2.client.weather.WeatherManagerClient;
import net.mrbt0907.weather2.config.ConfigParticle;
import net.mrbt0907.weather2.registry.ParticleRegistry;
import net.mrbt0907.weather2.weather.storm.StormObject;

@SideOnly(value=Side.CLIENT)
public abstract class AbstractStormRenderer
extends AbstractDebugging {
    protected ParticleBehaviorFog particleBehaviorFog;
    public StormObject storm;
    public int particlesLeft;
    private final List<Particle> particles = new ArrayList<Particle>();
    private int particleLimit = 1;
    private static long delta;
    private static long worldDelta;
    public static final List<String> renderDebugInfo;

    public AbstractStormRenderer(StormObject storm) {
        this.refreshParticleLimit();
        this.storm = storm;
    }

    public final void tick() {
        int attempts = 0;
        if (this.particleBehaviorFog == null) {
            this.particleBehaviorFog = new ParticleBehaviorFog(this.storm.pos.toVec3Coro());
        } else if (!Minecraft.func_71410_x().func_71356_B() || !(Minecraft.func_71410_x().field_71462_r instanceof GuiIngameMenu)) {
            this.particleBehaviorFog.tickUpdateList();
        }
        Iterator<Particle> particles = this.particles.iterator();
        while (particles.hasNext()) {
            Particle particle = particles.next();
            if (particle.func_187113_k()) continue;
            particles.remove();
        }
        particles = null;
        this.particlesLeft = this.particleLimit - this.particles.size();
        if (this.storm != null) {
            delta = System.nanoTime();
            while (attempts > -1) {
                try {
                    this.onTick(ClientTickHandler.weatherManager);
                    attempts = -1;
                }
                catch (Exception e) {
                    if (++attempts < 3) {
                        Weather2.warn("Particle renderer's onTick() has encountered an error. Retrying...");
                        e.printStackTrace();
                        continue;
                    }
                    Weather2.warn("Particle renderer's onTick() has failed to run correctly. Disabling particle renderer...");
                    e.printStackTrace();
                    ConfigParticle.particle_renderer = "-1";
                    WeatherAPI.refreshRenders(false);
                    attempts = -1;
                }
            }
            delta = (long)((float)(System.nanoTime() - delta) * 0.001f);
            if (worldDelta != ClientTickHandler.weatherManager.getWorld().func_82737_E()) {
                worldDelta = ClientTickHandler.weatherManager.getWorld().func_82737_E();
                renderDebugInfo.clear();
                renderDebugInfo.add("Renderer: " + String.valueOf(WeatherAPI.getParticleRendererId()));
                renderDebugInfo.add("Delta: " + delta + "si");
                if (ConfigParticle.max_particles > 0) {
                    renderDebugInfo.add("Particle Count: " + this.particles.size() + "/" + this.particleLimit);
                    renderDebugInfo.add("Global Particle Count: " + ClientTickHandler.weatherManager.getParticleCount() + "/" + ConfigParticle.max_particles);
                } else {
                    renderDebugInfo.add("Particle Count: " + this.particles.size());
                    renderDebugInfo.add("Global Particle Count: " + ClientTickHandler.weatherManager.getParticleCount());
                }
                List<String> extraDebugInfo = null;
                attempts = 0;
                while (attempts > -1) {
                    try {
                        extraDebugInfo = this.onDebugInfo();
                        attempts = -1;
                    }
                    catch (Exception e) {
                        if (++attempts < 3) {
                            Weather2.warn("Particle renderer's onDebugInfo() has encountered an error. Retrying...");
                            e.printStackTrace();
                            continue;
                        }
                        Weather2.warn("Particle renderer's onTick() has failed to run correctly. Disabling particle renderer...");
                        e.printStackTrace();
                        ConfigParticle.particle_renderer = "-1";
                        WeatherAPI.refreshRenders(false);
                        attempts = -1;
                    }
                }
                if (extraDebugInfo != null) {
                    renderDebugInfo.add("-------   --------");
                    renderDebugInfo.addAll(extraDebugInfo);
                }
            }
        }
    }

    public abstract void onTick(WeatherManagerClient var1);

    public abstract void onParticleLimitRefresh(WeatherManagerClient var1, int var2);

    public abstract List<String> onDebugInfo();

    public abstract void cleanupRenderer();

    public final void cleanup() {
        this.particles.clear();
        this.cleanupRenderer();
        if (this.particleBehaviorFog != null) {
            if (this.particleBehaviorFog.particles != null) {
                this.particleBehaviorFog.particles.clear();
            }
            this.particleBehaviorFog = null;
        }
    }

    public final ExtendedEntityRotFX spawnParticle(double x, double y, double z, int parRenderOrder) {
        return this.spawnParticle(x, y, z, parRenderOrder, ConfigCoroUtil.optimizedCloudRendering ? ParticleRegistry.cloud32 : ParticleRegistry.cloud256);
    }

    public final ExtendedEntityRotFX spawnParticle(double x, double y, double z, int parRenderOrder, TextureAtlasSprite tex) {
        if (!this.canSpawnParticle()) {
            return null;
        }
        double speed = 0.0;
        Random rand = new Random();
        ExtendedEntityRotFX entityfx = new ExtendedEntityRotFX(ClientTickHandler.weatherManager.getWorld(), x, y, z, (rand.nextDouble() - rand.nextDouble()) * speed, 0.0, (rand.nextDouble() - rand.nextDouble()) * speed, tex);
        entityfx.pb = this.particleBehaviorFog;
        entityfx.renderOrder = 0;
        this.particleBehaviorFog.initParticle((EntityRotFX)entityfx);
        entityfx.setCanCollide(false);
        entityfx.callUpdatePB = false;
        if (this.storm.stage == WeatherEnum.Stage.NORMAL.getStage()) {
            entityfx.func_187114_a(300 + rand.nextInt(100));
        } else {
            entityfx.func_187114_a(this.storm.size / 2 + rand.nextInt(100));
        }
        if (entityfx.getEntityId() % 20 < 5 && this.storm.isSevere()) {
            entityfx.renderOrder = 1;
            entityfx.func_187114_a(this.storm.size + rand.nextInt(100));
        }
        if (ConfigCoroUtil.optimizedCloudRendering) {
            entityfx.func_187114_a(400);
        }
        entityfx.field_70544_f = (float)((double)entityfx.field_70544_f * ConfigParticle.particle_scale_mult);
        ExtendedRenderer.rotEffRenderer.addEffect((Particle)entityfx);
        this.particleBehaviorFog.particles.add(entityfx);
        this.particles.add((Particle)entityfx);
        if (ClientTickHandler.weatherManager != null) {
            ClientTickHandler.weatherManager.addWeatherParticle((Particle)entityfx);
        }
        --this.particlesLeft;
        return entityfx;
    }

    public final void refreshParticleLimit() {
        this.particleLimit = ClientTickHandler.weatherManager.getParticleLimit();
        int attempts = 0;
        while (attempts > -1) {
            try {
                this.onParticleLimitRefresh(ClientTickHandler.weatherManager, this.particleLimit);
                attempts = -1;
            }
            catch (Exception e) {
                if (++attempts < 3) {
                    Weather2.warn("Particle renderer's onParticleLimitRefresh() has encountered an error. Retrying...");
                    e.printStackTrace();
                    continue;
                }
                Weather2.warn("Particle renderer's onParticleLimitRefresh() has failed to run correctly. Disabling particle renderer...");
                e.printStackTrace();
                ConfigParticle.particle_renderer = "-1";
                WeatherAPI.refreshRenders(false);
                attempts = -1;
            }
        }
    }

    public final boolean canSpawnParticle() {
        return this.particles.size() < this.particleLimit;
    }

    static {
        renderDebugInfo = new ArrayList<String>();
    }
}

