/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.api.weather;

import java.util.List;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.api.weather.AbstractDebugging;
import net.mrbt0907.weather2.weather.storm.StormObject;

public abstract class AbstractStormLogic
extends AbstractDebugging {
    public StormObject storm;
    private static long delta;

    public AbstractStormLogic(StormObject storm) {
        this.storm = storm;
    }

    public final void tick() {
        int attempts = 0;
        if (this.storm != null) {
            delta = System.nanoTime();
            while (attempts > -1) {
                try {
                    this.onTickProgression();
                    attempts = -1;
                }
                catch (Exception e) {
                    if (++attempts < 3) {
                        Weather2.warn("Storm's logic onTickProgression() has encountered an error. Retrying...");
                        e.printStackTrace();
                        continue;
                    }
                    Weather2.warn("Storm's logic onTickProgression() has failed to run correctly. Disabling storm logic...");
                    e.printStackTrace();
                    attempts = -1;
                }
            }
        }
    }

    public abstract void onTickProgression();

    public abstract List<String> onDebugInfo();

    public abstract void cleanupLogic();

    public final void cleanup() {
    }
}

