/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.api;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.mrbt0907.weather2.api.WeatherAPI;
import net.mrbt0907.weather2.config.ConfigWind;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.util.WeatherUtilEntity;
import net.mrbt0907.weather2.weather.WeatherManager;

public class WindReader {
    public static float getWindSpeed(World world, Maths.Vec3 pos) {
        WeatherManager manager = WeatherAPI.getManager(world);
        if (manager != null) {
            return manager.windManager.getWindSpeed(pos);
        }
        return 0.0f;
    }

    public static float getWindAngle(World world, Maths.Vec3 pos) {
        WeatherManager manager = WeatherAPI.getManager(world);
        if (manager != null) {
            return manager.windManager.getWindAngle(pos);
        }
        return 0.0f;
    }

    public static Maths.Vec3 getWindVectors(World world, Entity entity, float maxSpeed) {
        return WindReader.getWindVectors(world, new Maths.Vec3(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v), new Maths.Vec3(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y), (float)((double)(WeatherUtilEntity.getWeight(entity) * 0.1f) * (entity instanceof EntityPlayer ? ConfigWind.windPlayerWeightMult : (entity instanceof EntityLivingBase ? ConfigWind.windEntityWeightMult : 1.0)) * (entity.func_70090_H() ? ConfigWind.windSwimmingWeightMult : 1.0)), 5.0f);
    }

    public static Maths.Vec3 getWindVectors(World world, Maths.Vec3 pos, Maths.Vec3 motion, float weight, float maxSpeed) {
        WeatherManager manager = WeatherAPI.getManager(world);
        if (manager != null) {
            return manager.windManager.getWindVectors(pos, motion, weight, 0.05f, maxSpeed);
        }
        return motion;
    }
}

