/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2.api;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.mrbt0907.weather2.Weather2;
import net.mrbt0907.weather2.api.event.EventRegisterGrabLists;
import net.mrbt0907.weather2.api.event.EventRegisterParticleRenderer;
import net.mrbt0907.weather2.api.event.EventRegisterStages;
import net.mrbt0907.weather2.api.weather.AbstractWeatherRenderer;
import net.mrbt0907.weather2.api.weather.WeatherEnum;
import net.mrbt0907.weather2.client.event.ClientTickHandler;
import net.mrbt0907.weather2.client.rendering.NormalStormRenderer;
import net.mrbt0907.weather2.config.ConfigGrab;
import net.mrbt0907.weather2.config.ConfigParticle;
import net.mrbt0907.weather2.config.ConfigStorm;
import net.mrbt0907.weather2.config.EZConfigParser;
import net.mrbt0907.weather2.server.event.ServerTickHandler;
import net.mrbt0907.weather2.util.ConfigList;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.weather.WeatherManager;
import net.mrbt0907.weather2.weather.storm.StormObject;
import net.mrbt0907.weather2.weather.storm.WeatherObject;

public class WeatherAPI {
    private static final ConfigList tornadoStageList = new ConfigList();
    private static final ConfigList hurricaneStageList = new ConfigList();
    private static final ConfigList grabList = new ConfigList();
    private static final ConfigList replaceList = new ConfigList();
    private static final ConfigList entityList = new ConfigList();
    private static final ConfigList windResistanceList = new ConfigList().setReplaceOnly();
    private static Map<ResourceLocation, Class<?>> particleRenderers = new LinkedHashMap();
    private static ResourceLocation currentParticleRenderer;

    public static WeatherManager getManager(World world) {
        WeatherManager manager = null;
        if (world != null) {
            manager = world.field_72995_K ? WeatherAPI.getManager() : (WeatherManager)ServerTickHandler.dimensionSystems.get(world.field_73011_w.getDimension());
        }
        return manager;
    }

    @SideOnly(value=Side.CLIENT)
    public static WeatherManager getManager() {
        return ClientTickHandler.weatherManager;
    }

    public static WeatherManager getManager(int dimension) {
        return ServerTickHandler.dimensionSystems.get(dimension);
    }

    @SideOnly(value=Side.CLIENT)
    public static WeatherObject getClosestWeather(Maths.Vec3 pos, double maxDist, int minStage, int maxStage, WeatherEnum.Type ... excludedTypes) {
        return ClientTickHandler.weatherManager != null ? ClientTickHandler.weatherManager.getClosestWeather(pos, maxDist, minStage, maxStage, excludedTypes) : null;
    }

    public static WeatherObject getClosestWeather(int dimension, Maths.Vec3 pos, double maxDist, int minStage, int maxStage, WeatherEnum.Type ... excludedTypes) {
        WeatherManager manager = WeatherAPI.getManager(dimension);
        return manager != null ? manager.getClosestWeather(pos, maxDist, minStage, maxStage, excludedTypes) : null;
    }

    public static boolean isPrecipitatingAt(World world, BlockPos position) {
        WeatherManager manager = WeatherAPI.getManager(world);
        return manager == null ? false : manager.hasDownfall(position);
    }

    public static ConfigList getTornadoStageList() {
        return tornadoStageList;
    }

    public static ConfigList getHurricaneStageList() {
        return hurricaneStageList;
    }

    public static ConfigList getWRList() {
        return windResistanceList;
    }

    public static ConfigList getGrabList() {
        return grabList;
    }

    public static ConfigList getReplaceList() {
        return replaceList;
    }

    public static ConfigList getEntityGrabList() {
        return entityList;
    }

    public static float getEFWindSpeed(int stage) {
        return 65.0f + 27.0f * (float)stage;
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation getParticleRendererId() {
        return currentParticleRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public static AbstractWeatherRenderer getParticleRenderer(StormObject storm) {
        if (currentParticleRenderer == null || storm == null) {
            return null;
        }
        Class<?> renderer = particleRenderers.get(currentParticleRenderer);
        try {
            return renderer == null ? null : (AbstractWeatherRenderer)renderer.getConstructor(StormObject.class).newInstance(storm);
        }
        catch (Exception e) {
            Weather2.error(e);
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void refreshRenders(boolean fullRefresh) {
        currentParticleRenderer = null;
        if (fullRefresh) {
            Weather2.debug("Refreshing all renderers...");
            particleRenderers.clear();
            Weather2.debug("Registering particle renderers...");
            particleRenderers.put(new ResourceLocation("weather2remaster", "normal"), NormalStormRenderer.class);
            Weather2.debug("Registered particle renderer weather2remaster:normal");
            EventRegisterParticleRenderer event = new EventRegisterParticleRenderer();
            MinecraftForge.EVENT_BUS.post((Event)event);
            particleRenderers.putAll(event.getRegistry());
            Weather2.debug("All weather renderers have been updated: " + particleRenderers.size() + " total");
        }
        if (ConfigParticle.particle_renderer.matches("^\\d$")) {
            try {
                int i = 0;
                int ii = Integer.parseInt(ConfigParticle.particle_renderer);
                for (ResourceLocation id : particleRenderers.keySet()) {
                    if (i == ii) {
                        currentParticleRenderer = id;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                Weather2.error(e);
                ConfigParticle.particle_renderer = "weather2remaster:normal";
                currentParticleRenderer = new ResourceLocation("weather2remaster", "normal");
            }
        } else {
            for (ResourceLocation id : particleRenderers.keySet()) {
                if (!id.toString().equals(ConfigParticle.particle_renderer)) continue;
                currentParticleRenderer = id;
            }
        }
        Weather2.debug("Set particle renderer to " + (currentParticleRenderer == null ? "none" : currentParticleRenderer.toString()));
    }

    public static void refreshDimensionRules() {
        EZConfigParser.refreshDimensionRules();
    }

    public static void refreshStages() {
        EventRegisterStages event = new EventRegisterStages(tornadoStageList, hurricaneStageList);
        event.tornadoStageList.clear();
        event.hurricaneStageList.clear();
        MinecraftForge.EVENT_BUS.post((Event)event);
        String stagesA = ConfigStorm.chances_for_tornados.replaceAll("[^\\d\\.\\s\\,\\=]*", "");
        String stagesB = ConfigStorm.chances_for_hurricanes.replaceAll("[^\\d\\.\\s\\,\\=]*", "");
        event.tornadoStageList.parse(stagesA);
        event.hurricaneStageList.parse(stagesB);
        Weather2.debug("Cyclonic stages have been updated:\n- Tornado Stage List = " + tornadoStageList.size() + "\nHurricane Stage List = " + hurricaneStageList.size());
    }

    public static void refreshGrabRules() {
        EventRegisterGrabLists event = new EventRegisterGrabLists(grabList, replaceList, entityList, windResistanceList);
        event.grabList.clear();
        event.replaceList.clear();
        event.windResistanceList.clear();
        event.entityList.clear();
        MinecraftForge.EVENT_BUS.post((Event)event);
        event.grabList.parse(ConfigGrab.grab_list_entries);
        event.replaceList.parse(ConfigGrab.replace_list_entries);
        event.windResistanceList.parse(ConfigGrab.wind_resistance_entries);
        event.entityList.parse(ConfigGrab.entity_blacklist_entries);
        Set blockEntries = Block.field_149771_c.func_148742_b();
        Set entityEntries = ForgeRegistries.ENTITIES.getKeys();
        ConfigList list = WeatherAPI.processGrabList(blockEntries, event.grabList, ConfigGrab.grab_list_partial_matches, 0);
        grabList.clear();
        grabList.addAll(list);
        list = WeatherAPI.processGrabList(blockEntries, event.replaceList, ConfigGrab.replace_list_partial_matches, 1);
        replaceList.clear();
        replaceList.addAll(list);
        list = WeatherAPI.processGrabList(blockEntries, event.windResistanceList, ConfigGrab.wind_resistance_partial_matches, 2);
        windResistanceList.clear();
        windResistanceList.addAll(list);
        list = WeatherAPI.processGrabList(entityEntries, event.entityList, ConfigGrab.entity_blacklist_partial_matches, 0);
        entityList.clear();
        entityList.addAll(list);
        Weather2.debug("Grab Rules have been updated:\n- Grab List = " + WeatherAPI.getGrabList().size() + " Entry(s)\n- Replace List = " + WeatherAPI.getReplaceList().size() + " Entry(s)\n- Wind Resistance List = " + WeatherAPI.getWRList().size() + " Entry(s)\n- Blacklisted Entity List = " + WeatherAPI.getEntityGrabList().size() + " Entry(s)");
    }

    private static ConfigList processGrabList(Set<ResourceLocation> entries, ConfigList cfg, boolean partialMatches, int type) {
        ConfigList list = new ConfigList();
        boolean usePartialMatch = false;
        if (cfg.isReplaceOnly()) {
            list.setReplaceOnly();
        }
        for (Map.Entry<String, Object[]> entry : cfg.toMap().entrySet()) {
            String keyC;
            String keyB;
            if (type > 0 && entry.getValue().length == 0) continue;
            String keyA = entry.getKey();
            if (keyA.contains(":")) {
                keyB = keyA;
            } else {
                keyB = "minecraft:" + keyA;
                usePartialMatch = partialMatches;
            }
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<Object> values = new ArrayList<Object>();
            for (ResourceLocation block : entries) {
                keyC = block.toString();
                if (!keyC.equals(keyB) && (!usePartialMatch || !keyC.toLowerCase().contains(keyA.toLowerCase()))) continue;
                keys.add(keyC);
            }
            block8: for (Object str : entry.getValue()) {
                switch (type) {
                    case 1: {
                        if (!(str instanceof String)) continue block8;
                        usePartialMatch = false;
                        keyA = (String)str;
                        if (keyA.contains(":")) {
                            keyB = keyA;
                        } else {
                            keyB = "minecraft:" + keyA;
                            usePartialMatch = partialMatches;
                        }
                        for (ResourceLocation block : entries) {
                            keyC = block.toString();
                            if (!keyC.equals(keyB) && (!usePartialMatch || !keyC.toLowerCase().contains(keyA.toLowerCase()))) continue;
                            values.add(keyC);
                        }
                        continue block8;
                    }
                    case 2: {
                        if (str instanceof Float) {
                            values.add(str);
                            continue block8;
                        }
                        if (!(str instanceof String)) continue block8;
                        try {
                            float a = Float.parseFloat((String)str);
                            values.add(Float.valueOf(a));
                        }
                        catch (Exception exception) {}
                        continue block8;
                    }
                    default: {
                        values.add(str);
                    }
                }
            }
            if (type > 0 && values.size() == 0) continue;
            for (String key : keys) {
                list.add(key, values.toArray());
            }
        }
        return list;
    }
}

