/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2;

import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.mrbt0907.configex.ConfigModEX;
import net.mrbt0907.weather2.CommonProxy;
import net.mrbt0907.weather2.api.WeatherAPI;
import net.mrbt0907.weather2.config.ConfigFoliage;
import net.mrbt0907.weather2.config.ConfigFront;
import net.mrbt0907.weather2.config.ConfigGrab;
import net.mrbt0907.weather2.config.ConfigMisc;
import net.mrbt0907.weather2.config.ConfigParticle;
import net.mrbt0907.weather2.config.ConfigSand;
import net.mrbt0907.weather2.config.ConfigSeason;
import net.mrbt0907.weather2.config.ConfigSimulation;
import net.mrbt0907.weather2.config.ConfigSnow;
import net.mrbt0907.weather2.config.ConfigStorm;
import net.mrbt0907.weather2.config.ConfigVolume;
import net.mrbt0907.weather2.config.ConfigWind;
import net.mrbt0907.weather2.config.EZConfigParser;
import net.mrbt0907.weather2.event.EventHandlerFML;
import net.mrbt0907.weather2.event.EventHandlerForge;
import net.mrbt0907.weather2.event.EventHandlerPacket;
import net.mrbt0907.weather2.player.PlayerData;
import net.mrbt0907.weather2.registry.BlockRegistry;
import net.mrbt0907.weather2.server.command.CommandWeather2;
import net.mrbt0907.weather2.server.event.ServerTickHandler;
import net.mrbt0907.weather2.server.weather.WeatherManagerServer;
import net.mrbt0907.weather2.util.ChunkUtils;
import org.apache.logging.log4j.Logger;

@Mod(modid="weather2remaster", name="Weather 2 - Remastered", version="2.8.16", acceptedMinecraftVersions="[1.12.2]", dependencies="required-after:coroutil@[1.12.1-1.2.37,);required-after:configex@[1.0,);required-after:forge@[14.23.5.2860,);", guiFactory="net.mrbt0907.configex.gui.AdvancedGuiFactory")
public class Weather2 {
    public static final String MOD = "Weather 2 - Remastered";
    public static final String MODID = "weather2remaster";
    public static final String OLD_MODID = "weather2";
    public static final String VERSION = "2.8.16";
    public static final FMLEventChannel event_channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("weather2remaster");
    public static final CreativeTabs TAB = new CreativeTabs("weather2remaster"){

        public ItemStack func_78016_d() {
            return new ItemStack(BlockRegistry.tornado_sensor);
        }
    };
    @Mod.Instance(value="weather2remaster")
    public static Weather2 instance;
    public static Logger log;
    public static boolean initProperNeededForWorld;
    public static ChunkUtils clientChunkUtil;
    public static ChunkUtils serverChunkUtil;
    @SidedProxy(modId="weather2remaster", clientSide="net.mrbt0907.weather2.ClientProxy", serverSide="net.mrbt0907.weather2.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        log = event.getModLog();
        event_channel.register((Object)new EventHandlerPacket());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerFML());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerForge());
        ConfigModEX.register(new ConfigMisc());
        ConfigModEX.register(new ConfigVolume());
        ConfigModEX.register(new ConfigParticle());
        ConfigModEX.register(new ConfigFront());
        ConfigModEX.register(new ConfigStorm());
        ConfigModEX.register(new ConfigGrab());
        ConfigModEX.register(new ConfigSeason());
        ConfigModEX.register(new ConfigSimulation());
        ConfigModEX.register(new ConfigWind());
        ConfigModEX.register(new ConfigSand());
        ConfigModEX.register(new ConfigSnow());
        ConfigModEX.register(new ConfigFoliage());
        EZConfigParser.loadNBT();
        Weather2.info("Starting Weather2 - Remastered...");
        if (FMLCommonHandler.instance().getSide().equals((Object)Side.CLIENT)) {
            clientChunkUtil = new ChunkUtils();
        } else {
            serverChunkUtil = new ChunkUtils();
        }
        Weather2.debug("Running preInit...");
        proxy.preInit();
        Weather2.debug("Finished preInit");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Weather2.debug("Running init...");
        proxy.init();
        Weather2.debug("Finished init");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Weather2.debug("Running postInit...");
        proxy.postInit();
        EventHandlerFML.extraGrassLast = ConfigFoliage.enable_extra_grass;
        Weather2.debug("Finished postInit");
        Weather2.info("Weather2 - Remastered is online!");
    }

    @Mod.EventHandler
    public void postPostInit(FMLLoadCompleteEvent event) {
        proxy.postPostInit();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandWeather2());
        WeatherAPI.refreshDimensionRules();
        if (serverChunkUtil == null) {
            serverChunkUtil = new ChunkUtils();
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartedEvent event) {
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppedEvent event) {
        Weather2.writeOutData(true);
        ServerTickHandler.reset();
        initProperNeededForWorld = true;
        serverChunkUtil.clearCache();
        serverChunkUtil = null;
    }

    public static void writeOutData(boolean unloadInstances) {
        try {
            WeatherManagerServer wm = ServerTickHandler.dimensionSystems.get(0);
            if (wm != null) {
                wm.writeToFile();
            }
            PlayerData.writeAllPlayerNBT(unloadInstances);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static ChunkUtils getChunkUtil(World world) {
        return world.field_72995_K ? clientChunkUtil : serverChunkUtil;
    }

    public static void info(Object message) {
        log.info(message);
    }

    public static void debug(Object message) {
        boolean isDebug = ConfigMisc.debug_mode;
        if (isDebug) {
            log.info("[DEBUG] " + message);
        }
    }

    public static void warn(Object message) {
        boolean isDebug = ConfigMisc.debug_mode;
        if (isDebug) {
            log.warn(message);
        }
    }

    public static void error(Object message) {
        Throwable exception = message instanceof Throwable ? (Throwable)message : new Exception(String.valueOf(message));
        exception.printStackTrace();
    }

    public static void fatal(Object message) {
        Error error = message instanceof Error ? (Error)message : new Error(String.valueOf(message));
        throw error;
    }

    static {
        initProperNeededForWorld = true;
    }
}

