/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.weather2;

import extendedrenderer.ExtendedRenderer;
import extendedrenderer.shader.IShaderListener;
import extendedrenderer.shader.ShaderListenerRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.mrbt0907.configex.ConfigManager;
import net.mrbt0907.weather2.CommonProxy;
import net.mrbt0907.weather2.api.WeatherAPI;
import net.mrbt0907.weather2.block.TileAnemometer;
import net.mrbt0907.weather2.block.TileRadar;
import net.mrbt0907.weather2.block.TileSiren;
import net.mrbt0907.weather2.block.TileWeatherConstructor;
import net.mrbt0907.weather2.block.TileWeatherDeflector;
import net.mrbt0907.weather2.block.TileWindVane;
import net.mrbt0907.weather2.client.block.RenderAnemometer;
import net.mrbt0907.weather2.client.block.RenderRadar;
import net.mrbt0907.weather2.client.block.RenderSiren;
import net.mrbt0907.weather2.client.block.RenderWeatherConstructor;
import net.mrbt0907.weather2.client.block.RenderWeatherDeflector;
import net.mrbt0907.weather2.client.block.RenderWindVane;
import net.mrbt0907.weather2.client.entity.RenderFlyingBlock;
import net.mrbt0907.weather2.client.entity.RenderLightningBolt;
import net.mrbt0907.weather2.client.entity.RenderLightningBoltCustom;
import net.mrbt0907.weather2.client.event.ClientTickHandler;
import net.mrbt0907.weather2.client.foliage.FoliageEnhancerShader;
import net.mrbt0907.weather2.client.gui.GuiWeather;
import net.mrbt0907.weather2.client.rendering.ParticleManagerEX;
import net.mrbt0907.weather2.config.ConfigParticle;
import net.mrbt0907.weather2.entity.EntityIceBall;
import net.mrbt0907.weather2.entity.EntityLightningBolt;
import net.mrbt0907.weather2.entity.EntityLightningBoltCustom;
import net.mrbt0907.weather2.entity.EntityMovingBlock;
import net.mrbt0907.weather2.util.WeatherUtil;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="weather2remaster")
public class ClientProxy
extends CommonProxy {
    public static GuiWeather guiWeather;
    public static ClientTickHandler clientTickHandler;

    public ClientProxy() {
        clientTickHandler = new ClientTickHandler();
    }

    @Override
    public void init() {
        super.init();
        ClientProxy.addMapping(EntityIceBall.class, new RenderFlyingBlock(Minecraft.func_71410_x().func_175598_ae(), Blocks.field_150432_aD));
        ClientProxy.addMapping(EntityMovingBlock.class, new RenderFlyingBlock(Minecraft.func_71410_x().func_175598_ae(), null));
        ClientProxy.addMapping(EntityLightningBolt.class, new RenderLightningBolt(Minecraft.func_71410_x().func_175598_ae()));
        ClientProxy.addMapping(EntityLightningBoltCustom.class, new RenderLightningBoltCustom(Minecraft.func_71410_x().func_175598_ae()));
        ClientRegistry.bindTileEntitySpecialRenderer(TileSiren.class, (TileEntitySpecialRenderer)new RenderSiren());
        ClientRegistry.bindTileEntitySpecialRenderer(TileWindVane.class, (TileEntitySpecialRenderer)new RenderWindVane());
        ClientRegistry.bindTileEntitySpecialRenderer(TileRadar.class, (TileEntitySpecialRenderer)new RenderRadar());
        ClientRegistry.bindTileEntitySpecialRenderer(TileWeatherConstructor.class, (TileEntitySpecialRenderer)new RenderWeatherConstructor());
        ClientRegistry.bindTileEntitySpecialRenderer(TileWeatherDeflector.class, (TileEntitySpecialRenderer)new RenderWeatherDeflector());
        ClientRegistry.bindTileEntitySpecialRenderer(TileAnemometer.class, (TileEntitySpecialRenderer)new RenderAnemometer());
    }

    private static void addMapping(Class<? extends Entity> entityClass, Render render) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, (Render)render);
    }

    @Override
    public void preInit() {
        super.preInit();
        ShaderListenerRegistry.addListener((IShaderListener)new IShaderListener(){

            public void init() {
                FoliageEnhancerShader.shadersInit();
            }

            public void reset() {
                FoliageEnhancerShader.shadersReset();
            }
        });
    }

    @Override
    public void postInit() {
        super.postInit();
        guiWeather = new GuiWeather();
        WeatherAPI.refreshRenders(true);
        MinecraftForge.EVENT_BUS.register((Object)guiWeather);
        if (WeatherUtil.isAprilFoolsDay()) {
            ConfigParticle.particle_renderer = "2";
            ConfigManager.save("Weather2 Remastered - Client");
        }
    }

    @Override
    public void postPostInit() {
        super.postPostInit();
        ExtendedRenderer.rotEffRenderer = new ParticleManagerEX((World)Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x().field_71446_o);
    }
}

