/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.configex.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.mrbt0907.configex.network.NetworkHandler;

public class PacketNBT
implements IMessage,
IMessageHandler<PacketNBT, IMessage> {
    private int index;
    private NBTTagCompound nbt;

    public PacketNBT() {
    }

    public PacketNBT(int index, NBTTagCompound nbt) {
        this.index = index;
        this.nbt = nbt;
    }

    public void fromBytes(ByteBuf buffer) {
        this.index = buffer.readInt();
        this.nbt = ByteBufUtils.readTag((ByteBuf)buffer);
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.index);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.nbt);
    }

    public PacketNBT onMessage(PacketNBT message, MessageContext ctx) {
        if (ctx.side.isClient()) {
            return this.onClientMessage(message, ctx);
        }
        return this.onServerMessage(message, ctx);
    }

    @SideOnly(value=Side.CLIENT)
    protected PacketNBT onClientMessage(PacketNBT message, MessageContext ctx) {
        NetworkHandler.onClientMessage(message.index, message.nbt);
        return null;
    }

    protected PacketNBT onServerMessage(PacketNBT message, MessageContext ctx) {
        NetworkHandler.onServerMessage(message.index, message.nbt, ctx.getServerHandler().field_147369_b);
        return null;
    }
}

