/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.configex.manager;

import java.lang.reflect.Field;
import net.minecraftforge.common.config.Property;
import net.mrbt0907.configex.ConfigManager;
import net.mrbt0907.configex.ConfigModEX;
import net.mrbt0907.configex.api.ConfigAnnotations;
import net.mrbt0907.configex.api.IConfigEX;
import net.mrbt0907.weather2.util.Maths;
import org.apache.commons.lang3.text.WordUtils;

public class FieldInstance {
    protected final Field field;
    public final IConfigEX config;
    public final String name;
    public final String registryName;
    public final String displayName;
    public final String comment;
    public final boolean enforce;
    public final boolean hide;
    public final int permission;
    public final byte type;
    public final double min;
    public final double max;
    public final boolean showMin;
    public final boolean showMax;
    public final Object defaultValue;
    private Object cachedValue;
    private Object clientValue;
    private Object serverValue;
    private Property property;
    public boolean hasChanged;

    public FieldInstance(IConfigEX instance, Field field) {
        this.config = instance;
        this.field = field;
        this.name = field.getName();
        this.registryName = ConfigManager.formatRegistryName(instance.getName() + ":" + this.name);
        ConfigAnnotations.Name nameAnnotation = field.getAnnotation(ConfigAnnotations.Name.class);
        this.displayName = nameAnnotation == null || nameAnnotation.value().trim().isEmpty() ? WordUtils.capitalize((String)this.name.replace('_', ' ')) : nameAnnotation.value().trim();
        ConfigAnnotations.Comment commentAnnotation = field.getAnnotation(ConfigAnnotations.Comment.class);
        this.comment = commentAnnotation == null ? "" : ConfigManager.formatComment(commentAnnotation.value());
        this.enforce = field.isAnnotationPresent(ConfigAnnotations.Enforce.class);
        this.hide = field.isAnnotationPresent(ConfigAnnotations.Hidden.class);
        ConfigAnnotations.Permission permissionAnnotation = field.getAnnotation(ConfigAnnotations.Permission.class);
        int n = this.permission = permissionAnnotation == null ? 3 : permissionAnnotation.value();
        if (this.permission < 0 || this.permission > 4) {
            ConfigModEX.fatal(new IndexOutOfBoundsException("Permission level " + this.permission + " does not exist"));
        }
        this.defaultValue = this.cachedValue = this.getRealValue();
        this.type = (byte)(this.defaultValue instanceof Integer ? 1 : (this.defaultValue instanceof Short ? 2 : (this.defaultValue instanceof Long ? 3 : (this.defaultValue instanceof Float ? 4 : (this.defaultValue instanceof Double ? 5 : (this.defaultValue instanceof String ? 6 : (this.defaultValue instanceof Boolean ? 7 : 0)))))));
        switch (this.type) {
            case 1: {
                ConfigAnnotations.IntegerRange rangeI = field.getAnnotation(ConfigAnnotations.IntegerRange.class);
                this.min = rangeI != null ? (double)rangeI.min() : -2.147483648E9;
                this.max = rangeI != null ? (double)rangeI.max() : 2.147483647E9;
                this.showMin = this.min != -2.147483648E9;
                this.showMax = this.max != 2.147483647E9;
                break;
            }
            case 2: {
                ConfigAnnotations.ShortRange rangeS = field.getAnnotation(ConfigAnnotations.ShortRange.class);
                this.min = rangeS != null ? (double)rangeS.min() : -32768.0;
                this.max = rangeS != null ? (double)rangeS.max() : 32767.0;
                this.showMin = this.min != -32768.0;
                this.showMax = this.max != 32767.0;
                break;
            }
            case 3: {
                ConfigAnnotations.LongRange rangeL = field.getAnnotation(ConfigAnnotations.LongRange.class);
                this.min = rangeL != null ? (double)rangeL.min() : -9.223372036854776E18;
                this.max = rangeL != null ? (double)rangeL.max() : 9.223372036854776E18;
                this.showMin = this.min != -9.223372036854776E18;
                this.showMax = this.max != 9.223372036854776E18;
                break;
            }
            case 4: {
                ConfigAnnotations.FloatRange rangeF = field.getAnnotation(ConfigAnnotations.FloatRange.class);
                this.min = rangeF != null ? (double)rangeF.min() : -3.4028234663852886E38;
                this.max = rangeF != null ? (double)rangeF.max() : 3.4028234663852886E38;
                this.showMin = this.min != -3.4028234663852886E38;
                this.showMax = this.max != 3.4028234663852886E38;
                break;
            }
            case 5: {
                ConfigAnnotations.DoubleRange rangeD = field.getAnnotation(ConfigAnnotations.DoubleRange.class);
                this.min = rangeD != null ? rangeD.min() : -1.7976931348623157E308;
                this.max = rangeD != null ? rangeD.max() : Double.MAX_VALUE;
                this.showMin = this.min != -1.7976931348623157E308;
                this.showMax = this.max != Double.MAX_VALUE;
                break;
            }
            default: {
                this.min = 0.0;
                this.max = 0.0;
                this.showMin = false;
                this.showMax = false;
            }
        }
        if (this.min > this.max) {
            ConfigModEX.fatal(new IndexOutOfBoundsException("Minimum bound was higher than max bound in Range annotation"));
        }
        if (ConfigManager.isRemote) {
            this.clientValue = this.defaultValue;
        } else {
            this.serverValue = this.defaultValue;
        }
        this.hasChanged = true;
        ConfigModEX.debug("Sucessfully created a field instance for variable " + this.registryName + ": " + this.toString());
    }

    public boolean hasPermission() {
        return this.hasPermission(ConfigManager.getPermissionLevel());
    }

    public boolean hasPermission(int permission) {
        return this.permission == 0 || permission >= this.permission;
    }

    public Object getRealValue() {
        try {
            return this.field.get(this.config);
        }
        catch (Exception e) {
            ConfigModEX.warn("ConfigModEX has failed to get the value from field " + this.name);
            ConfigModEX.fatal(e);
            return null;
        }
    }

    public Object getRealCachedValue() {
        return this.cachedValue;
    }

    public FieldInstance setRealValue() {
        if (ConfigManager.isRemote) {
            this.setRealValue(this.getClientValue());
        } else {
            this.setRealValue(this.serverValue);
        }
        return this;
    }

    private FieldInstance setRealValue(Object value) {
        try {
            this.field.set(this.config, value);
            this.cachedValue = value;
            this.hasChanged = false;
        }
        catch (Exception e) {
            ConfigModEX.warn("ConfigModEX has failed to set the value to field " + this.name);
            ConfigModEX.fatal(e);
        }
        return this;
    }

    public Object getClientValue() {
        return (this.enforce || !this.hasPermission()) && this.serverValue != null ? this.serverValue : this.clientValue;
    }

    public Object getRealClientValue() {
        return this.clientValue;
    }

    public Object getServerValue() {
        return this.serverValue;
    }

    public boolean hasServerValue() {
        return this.serverValue != null;
    }

    private boolean setClient(Object value) {
        if (!this.hasPermission()) {
            return false;
        }
        try {
            switch (this.type) {
                case 1: {
                    this.clientValue = (int)Maths.clamp((double)Integer.valueOf(String.valueOf(value)).intValue(), this.min, this.max);
                    break;
                }
                case 2: {
                    this.clientValue = (short)Maths.clamp((double)Short.valueOf(String.valueOf(value)).shortValue(), this.min, this.max);
                    break;
                }
                case 3: {
                    this.clientValue = (long)Maths.clamp((double)Long.valueOf(String.valueOf(value)).longValue(), this.min, this.max);
                    break;
                }
                case 4: {
                    this.clientValue = Float.valueOf((float)Maths.clamp((double)Float.valueOf(String.valueOf(value)).floatValue(), this.min, this.max));
                    break;
                }
                case 5: {
                    this.clientValue = Maths.clamp(Double.valueOf(String.valueOf(value)), this.min, this.max);
                    break;
                }
                case 7: {
                    this.clientValue = (boolean)Boolean.valueOf(String.valueOf(value));
                    break;
                }
                default: {
                    this.clientValue = String.valueOf(value);
                }
            }
            this.hasChanged = this.hasChanged || this.cachedValue != this.clientValue;
        }
        catch (Exception e) {
            return false;
        }
        return this.cachedValue != this.clientValue;
    }

    private boolean setServer(Object value) {
        try {
            if (value == null) {
                this.serverValue = null;
            } else {
                switch (this.type) {
                    case 1: {
                        this.serverValue = (int)Maths.clamp((double)Integer.valueOf(String.valueOf(value)).intValue(), this.min, this.max);
                        break;
                    }
                    case 2: {
                        this.serverValue = (short)Maths.clamp((double)Short.valueOf(String.valueOf(value)).shortValue(), this.min, this.max);
                        break;
                    }
                    case 3: {
                        this.serverValue = (long)Maths.clamp((double)Long.valueOf(String.valueOf(value)).longValue(), this.min, this.max);
                        break;
                    }
                    case 4: {
                        this.serverValue = Float.valueOf((float)Maths.clamp((double)Float.valueOf(String.valueOf(value)).floatValue(), this.min, this.max));
                        break;
                    }
                    case 5: {
                        this.serverValue = Maths.clamp(Double.valueOf(String.valueOf(value)), this.min, this.max);
                        break;
                    }
                    case 7: {
                        this.serverValue = Boolean.valueOf(String.valueOf(value));
                        break;
                    }
                    default: {
                        this.serverValue = String.valueOf(value);
                    }
                }
            }
            this.hasChanged = this.hasChanged || (!ConfigManager.isRemote || this.enforce || !this.hasPermission()) && this.cachedValue != this.serverValue;
        }
        catch (Exception e) {
            return false;
        }
        return (!ConfigManager.isRemote || this.enforce || !this.hasPermission()) && this.cachedValue != this.serverValue;
    }

    public boolean setClientValue(Object value) {
        if (ConfigManager.isRemote) {
            if (value == null) {
                ConfigModEX.fatal(new NullPointerException("Client value cannot be null clientside"));
            }
            return this.setClient(value);
        }
        ConfigModEX.fatal(new IllegalArgumentException("Client value cannot be set serverside"));
        return false;
    }

    public boolean setServerValue(Object value) {
        if (!ConfigManager.isRemote && value == null) {
            ConfigModEX.fatal(new NullPointerException("Server value cannot be null serverside"));
        }
        return this.setServer(value);
    }

    public FieldInstance setToDefault() {
        if (ConfigManager.isRemote) {
            this.clientValue = this.defaultValue;
        } else {
            this.serverValue = this.defaultValue;
        }
        return this;
    }

    public boolean hasProperty() {
        return this.property != null;
    }

    public FieldInstance setProperty(Property property) {
        if (this.hasProperty()) {
            ConfigModEX.fatal(new IllegalArgumentException("Property was already set"));
        }
        this.property = property;
        return this;
    }

    public Property getProperty() {
        return this.property;
    }

    public FieldInstance updateProperty() {
        if (this.property == null) {
            ConfigModEX.error("Config property was not set. Skipping...");
        } else {
            this.property.setValue(String.valueOf(ConfigManager.isRemote ? this.clientValue : this.serverValue));
        }
        return this;
    }

    public void reset() {
        if (ConfigManager.isRemote) {
            this.setServerValue(null);
            this.setRealValue();
        }
    }

    public String toString() {
        return String.format("{instance=" + this.config.getName() + ", registryName=" + this.registryName + ", enforced=" + this.enforce + ", hide=" + this.hide + ", permission=" + this.permission + ", defaultValue=" + this.defaultValue + "}", new Object[0]);
    }
}

