/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.configex.manager;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.mrbt0907.configex.ConfigManager;
import net.mrbt0907.configex.ConfigModEX;
import net.mrbt0907.configex.api.ConfigAnnotations;
import net.mrbt0907.configex.api.IConfigEX;
import net.mrbt0907.configex.manager.FieldInstance;

public class ConfigInstance {
    public final IConfigEX config;
    private final Map<String, FieldInstance> fields = new LinkedHashMap<String, FieldInstance>();
    public final String name;
    public final String registryName;
    public final String description;
    public final String saveLocation;
    public final Configuration configuration;
    public final File fileLocation;
    private int variablesChanged;

    public ConfigInstance(IConfigEX config) {
        this.config = config;
        this.name = config.getName();
        this.registryName = ConfigManager.formatRegistryName(this.name);
        this.description = config.getDescription();
        this.saveLocation = config.getSaveLocation();
        this.fileLocation = new File(ConfigModEX.getGameFolder() + "config/" + this.saveLocation + ".cfg");
        this.configuration = new Configuration(this.fileLocation);
        this.initConfig();
    }

    public void initConfig() {
        ConfigModEX.debug("Initializing config " + this.registryName + "...");
        this.fields.clear();
        for (Field field : this.config.getClass().getFields()) {
            if (field.isAnnotationPresent(ConfigAnnotations.Ignore.class)) {
                ConfigModEX.debug("Ignoring field " + field.getName());
                continue;
            }
            FieldInstance instance = new FieldInstance(this.config, field);
            this.fields.put(instance.registryName, instance);
        }
        this.readConfigFile();
        this.writeConfigFile(false);
        ConfigModEX.debug("Config " + this.registryName + " has initialized successfully!");
    }

    public void writeNBT(NBTTagCompound nbt) {
        ConfigModEX.debug("Writing fields from " + this.name + " to nbt...");
        for (FieldInstance field : this.fields.values()) {
            NBTTagCompound nbtField = new NBTTagCompound();
            nbtField.func_74778_a("value", String.valueOf(field.getServerValue()));
            nbt.func_74782_a(field.registryName, (NBTBase)nbtField);
        }
        ConfigModEX.debug("Write complete!");
    }

    public void readNBT(NBTTagCompound nbt) {
        ConfigModEX.debug("Reading fields from " + (ConfigManager.isRemote ? "the server" : "a client") + " to config " + this.name + "...");
        boolean checkPerm = !ConfigManager.isRemote && nbt.func_186855_b("player");
        boolean setServer = !ConfigManager.isRemote || !nbt.func_74767_n("setClient");
        int permission = ConfigManager.getPermissionLevel(nbt.func_186857_a("player"));
        this.config.onConfigChanged(IConfigEX.Phase.START, this.fields.size());
        this.variablesChanged = 0;
        for (FieldInstance field : this.fields.values()) {
            if (!nbt.func_74764_b(field.registryName)) continue;
            if (checkPerm && !field.hasPermission(permission)) {
                ConfigModEX.warn("Rejecting value for " + field.registryName + " as the player does not have permission to change the value");
                continue;
            }
            NBTTagCompound nbtField = nbt.func_74775_l(field.registryName);
            String value = nbtField.func_74779_i("value");
            try {
                switch (field.type) {
                    case 1: {
                        this.setField(field, Integer.valueOf(value), setServer);
                        break;
                    }
                    case 2: {
                        this.setField(field, Short.valueOf(value), setServer);
                        break;
                    }
                    case 3: {
                        this.setField(field, Long.valueOf(value), setServer);
                        break;
                    }
                    case 4: {
                        this.setField(field, Float.valueOf(value), setServer);
                        break;
                    }
                    case 5: {
                        this.setField(field, Double.valueOf(value), setServer);
                        break;
                    }
                    case 6: {
                        this.setField(field, value, setServer);
                        break;
                    }
                    case 7: {
                        this.setField(field, Boolean.valueOf(value), setServer);
                    }
                }
                if (!this.updateField(field, false)) continue;
                ++this.variablesChanged;
            }
            catch (Exception e) {
                ConfigModEX.warn("Rejecting value for " + field.registryName + " as the value was unable to be set");
            }
        }
        ConfigModEX.debug("Read complete!");
        this.config.onConfigChanged(IConfigEX.Phase.END, this.variablesChanged);
        this.variablesChanged = -1;
    }

    public FieldInstance getField(String registryName) {
        return this.fields.get(registryName);
    }

    public List<FieldInstance> getFields() {
        return new ArrayList<FieldInstance>(this.fields.values());
    }

    public boolean setField(FieldInstance field, Object value, boolean changeServerVariable) {
        if (field == null) {
            ConfigModEX.fatal(new NullPointerException("Field was null"));
        }
        if (ConfigManager.isRemote) {
            if (changeServerVariable) {
                return field.setServerValue(value);
            }
            return field.setClientValue(value);
        }
        return field.setServerValue(value);
    }

    public void defaultField(FieldInstance field) {
        if (field == null) {
            ConfigModEX.fatal(new NullPointerException("Field was null"));
        }
        field.setToDefault();
    }

    public boolean updateField(FieldInstance field, boolean fullSync) {
        if (field == null) {
            ConfigModEX.fatal(new NullPointerException("Field was null"));
        }
        if (fullSync) {
            if (ConfigManager.isRemote) {
                field.setClientValue(field.getRealValue());
            } else {
                field.setServerValue(field.getRealValue());
            }
        }
        Object value = field.getRealCachedValue();
        if (field.hasChanged) {
            field.setRealValue();
            if (this.variablesChanged < 0) {
                this.config.onConfigChanged(IConfigEX.Phase.START, 1);
                this.config.onValueChanged(field.name, value, ConfigManager.isRemote ? field.getClientValue() : field.getServerValue());
                this.config.onConfigChanged(IConfigEX.Phase.END, 1);
            } else {
                this.config.onValueChanged(field.name, value, ConfigManager.isRemote ? field.getClientValue() : field.getServerValue());
            }
            return true;
        }
        return false;
    }

    public void updateAllFields(boolean fullSync) {
        if (fullSync) {
            this.config.onConfigChanged(IConfigEX.Phase.START, this.fields.size());
            this.variablesChanged = 0;
        }
        for (FieldInstance field : this.fields.values()) {
            if (!this.updateField(field, fullSync) || !fullSync) continue;
            ++this.variablesChanged;
        }
        if (fullSync) {
            this.config.onConfigChanged(IConfigEX.Phase.END, this.variablesChanged);
            this.variablesChanged = -1;
        }
    }

    public void writeConfigFile(boolean wipeFile) {
        if (wipeFile && this.fileLocation.exists()) {
            this.fileLocation.delete();
        }
        ConfigModEX.debug("Config " + this.registryName + " is writing to file " + ConfigModEX.getGameFolder() + "config/" + this.saveLocation + ".cfg...");
        this.fields.forEach((name, field) -> {
            if (field.hasProperty()) {
                field.updateProperty();
            } else {
                ConfigModEX.warn("Field " + name + " had not initialized in the config. Skipping write...");
            }
        });
        this.configuration.save();
        ConfigModEX.debug("Saved config " + this.registryName + " successfully!");
    }

    public void readConfigFile() {
        ConfigModEX.debug("Config " + this.registryName + " is reading from file " + ConfigModEX.getGameFolder() + "config/" + this.saveLocation + ".cfg...");
        this.config.onConfigChanged(IConfigEX.Phase.START, this.fields.size());
        this.variablesChanged = 0;
        this.fields.forEach((name, field) -> {
            switch (field.type) {
                case 1: {
                    if (!field.hasProperty()) {
                        field.setProperty(this.configuration.get(this.registryName, field.displayName, ((Integer)field.defaultValue).intValue(), ConfigManager.formatCommentForCFG(field)));
                    }
                    this.setField((FieldInstance)field, field.getProperty().getInt(), false);
                    if (!this.updateField((FieldInstance)field, false)) break;
                    ++this.variablesChanged;
                    break;
                }
                case 2: {
                    if (!field.hasProperty()) {
                        field.setProperty(this.configuration.get(this.registryName, field.displayName, (int)((Short)field.defaultValue).shortValue(), ConfigManager.formatCommentForCFG(field)));
                    }
                    this.setField((FieldInstance)field, (short)field.getProperty().getInt(), false);
                    if (!this.updateField((FieldInstance)field, false)) break;
                    ++this.variablesChanged;
                    break;
                }
                case 3: {
                    if (!field.hasProperty()) {
                        field.setProperty(this.configuration.get(this.registryName, field.displayName, (double)((Long)field.defaultValue).longValue(), ConfigManager.formatCommentForCFG(field)));
                    }
                    this.setField((FieldInstance)field, Long.valueOf(field.getProperty().getString().replaceFirst("\\..*", "")), false);
                    if (!this.updateField((FieldInstance)field, false)) break;
                    ++this.variablesChanged;
                    break;
                }
                case 4: {
                    if (!field.hasProperty()) {
                        field.setProperty(this.configuration.get(this.registryName, field.displayName, (double)((Float)field.defaultValue).floatValue(), ConfigManager.formatCommentForCFG(field)));
                    }
                    this.setField((FieldInstance)field, Float.valueOf((float)field.getProperty().getDouble()), false);
                    if (!this.updateField((FieldInstance)field, false)) break;
                    ++this.variablesChanged;
                    break;
                }
                case 5: {
                    if (!field.hasProperty()) {
                        field.setProperty(this.configuration.get(this.registryName, field.displayName, ((Double)field.defaultValue).doubleValue(), ConfigManager.formatCommentForCFG(field)));
                    }
                    this.setField((FieldInstance)field, field.getProperty().getDouble(), false);
                    if (!this.updateField((FieldInstance)field, false)) break;
                    ++this.variablesChanged;
                    break;
                }
                case 6: {
                    if (!field.hasProperty()) {
                        field.setProperty(this.configuration.get(this.registryName, field.displayName, (String)field.defaultValue, ConfigManager.formatCommentForCFG(field)));
                    }
                    this.setField((FieldInstance)field, field.getProperty().getString(), false);
                    if (!this.updateField((FieldInstance)field, false)) break;
                    ++this.variablesChanged;
                    break;
                }
                case 7: {
                    if (!field.hasProperty()) {
                        field.setProperty(this.configuration.get(this.registryName, field.displayName, ((Boolean)field.defaultValue).booleanValue(), ConfigManager.formatCommentForCFG(field)));
                    }
                    this.setField((FieldInstance)field, field.getProperty().getBoolean(), false);
                    if (!this.updateField((FieldInstance)field, false)) break;
                    ++this.variablesChanged;
                    break;
                }
                default: {
                    ConfigModEX.warn("Field " + field.registryName + " is using an unsupported type. Skipping...");
                    return;
                }
            }
        });
        this.configuration.save();
        ConfigModEX.debug("Loaded config " + this.registryName + " successfully!");
        this.config.onConfigChanged(IConfigEX.Phase.END, this.variablesChanged);
        this.variablesChanged = -1;
    }

    public int size() {
        return this.fields.size();
    }

    public void setToDefault() {
        this.fields.forEach((registryName, field) -> field.setToDefault());
    }

    public void reset(boolean fullReset) {
        this.config.onConfigChanged(IConfigEX.Phase.START, this.fields.size());
        this.variablesChanged = 0;
        this.fields.forEach((name, field) -> {
            Object value = field.getRealCachedValue();
            if (fullReset) {
                field.reset();
            } else {
                field.setRealValue();
            }
            if (value != field.getRealCachedValue() || !fullReset) {
                this.config.onValueChanged(field.name, value, field.getRealCachedValue());
                ++this.variablesChanged;
            }
        });
        this.config.onConfigChanged(IConfigEX.Phase.END, this.variablesChanged);
        this.variablesChanged = -1;
        ConfigModEX.debug("Reset all fields for config " + this.name);
    }
}

