/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.configex.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class GuiScrollPanel {
    public static final int scrollUpButtonID = 7;
    public static final int scrollDownButtonID = 8;
    public final Minecraft mc;
    public final int slotHeight;
    public final int scrollUpID;
    public final int scrollDownID;
    public int xStart;
    public int yStart;
    public int xScrollBar;
    public int xSize;
    public int ySize;
    public int scrollBarSize;
    public int selected = -1;
    protected static float scrollPos;
    protected float initialMouseY;

    public GuiScrollPanel(Minecraft mc, int xStart, int yStart, int xScrollBar, int xSize, int ySize, int scrollBarSize, int slotHeight, int scrollUpID, int scrollDownID) {
        this.mc = mc;
        this.xStart = xStart;
        this.yStart = yStart;
        this.xScrollBar = xScrollBar;
        this.xSize = xSize;
        this.ySize = ySize;
        this.scrollBarSize = scrollBarSize;
        this.slotHeight = slotHeight;
        this.scrollUpID = scrollUpID;
        this.scrollDownID = scrollDownID;
    }

    protected abstract void onSlotClicked(int var1, boolean var2);

    protected abstract boolean isSelected(int var1);

    protected abstract void drawBackground(Tessellator var1, int var2, int var3, float var4);

    protected abstract void drawScrollBar(Tessellator var1, int var2, int var3, float var4);

    protected abstract void drawForeground(Tessellator var1, int var2, int var3, float var4);

    protected abstract void drawSlotPre(Tessellator var1, int var2, int var3, int var4);

    protected abstract void drawSlotPost(Tessellator var1, int var2, int var3, int var4);

    protected abstract int getSize();

    protected int getScrollHeight() {
        return this.getSize() * this.slotHeight;
    }

    protected void setScrollPos(float scroll) {
        scrollPos = MathHelper.func_76131_a((float)scroll, (float)0.0f, (float)(this.getScrollHeight() - this.ySize));
    }

    protected void adjustScrollPos(float adjustment) {
        this.setScrollPos(scrollPos + adjustment);
    }

    protected void setScrollPosPerc(float perc) {
        this.setScrollPos((float)(this.getScrollHeight() - this.ySize) * perc);
    }

    public void actionPerformed(GuiButton button) {
        if (button.field_146124_l && this.getScrollHeight() - this.ySize > 0) {
            if (button.field_146127_k == this.scrollUpID) {
                this.adjustScrollPos((float)(-this.slotHeight / this.getSize()) * 0.75f);
            } else if (button.field_146127_k == this.scrollDownID) {
                this.adjustScrollPos((float)(this.slotHeight / this.getSize()) * 0.75f);
            }
        }
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        int size = this.getSize();
        int height = this.getScrollHeight();
        int slot = 0;
        int slotHeight = 0;
        if (Mouse.isButtonDown((int)0)) {
            int realY = this.yStart + this.ySize;
            slot = (int)((scrollPos + (float)(mouseY - this.yStart)) / (float)this.slotHeight);
            if (slot < size && mouseX > this.xStart && mouseX < this.xStart + this.xSize && mouseY > this.yStart && mouseY < realY) {
                this.onSlotClicked(slot, false);
            } else {
                this.selected = -1;
            }
        } else {
            while (!this.mc.field_71474_y.field_85185_A && this.getScrollHeight() - this.ySize > 0 && Mouse.next()) {
                int l2 = Mouse.getEventDWheel();
                if (l2 > 0) {
                    this.adjustScrollPos((float)(-height / this.getSize()) * 0.75f);
                    continue;
                }
                if (l2 >= 0) continue;
                this.adjustScrollPos((float)(height / this.getSize()) * 0.75f);
            }
        }
        slot = (int)(scrollPos / (float)this.slotHeight);
        slotHeight = slot * this.slotHeight;
        GlStateManager.func_179094_E();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tessellator tessellator = Tessellator.func_178181_a();
        this.drawBackground(tessellator, mouseX, mouseY, partialTicks);
        int i = slot;
        while (i < size && (float)slotHeight - scrollPos < (float)this.ySize) {
            this.drawSlotPre(tessellator, this.xStart, (int)((float)(this.yStart + slotHeight) - scrollPos), i);
            ++i;
            slotHeight += this.slotHeight;
        }
        this.drawScrollBar(tessellator, mouseX, mouseY, partialTicks);
        this.drawForeground(tessellator, mouseX, mouseY, partialTicks);
        slotHeight = slot * this.slotHeight;
        i = slot;
        while (i < size && (float)slotHeight - scrollPos < (float)this.ySize) {
            this.drawSlotPost(tessellator, this.xStart, (int)((float)(this.yStart + slotHeight) - scrollPos), i);
            ++i;
            slotHeight += this.slotHeight;
        }
        GlStateManager.func_179121_F();
    }
}

