/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.configex.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.mrbt0907.configex.ConfigManager;
import net.mrbt0907.configex.ConfigModEX;
import net.mrbt0907.configex.gui.GuiConfigEditor;
import net.mrbt0907.configex.gui.GuiConfigEntry;
import net.mrbt0907.configex.gui.GuiScrollPanel;
import net.mrbt0907.configex.manager.ConfigInstance;
import net.mrbt0907.configex.manager.FieldInstance;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiConfigScrollPanel
extends GuiScrollPanel {
    private GuiConfigEditor config;
    public final List<ConfigInstance> configs;
    public final List<GuiConfigEntry> options;
    private int mouseX;
    private int mouseY;
    protected int mouseYStart = -1;

    public GuiConfigScrollPanel(GuiConfigEditor controls, Minecraft mc, int scrollBarX, int width, int height, int scrollBarSize, int slotHeight) {
        super(mc, controls.xStart, controls.yStart, scrollBarX, width, height, scrollBarSize, slotHeight, 7, 8);
        this.config = controls;
        this.configs = ConfigManager.getInstances();
        this.options = new ArrayList<GuiConfigEntry>();
        this.populateData();
    }

    @Override
    protected void onSlotClicked(int i, boolean flag) {
        if (!flag) {
            int size = this.getSize();
            if (i < size) {
                this.selected = i;
            } else {
                ConfigModEX.warn("Index was set higher than options list. Bringing index back into range...");
                this.selected = size - 1;
            }
            KeyBinding.func_74508_b();
        }
    }

    protected void mouseClicked(int mouseX, int mouseY, int eventButton) {
        for (GuiConfigEntry entry : this.options) {
            entry.textField.mouseClicked(mouseX, mouseY, eventButton);
        }
    }

    @Override
    protected boolean isSelected(int i) {
        return false;
    }

    @Override
    protected void drawBackground(Tessellator tess, int mouseX, int mouseY, float partialTicks) {
        this.config.drawBackgroundLayer();
    }

    @Override
    protected void drawForeground(Tessellator tess, int mouseX, int mouseY, float partialTicks) {
        this.config.drawForegroundLayer();
        this.config.drawButtons(mouseX, mouseY, partialTicks);
    }

    @Override
    public void drawScreen(int mX, int mY, float f) {
        this.mouseX = mX;
        this.mouseY = mY;
        this.xStart = this.config.xStart + 169;
        this.yStart = this.config.yStart + 40;
        this.xScrollBar = this.xStart + 133;
        if (this.selected > -1 && !Mouse.isButtonDown((int)0) && Mouse.getDWheel() == 0 && Mouse.next() && Mouse.getEventButtonState()) {
            this.selected = -1;
            KeyBinding.func_74508_b();
        }
        super.drawScreen(mX, mY, f);
        if (Mouse.isButtonDown((int)0) && this.mouseX > this.xScrollBar && this.mouseX < this.xScrollBar + this.scrollBarSize && this.mouseY > this.yStart && this.mouseY < this.yStart + this.ySize) {
            int yScrollMax = this.ySize - this.scrollBarSize;
            int yScrollExtra = this.getScrollHeight() - this.ySize;
            if (yScrollExtra > 0) {
                float percExtra = Math.min((float)yScrollExtra / (float)yScrollMax, 1.0f);
                int yStartMax = (int)((float)this.scrollBarSize * 0.5f + (float)yScrollMax * (1.0f - percExtra) * 0.5f);
                int yEndMax = (int)((float)yScrollMax * Math.min(percExtra, 1.0f));
                this.setScrollPosPerc(MathHelper.func_76131_a((float)((float)(this.mouseY - this.yStart - yStartMax) / (float)yEndMax), (float)0.0f, (float)1.0f));
            }
        }
    }

    @Override
    protected void drawScrollBar(Tessellator tessellator, int mouseX, int mouseY, float partialTicks) {
        int yScrollMax = this.ySize - this.scrollBarSize;
        int yScrollExtra = this.getScrollHeight() - this.ySize;
        if (yScrollExtra > 0) {
            float percScrolled = scrollPos / (float)yScrollExtra;
            float percExtra = MathHelper.func_76131_a((float)((float)yScrollExtra / (float)yScrollMax), (float)0.0f, (float)1.0f);
            int yStartMax = (int)((float)yScrollMax * percExtra * percScrolled);
            int yEndMax = (int)((float)yScrollMax * percExtra * (1.0f - percScrolled));
            this.drawGradientRect(this.xScrollBar, this.yStart + yStartMax, this.xScrollBar + this.scrollBarSize, this.yStart + this.scrollBarSize + yScrollMax - yEndMax, 0x55000000, 0x55000000);
            this.drawGradientRect(this.xScrollBar, this.yStart, this.xScrollBar + this.scrollBarSize, this.yStart + this.ySize, 0x55000000, 0x55000000);
        }
    }

    @Override
    protected void drawSlotPre(Tessellator tessellatorint, int xPosition, int yPosition, int slot) {
        if (this.getSize() == 0) {
            return;
        }
        xPosition -= 20;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiConfigEntry entry = this.options.get(slot);
        String name = entry.name;
        if (this.mc.field_71466_p.func_78256_a(name) > this.xSize + 18) {
            name = this.mc.field_71466_p.func_78269_a(name, this.xSize + 18) + "...";
        }
        int stringWidth = this.mc.field_71466_p.func_78256_a(name);
        this.config.func_73731_b(this.mc.field_71466_p, name, xPosition - stringWidth + 15, yPosition + 3, -1);
        entry.textField.xPos = xPosition + 20;
        entry.textField.yPos = yPosition;
        entry.textField.drawTextBox();
    }

    @Override
    protected void drawSlotPost(Tessellator tessellatorint, int xPosition, int yPosition, int slot) {
        boolean hover_string;
        if (this.getSize() == 0) {
            return;
        }
        xPosition -= 20;
        GuiConfigEntry entry = this.options.get(slot);
        String name = entry.name;
        if (this.mc.field_71466_p.func_78256_a(name) > this.xSize + 18) {
            name = this.mc.field_71466_p.func_78269_a(name, this.xSize + 18) + "...";
        }
        int stringWidth = this.mc.field_71466_p.func_78256_a(name);
        int hover_x_min = xPosition - stringWidth + 15;
        int hover_y_min = yPosition;
        int hover_x_max = xPosition + 15;
        int hover_y_max = yPosition + this.slotHeight;
        boolean bl = hover_string = this.mouseX >= hover_x_min && this.mouseY >= hover_y_min && this.mouseX < hover_x_max && this.mouseY < hover_y_max;
        if (hover_string) {
            int i;
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2929);
            int l2 = 0;
            int k2 = hover_y_min - 10;
            String[] lines = (entry.name + Configuration.NEW_LINE + Configuration.NEW_LINE + ConfigManager.formatCommentForGui(entry.comment, entry.defaultValue, entry.type, entry.showMin, entry.showMax, entry.min, entry.max) + (entry.hasPermission ? "" : Configuration.NEW_LINE + TextFormatting.RED + "" + TextFormatting.BOLD + "Higher permission level required") + Configuration.NEW_LINE + Configuration.NEW_LINE + TextFormatting.GRAY + "" + TextFormatting.ITALIC + "On Text Box" + Configuration.NEW_LINE + TextFormatting.GRAY + "" + TextFormatting.ITALIC + (entry.type == 7 ? "Shift & Left Click: Switch to true/false" : "Shift & Left Click: Reset to original value") + Configuration.NEW_LINE + TextFormatting.GRAY + "" + TextFormatting.ITALIC + "Shift & Right Click: Reset to default value" + Configuration.NEW_LINE + TextFormatting.BLUE + "" + TextFormatting.ITALIC + entry.registryName).replaceAll(Configuration.NEW_LINE, "\n").split("\\n");
            for (i = 0; i < lines.length; ++i) {
                if (this.mc.field_71466_p.func_78256_a(lines[i]) <= l2) continue;
                l2 = this.mc.field_71466_p.func_78256_a(lines[i]);
            }
            this.drawGradientRect(this.mouseX - 3, k2 - 3, this.mouseX + l2 + 3, k2 + 11 + 10 * (lines.length - 1), -1073741824, -1073741824);
            for (i = 0; i < lines.length; ++i) {
                this.mc.field_71466_p.func_175063_a(lines[i], (float)this.mouseX, (float)(k2 + i * (this.slotHeight / 2)), -1);
            }
            GL11.glEnable((int)2929);
        }
    }

    public boolean keyTyped(char c, int i) {
        if (this.selected > -1) {
            GuiConfigEntry entry = this.options.get(this.selected);
            if (entry.textField.isFocused()) {
                entry.textField.textboxKeyTyped(c, i);
                entry.textField.updateChange();
                if (i == 28) {
                    this.selected = -1;
                    entry.textField.isFocused = false;
                    return true;
                }
                if (i == 1) {
                    this.selected = -1;
                    entry.textField.isFocused = false;
                }
            }
            return false;
        }
        if (this.getScrollHeight() - this.ySize > 0) {
            int height = this.getScrollHeight();
            if (i == 200) {
                this.adjustScrollPos(-height / this.getSize());
            } else if (i == 208) {
                this.adjustScrollPos(height / this.getSize());
            } else if (i == 209) {
                this.adjustScrollPos(height / this.getSize() + this.slotHeight * 8);
            } else if (i == 201) {
                this.adjustScrollPos(-height / this.getSize() - this.slotHeight * 8);
            } else if (i == 199) {
                this.adjustScrollPos(-(this.getScrollHeight() - this.ySize));
            } else if (i == 207) {
                this.adjustScrollPos(this.getScrollHeight() - this.ySize);
            }
        }
        return true;
    }

    protected void drawGradientRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        float f = (float)(par5 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(par5 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(par5 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(par5 & 0xFF) / 255.0f;
        float f4 = (float)(par6 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(par6 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(par6 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(par6 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b((double)par3, (double)par2, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_181662_b((double)par1, (double)par2, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_181662_b((double)par1, (double)par4, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        vertexbuffer.func_181662_b((double)par3, (double)par4, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public void populateData() {
        scrollPos = 0.0f;
        this.options.clear();
        ConfigInstance config = this.configs.get(GuiConfigEditor.curIndex);
        if (config != null) {
            config.getFields().forEach(field -> {
                boolean hasPermission = field.hasPermission();
                if ((hasPermission || !field.hide || hasPermission) && (field.enforce && (GuiConfigEditor.serverMode || ConfigManager.isSinglePlayer()) || !field.enforce)) {
                    this.options.add(new GuiConfigEntry((FieldInstance)field, GuiConfigEditor.serverMode));
                }
            });
        }
    }

    @Override
    protected int getSize() {
        return this.options.size();
    }
}

