/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.configex.gui;

import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.mrbt0907.configex.ConfigManager;
import net.mrbt0907.configex.gui.GuiBetterTextField;
import net.mrbt0907.configex.gui.GuiConfigEditor;
import net.mrbt0907.configex.manager.FieldInstance;

@SideOnly(value=Side.CLIENT)
public class GuiConfigEntry {
    private static final Minecraft MC = Minecraft.func_71410_x();
    public final String categoryName;
    public final String name;
    public final String registryName;
    public final String comment;
    public final GuiBetterTextField textField;
    public final String value;
    public final String defaultValue;
    public final int type;
    public final double min;
    public final double max;
    public final boolean hasPermission;
    public final boolean showMin;
    public final boolean showMax;

    public GuiConfigEntry(FieldInstance field, boolean serverValue) {
        this.categoryName = ConfigManager.formatRegistryName(field.config.getName());
        this.name = field.displayName;
        this.registryName = field.registryName;
        this.comment = field.comment;
        this.value = String.valueOf(serverValue ? field.getServerValue() : (field.hasPermission() ? field.getRealClientValue() : field.getClientValue()));
        this.defaultValue = String.valueOf(field.defaultValue);
        this.textField = new GuiBetterTextField(GuiConfigEntry.MC.field_71466_p, 0, 0, 130, 16, this.value, this.defaultValue);
        this.textField.isEnabled = field.hasPermission();
        this.hasPermission = field.hasPermission();
        this.textField.setVisible(!(!this.hasPermission && field.hide && !this.hasPermission || (!field.enforce || !GuiConfigEditor.serverMode && !ConfigManager.isSinglePlayer()) && field.enforce));
        this.type = field.type;
        this.min = field.min;
        this.max = field.max;
        this.showMin = field.showMin;
        this.showMax = field.showMax;
    }

    @SideOnly(value=Side.CLIENT)
    public void initButton() {
        this.textField.setText(this.value);
    }
}

