/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.configex.gui;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.mrbt0907.configex.ConfigManager;
import net.mrbt0907.configex.ConfigModEX;
import net.mrbt0907.configex.gui.GuiConfigEntry;
import net.mrbt0907.configex.gui.GuiConfigScrollPanel;
import net.mrbt0907.configex.network.NetworkHandler;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiConfigEditor
extends GuiScreen {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("configex", "textures/gui/advanced_gui.png");
    public static final ResourceLocation GUI_BORDER_TEXTURE = new ResourceLocation("configex", "textures/gui/advanced_gui_border.png");
    public static int G_RESET = 0;
    public static int G_SAVE = 1;
    public static int G_MODNEXT = 2;
    public static int G_MODPREV = 3;
    public static int G_CONFIGMODE = 4;
    public static int G_CLOSE = 9;
    public static int curIndex = 0;
    public static boolean serverMode = false;
    public GuiConfigScrollPanel scrollPane;
    public int xCenter;
    public int yCenter;
    public int xStart;
    public int yStart;
    public int xSize = 320;
    public int ySize = 246;
    public boolean changed;

    public GuiConfigEditor() {
        this.field_146297_k = Minecraft.func_71410_x();
        this.scrollPane = new GuiConfigScrollPanel(this, this.field_146297_k, this.xStart + 169, 130, 175, 8, 20);
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.scrollPane.drawScreen(mouseX, mouseY, partialTicks);
    }

    public void drawButtons(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void drawForegroundLayer() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_BORDER_TEXTURE);
        this.func_73729_b(this.xStart, this.yStart, 0, 0, 512, 512);
        String title = TextFormatting.BOLD + "" + this.scrollPane.configs.get((int)GuiConfigEditor.curIndex).name;
        String subtitle = this.format("title." + (serverMode ? "server" : "client"), new Object[0]);
        this.func_73731_b(this.field_146289_q, subtitle, this.xStart + 160 - this.field_146289_q.func_78256_a(subtitle) / 2, this.yStart + 23, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, title, this.xStart + 160 - this.field_146289_q.func_78256_a(title) / 2, this.yStart + 10, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, curIndex + 1 + "/" + this.scrollPane.configs.size(), this.xStart + 40, this.yStart + 226, 0xFFFFFF);
        if (this.scrollPane.getSize() == 0) {
            String noEntries = TextFormatting.GRAY + this.format("entries." + (this.scrollPane.configs.get(curIndex).size() == 0 ? "empty" : "permission"), new Object[0]);
            this.func_73731_b(this.field_146289_q, noEntries, this.xStart + 160 - this.field_146289_q.func_78256_a(noEntries) / 2, this.yStart + 120, 0xFFFFFF);
        }
    }

    protected void drawBackgroundLayer() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_146270_b(0);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
        this.func_73729_b(this.xStart, this.yStart, 0, 0, 512, 512);
    }

    public boolean func_73868_f() {
        return true;
    }

    public void func_73866_w_() {
        ScaledResolution sr = new ScaledResolution(this.field_146297_k);
        int scaledWidth = sr.func_78326_a();
        int scaledHeight = sr.func_78328_b();
        int buttonWidth = 30;
        int buttonHeight = 20;
        int buttonBottomY = 220;
        this.xCenter = (int)((float)scaledWidth * 0.5f);
        this.yCenter = (int)((float)scaledHeight * 0.5f);
        this.xStart = (int)((float)this.xCenter - (float)this.xSize * 0.5f);
        this.yStart = (int)((float)this.yCenter - (float)this.ySize * 0.5f);
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(G_MODNEXT, this.xStart + 74, this.yStart + buttonBottomY, buttonWidth, buttonHeight, this.format("next", new Object[0])));
        this.field_146292_n.add(new GuiButton(G_MODPREV, this.xStart + 7, this.yStart + buttonBottomY, buttonWidth, buttonHeight, this.format("previous", new Object[0])));
        this.field_146292_n.add(new GuiButton(G_SAVE, this.xStart + 252, this.yStart + buttonBottomY, buttonWidth + 32, buttonHeight, this.format("exit", new Object[0])));
        if (ConfigManager.isSinglePlayer()) {
            if (serverMode) {
                serverMode = false;
                this.scrollPane.populateData();
            }
        } else {
            this.field_146292_n.add(new GuiButton(G_CONFIGMODE, this.xStart + 162, this.yStart + buttonBottomY, buttonWidth + 56, buttonHeight, serverMode ? this.format("clientmode", new Object[0]) : this.format("servermode", new Object[0])));
        }
    }

    protected void func_73869_a(char par1, int par2) {
        if (this.scrollPane.keyTyped(par1, par2) && par2 == 1) {
            if (this.field_146297_k.field_71439_g != null) {
                this.field_146297_k.field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("config.gui." + (this.changed ? "save" : "nosave"), new Object[0]));
            }
            this.field_146297_k.func_147108_a(null);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        try {
            super.func_73864_a(par1, par2, par3);
            this.scrollPane.mouseClicked(par1, par2, par3);
        }
        catch (Exception e) {
            ConfigModEX.error(e);
        }
    }

    protected void func_146284_a(GuiButton var1) {
        this.checkForUpdates();
        if (var1.field_146127_k == G_RESET) {
            this.checkForUpdates();
        } else if (var1.field_146127_k == G_MODPREV) {
            if (--curIndex < 0) {
                curIndex = this.scrollPane.configs.size() - 1;
            }
            this.scrollPane.populateData();
        } else if (var1.field_146127_k == G_MODNEXT) {
            if (++curIndex >= this.scrollPane.configs.size()) {
                curIndex = 0;
            }
            this.scrollPane.populateData();
        } else if (var1.field_146127_k == G_CONFIGMODE) {
            serverMode = !serverMode;
            this.scrollPane.populateData();
        } else if (var1.field_146127_k == G_SAVE) {
            if (this.field_146297_k.field_71439_g != null && this.changed) {
                this.field_146297_k.field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("config.gui.save", new Object[0]));
            }
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        }
        this.func_73866_w_();
    }

    public void checkForUpdates() {
        HashMap<String, NBTTagCompound> tags = new HashMap<String, NBTTagCompound>();
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagCompound nbtManager = new NBTTagCompound();
        for (GuiConfigEntry guiConfigEntry : this.scrollPane.options) {
            if (!tags.containsKey(guiConfigEntry.categoryName)) {
                tags.put(guiConfigEntry.categoryName, new NBTTagCompound());
            }
            if (!guiConfigEntry.textField.hasChanged) continue;
            this.changed = true;
            NBTTagCompound nbtField = new NBTTagCompound();
            nbtField.func_74778_a("value", guiConfigEntry.textField.text);
            ((NBTTagCompound)tags.get(guiConfigEntry.categoryName)).func_74782_a(guiConfigEntry.registryName, (NBTBase)nbtField);
        }
        for (Map.Entry entry : tags.entrySet()) {
            if (((NBTTagCompound)entry.getValue()).func_82582_d()) continue;
            nbtManager.func_74782_a((String)entry.getKey(), (NBTBase)entry.getValue());
        }
        nbt.func_74782_a("manager", (NBTBase)nbtManager);
        if (!nbtManager.func_82582_d()) {
            if (serverMode) {
                ConfigModEX.debug("Sending advanced config data to server...");
                NetworkHandler.sendServerPacket(0, nbt);
            } else {
                ConfigModEX.debug("Applying client changes...");
                nbt.func_74757_a("setClient", true);
                ConfigManager.readNBT(nbt);
                ConfigManager.save();
            }
        }
    }

    public void func_73729_b(int x, int y, int textureX, int textureY, int width, int height) {
        GlStateManager.func_179094_E();
        float f = 0.001953125f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179141_d();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + height) * f)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + height) * f)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + 0), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + 0) * f)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + 0), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + 0) * f)).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    private String format(String local, Object ... args) {
        return I18n.func_135052_a((String)("config.gui." + local), (Object[])args);
    }
}

