/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.configex.command;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.mrbt0907.configex.ConfigManager;
import net.mrbt0907.configex.manager.FieldInstance;
import net.mrbt0907.configex.network.NetworkHandler;

public class CommandConfigEX
extends CommandBase {
    public String func_71517_b() {
        return "configex";
    }

    public String func_71518_a(ICommandSender sender) {
        return "command." + this.func_71517_b() + ".usage";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public int func_82362_a() {
        return 0;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        switch (args.length) {
            case 1: {
                return CommandConfigEX.func_71530_a((String[])args, (String[])new String[]{"get", "set", "default", "config"});
            }
            case 2: {
                switch (args[0]) {
                    case "get": 
                    case "set": 
                    case "default": {
                        return CommandConfigEX.func_71530_a((String[])args, (String[])new String[]{"client", "server"});
                    }
                }
            }
            case 3: {
                switch (args[0]) {
                    case "get": 
                    case "set": 
                    case "default": {
                        return CommandConfigEX.func_71530_a((String[])args, (String[])ConfigManager.getFieldIDs());
                    }
                }
            }
            case 4: {
                switch (args[0]) {
                    case "set": {
                        return CommandConfigEX.func_71530_a((String[])args, (String[])new String[]{"<value>"});
                    }
                }
            }
        }
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length > 0) {
            switch (args[0].toLowerCase()) {
                case "get": {
                    if (args.length > 2) {
                        this.get(server, sender, args[1].equalsIgnoreCase("server"), args[2]);
                        break;
                    }
                    this.say(sender, TextFormatting.RED + "Usage: /" + this.func_71517_b() + " get <client/server> <ConfigID:VariableID>");
                    break;
                }
                case "set": {
                    if (args.length > 3) {
                        this.set(server, sender, args[1].equalsIgnoreCase("server"), args[2], String.join((CharSequence)" ", Arrays.copyOfRange(args, 3, args.length)));
                        break;
                    }
                    this.say(sender, TextFormatting.RED + "Usage: /" + this.func_71517_b() + " set <client/server> <ConfigID:VariableID> <New Value>");
                    break;
                }
                case "default": {
                    if (args.length > 2) {
                        this.setDefault(server, sender, args[1].equalsIgnoreCase("server"), args[2]);
                        break;
                    }
                    this.say(sender, TextFormatting.RED + "Usage: /" + this.func_71517_b() + " default <client/server> <ConfigID:VariableID>");
                    break;
                }
                case "config": {
                    if (sender instanceof EntityPlayerMP) {
                        this.say(sender, "Opening config gui...");
                        this.sendPacket(5, new NBTTagCompound(), sender);
                        break;
                    }
                    this.say(sender, TextFormatting.RED + "You cannot run this sub command in the console");
                    break;
                }
                default: {
                    this.say(sender, TextFormatting.RED + "Usage: /" + this.func_71517_b() + " <config/default/get/set/refresh>");
                    break;
                }
            }
        } else {
            this.say(sender, TextFormatting.RED + "Usage: /" + this.func_71517_b() + " <config/default/get/set/refresh>");
        }
    }

    private void setDefault(MinecraftServer server, ICommandSender sender, boolean toServer, String registryName) {
        int permissionLevel = this.getPermission(server, sender);
        String[] registryNames = registryName.split(":");
        if (registryNames.length > 1) {
            if (toServer && !ConfigManager.isRemote) {
                FieldInstance field = ConfigManager.getFieldInstance(registryNames[0], registryName);
                if (field == null) {
                    this.say(sender, TextFormatting.RED + registryName + " does not exist");
                } else if (field.hasPermission(permissionLevel) || !field.enforce && !field.hide) {
                    field.setToDefault();
                    ConfigManager.save(field.config.getName(), field.registryName);
                    this.say(sender, field.name + " was set to default successfully! Value: " + field.getRealCachedValue());
                } else {
                    this.say(sender, TextFormatting.RED + field.name + " requires a higher permission level to set to default");
                }
            } else {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74778_a("config", registryNames[0]);
                nbt.func_74778_a("field", registryName);
                this.sendPacket(3, nbt, sender);
            }
        } else {
            this.say(sender, TextFormatting.RED + registryName + " is not a valid registry name");
        }
    }

    private void set(MinecraftServer server, ICommandSender sender, boolean toServer, String registryName, String value) {
        int permissionLevel = this.getPermission(server, sender);
        String[] registryNames = registryName.split(":");
        if (registryNames.length > 1) {
            if (toServer) {
                FieldInstance field = ConfigManager.getFieldInstance(registryNames[0], registryName);
                if (field == null) {
                    this.say(sender, TextFormatting.RED + registryName + " does not exist");
                } else if (field.hasPermission(permissionLevel) || !field.enforce && !field.hide) {
                    if (field.setServerValue(value)) {
                        ConfigManager.save(field.config.getName(), field.registryName);
                        this.say(sender, field.name + " was set successfully! Value: " + field.getRealCachedValue());
                    } else {
                        this.say(sender, TextFormatting.RED + field.name + " was not set successfully");
                    }
                } else {
                    this.say(sender, TextFormatting.RED + field.name + " requires a higher permission level to set");
                }
            } else {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74778_a("config", registryNames[0]);
                nbt.func_74778_a("field", registryName);
                nbt.func_74778_a("value", value);
                this.sendPacket(2, nbt, sender);
            }
        } else {
            this.say(sender, TextFormatting.RED + registryName + " is not a valid registry name");
        }
    }

    private void get(MinecraftServer server, ICommandSender sender, boolean fromServer, String registryName) {
        int permissionLevel = this.getPermission(server, sender);
        String[] registryNames = registryName.split(":");
        if (registryNames.length > 1) {
            if (fromServer) {
                FieldInstance field = ConfigManager.getFieldInstance(registryNames[0], registryName);
                if (field == null) {
                    this.say(sender, TextFormatting.RED + registryName + " does not exist");
                } else if (field.hasPermission(permissionLevel) || !field.enforce && !field.hide) {
                    this.say(sender, "Field " + field.name + "\n-----  -----\nFrom: " + field.config.getName() + "\nDefault Value: " + field.defaultValue + "\nCurrent Value: " + String.valueOf(field.getRealCachedValue()));
                } else {
                    this.say(sender, TextFormatting.RED + field.name + " requires a higher permission level to access");
                }
            } else {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74778_a("config", registryNames[0]);
                nbt.func_74778_a("field", registryName);
                this.sendPacket(1, nbt, sender);
            }
        } else {
            this.say(sender, TextFormatting.RED + registryName + " is not a valid registry name");
        }
    }

    private int getPermission(MinecraftServer server, ICommandSender sender) {
        return sender instanceof EntityPlayerMP ? (server.func_71264_H() ? 4 : server.func_184103_al().func_152603_m().func_187452_a(((EntityPlayerMP)sender).func_146103_bH())) : 4;
    }

    private void sendPacket(int index, NBTTagCompound nbt, ICommandSender sender) {
        if (!(sender instanceof EntityPlayerMP)) {
            this.say(sender, TextFormatting.RED + "You cannot run this sub command in the console");
            return;
        }
        nbt.func_74778_a("command", this.func_71517_b());
        NetworkHandler.sendClientPacket(index, nbt, sender);
    }

    private void say(ICommandSender sender, String message) {
        CommandConfigEX.func_152373_a((ICommandSender)sender, (ICommand)this, (String)message, (Object[])new Object[0]);
    }
}

