/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.configex.command;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.mrbt0907.configex.ConfigManager;
import net.mrbt0907.configex.ConfigModEX;
import net.mrbt0907.configex.manager.FieldInstance;

public class ClientCommandHandler {
    private static final Minecraft MC = Minecraft.func_71410_x();

    public static void onRecieveCommand(int index, NBTTagCompound nbt) {
        EntityPlayerSP player = ClientCommandHandler.MC.field_71439_g;
        if (player != null) {
            switch (index) {
                case 1: {
                    String[] args = new String[]{nbt.func_74779_i("config"), nbt.func_74779_i("field")};
                    FieldInstance field = ConfigManager.getFieldInstance(args[0], args[1]);
                    if (field == null) {
                        ClientCommandHandler.say(TextFormatting.RED + args[0] + ":" + args[1] + " does not exist");
                        break;
                    }
                    if (field.hasPermission() || !field.enforce && !field.hide) {
                        ClientCommandHandler.say("Field " + field.name + "\n-----  -----\nFrom: " + field.config.getName() + "\nDefault Value: " + field.defaultValue + "\nCurrent Value: " + String.valueOf(field.getRealCachedValue()));
                        break;
                    }
                    ClientCommandHandler.say(TextFormatting.RED + field.name + " requires a higher permission level to access");
                    break;
                }
                case 2: {
                    String[] args = new String[]{nbt.func_74779_i("config"), nbt.func_74779_i("field")};
                    FieldInstance field = ConfigManager.getFieldInstance(args[0], args[1]);
                    String value = nbt.func_74779_i("value");
                    if (field == null) {
                        ClientCommandHandler.say(TextFormatting.RED + args[0] + ":" + args[1] + " does not exist");
                        break;
                    }
                    if (field.hasPermission() || !field.enforce && !field.hide) {
                        if (!field.enforce || ConfigManager.isSinglePlayer()) {
                            if (field.setClientValue(value)) {
                                ConfigManager.save(field.config.getName(), field.registryName);
                                ClientCommandHandler.say(field.name + " was set successfully! Client Value: " + field.getRealClientValue() + ", Server Value: " + field.getRealCachedValue());
                                break;
                            }
                            ClientCommandHandler.say(TextFormatting.RED + field.name + " was not set successfully");
                            break;
                        }
                        ClientCommandHandler.say(TextFormatting.RED + field.name + " cannot be set client side while in the server");
                        break;
                    }
                    ClientCommandHandler.say(TextFormatting.RED + field.name + " requires a higher permission level to set");
                    break;
                }
                case 3: {
                    String[] args = new String[]{nbt.func_74779_i("config"), nbt.func_74779_i("field")};
                    FieldInstance field = ConfigManager.getFieldInstance(args[0], args[1]);
                    if (field == null) {
                        ClientCommandHandler.say(TextFormatting.RED + args[0] + ":" + args[1] + " does not exist");
                        break;
                    }
                    if (field.hasPermission() || !field.enforce && !field.hide) {
                        if (!field.enforce || MC.func_71356_B()) {
                            field.setToDefault();
                            ConfigManager.save(field.config.getName(), field.registryName);
                            ClientCommandHandler.say(field.name + " was set to default successfully! Client Value: " + field.getRealClientValue() + ", Server Value: " + field.getRealCachedValue());
                            break;
                        }
                        ClientCommandHandler.say(TextFormatting.RED + field.name + " cannot be set to default client side while in the server");
                        break;
                    }
                    ClientCommandHandler.say(TextFormatting.RED + field.name + " requires a higher permission level to set to default");
                    break;
                }
                default: {
                    ConfigModEX.warn("Client Command Handler recieved an invalid packet with index of " + index + ". Skipping...");
                    break;
                }
            }
        } else {
            ConfigModEX.warn("Packet " + index + " was rejected by the client command handler because player was null");
        }
    }

    private static void say(String message) {
        if (ClientCommandHandler.MC.field_71439_g == null) {
            return;
        }
        ClientCommandHandler.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(message));
    }
}

