/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.configex;

import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.mrbt0907.configex.ConfigManager;
import net.mrbt0907.configex.api.IConfigEX;
import net.mrbt0907.configex.command.CommandConfigEX;
import net.mrbt0907.configex.config.ConfigMaster;
import net.mrbt0907.configex.event.EventHandler;
import net.mrbt0907.configex.network.NetworkHandler;
import org.apache.logging.log4j.Logger;

@Mod(modid="configex", name="Config Manager - Expanded", version="1.0", acceptedMinecraftVersions="[1.12.2]", dependencies="required-after:forge@[14.23.5.2860,);", guiFactory="net.mrbt0907.configex.gui.AdvancedGuiFactory")
public class ConfigModEX {
    public static final String MODID = "configex";
    public static final String MOD = "Config Manager - Expanded";
    public static final String VERSION = "1.0";
    private static Logger log;
    public static final boolean enableDebug = false;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        log = event.getModLog();
        ConfigModEX.register(new ConfigMaster());
        MinecraftForge.EVENT_BUS.register(EventHandler.class);
        NetworkHandler.preInit();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandConfigEX());
    }

    public static IConfigEX register(IConfigEX config) {
        return ConfigManager.register(config);
    }

    public static String getGameFolder() {
        if (FMLCommonHandler.instance().getMinecraftServerInstance() == null || FMLCommonHandler.instance().getMinecraftServerInstance().func_71264_H()) {
            return FMLClientHandler.instance().getClient().field_71412_D.getPath() + File.separator;
        }
        return new File(".").getAbsolutePath() + File.separator;
    }

    public static void info(Object message) {
        log.info(message);
    }

    public static void debug(Object message) {
        boolean isDebug;
        boolean bl = ConfigMaster.debug_mode ? true : (isDebug = false);
        if (isDebug) {
            log.info("[DEBUG] " + message);
        }
    }

    public static void warn(Object message) {
        boolean isDebug;
        boolean bl = ConfigMaster.debug_mode ? true : (isDebug = false);
        if (isDebug) {
            log.warn(message);
        }
    }

    public static void error(Object message) {
        boolean isDebug;
        boolean bl = ConfigMaster.debug_mode ? true : (isDebug = false);
        if (isDebug) {
            Throwable exception = message instanceof Throwable ? (Throwable)message : new Exception(String.valueOf(message));
            exception.printStackTrace();
        }
    }

    public static void fatal(Object message) {
        Error error = message instanceof Error ? (Error)message : new Error(String.valueOf(message));
        throw error;
    }
}

