/*
 * Decompiled with CFR 0.152.
 */
package net.mrbt0907.configex;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.mrbt0907.configex.ConfigModEX;
import net.mrbt0907.configex.api.IConfigEX;
import net.mrbt0907.configex.manager.ConfigInstance;
import net.mrbt0907.configex.manager.FieldInstance;
import net.mrbt0907.configex.network.NetworkHandler;
import org.apache.commons.lang3.text.WordUtils;

public class ConfigManager {
    private static final Map<String, ConfigInstance> configs = new LinkedHashMap<String, ConfigInstance>();
    public static final boolean isRemote = FMLCommonHandler.instance().getSide().equals((Object)Side.CLIENT);

    public static void readNBT(NBTTagCompound nbt) {
        ConfigModEX.debug("Reading provided config nbt data...");
        NBTTagCompound nbtManager = nbt.func_74775_l("manager");
        nbtManager.func_150296_c().forEach(key -> {
            ConfigInstance instance = configs.get(key);
            if (instance == null) {
                ConfigModEX.error(new NullPointerException("Recieved a non-existant nbt entry for configs. Skipping..."));
            } else {
                NBTTagCompound nbtConfig = nbtManager.func_74775_l(key);
                if (!isRemote) {
                    if (nbt.func_186855_b("player")) {
                        nbtConfig.func_186854_a("player", nbt.func_186857_a("player"));
                    }
                } else {
                    nbtConfig.func_74757_a("setClient", nbt.func_74767_n("setClient"));
                }
                instance.readNBT(nbtConfig);
            }
        });
        ConfigModEX.debug("Finished reading config nbt data");
        if (!isRemote) {
            ConfigModEX.debug("Sending nbt data back to all clients");
            NetworkHandler.sendClientPacket(0, ConfigManager.writeNBT(new NBTTagCompound()), new Object[0]);
        }
    }

    public static NBTTagCompound writeNBT(NBTTagCompound nbt) {
        ConfigModEX.debug("Writing config nbt data for processing...");
        NBTTagCompound nbtManager = new NBTTagCompound();
        configs.forEach((name, config) -> {
            NBTTagCompound nbtConfig = new NBTTagCompound();
            config.writeNBT(nbtConfig);
            nbtManager.func_74782_a(name, (NBTBase)nbtConfig);
        });
        ConfigModEX.debug("Finished writing config nbt data");
        nbt.func_74782_a("manager", (NBTBase)nbtManager);
        return nbt;
    }

    public static FieldInstance getFieldInstance(String configName, String fieldName) {
        configName = ConfigManager.formatRegistryName(configName);
        fieldName = ConfigManager.formatRegistryName(fieldName);
        ConfigInstance instance = configs.get(configName);
        if (instance == null) {
            ConfigModEX.error(new NullPointerException("Config instance was null. Skipping..."));
            return null;
        }
        return instance.getField(fieldName);
    }

    public static List<FieldInstance> getFieldInstances(String configName) {
        ConfigInstance instance = configs.get(configName = ConfigManager.formatRegistryName(configName));
        if (instance == null) {
            ConfigModEX.error(new NullPointerException("Config instance was null. Skipping..."));
            return null;
        }
        return instance.getFields();
    }

    public static ConfigInstance getInstance(IConfigEX config) {
        return ConfigManager.getInstance(config.getName());
    }

    public static ConfigInstance getInstance(String configName) {
        return configs.get(ConfigManager.formatRegistryName(configName));
    }

    public static List<ConfigInstance> getInstances() {
        return new ArrayList<ConfigInstance>(configs.values());
    }

    public static void save() {
        ConfigModEX.debug("Requested save of all configurations");
        configs.forEach((name, instance) -> ConfigManager.save(name, null));
    }

    public static void save(String configID) {
        ConfigManager.save(configID, null);
    }

    public static void save(String configID, String variableName) {
        configID = ConfigManager.formatRegistryName(configID);
        ConfigModEX.debug("Requested save of configuration " + configID);
        ConfigInstance instance = configs.get(configID);
        if (instance == null) {
            ConfigModEX.error(new NullPointerException("Config instance was null. Skipping..."));
            return;
        }
        if (variableName == null) {
            instance.updateAllFields(true);
        } else {
            FieldInstance field = instance.getField(variableName);
            if (field == null) {
                ConfigModEX.error(new NullPointerException("Field instance was null. Skipping..."));
                return;
            }
            instance.updateField(field, false);
        }
        instance.writeConfigFile(false);
        if (!isRemote) {
            ConfigModEX.debug("Sending information to all clients...");
            NetworkHandler.sendClientPacket(0, ConfigManager.writeNBT(new NBTTagCompound()), new Object[0]);
        }
    }

    public static void load() {
        ConfigModEX.debug("Requested load of all configurations");
        configs.forEach((name, instance) -> instance.readConfigFile());
        if (!isRemote) {
            ConfigModEX.debug("Sending information to all clients...");
            NetworkHandler.sendClientPacket(0, ConfigManager.writeNBT(new NBTTagCompound()), new Object[0]);
        }
    }

    public static void load(String configID) {
        configID = ConfigManager.formatRegistryName(configID);
        ConfigModEX.debug("Requested load of configuration " + configID);
        ConfigInstance instance = configs.get(configID);
        if (instance == null) {
            ConfigModEX.error(new NullPointerException("Config instance was null. Skipping..."));
            return;
        }
        instance.readConfigFile();
        if (!isRemote) {
            ConfigModEX.debug("Sending information to all clients...");
            NetworkHandler.sendClientPacket(0, ConfigManager.writeNBT(new NBTTagCompound()), new Object[0]);
        }
    }

    public static IConfigEX register(IConfigEX config) {
        if (config == null) {
            ConfigModEX.fatal(new NullPointerException("Config instance was null"));
        } else if (config.getName() == null) {
            ConfigModEX.fatal(new NullPointerException("Config instance has a null name"));
        } else if (config.getSaveLocation() == null) {
            ConfigModEX.fatal(new NullPointerException("Config instance has a null save location"));
        } else if (configs.containsKey(ConfigManager.formatRegistryName(config.getName()))) {
            ConfigModEX.error(new IllegalArgumentException("Config instance was already registered. Skipping..."));
            return null;
        }
        ConfigInstance instance = new ConfigInstance(config);
        configs.put(instance.registryName, instance);
        ConfigModEX.info("Registered config " + config.getName());
        return config;
    }

    public static int size() {
        return configs.size();
    }

    public static int sizeFields() {
        int size = 0;
        for (ConfigInstance config : configs.values()) {
            size += config.size();
        }
        return size;
    }

    public static void reset(boolean fullReset) {
        if (isRemote) {
            ConfigModEX.debug("Resetting all config values to orignal values...");
            configs.forEach((name, config) -> config.reset(fullReset));
            return;
        }
        ConfigModEX.error("Cannot reset variables server side. Skipping call...");
    }

    public static int getPermissionLevel() {
        return ConfigManager.getPermissionLevel(null);
    }

    public static int getPermissionLevel(UUID uuid) {
        if (isRemote) {
            FMLClientHandler handler = FMLClientHandler.instance();
            return handler.getClientPlayerEntity() == null ? 4 : handler.getClientPlayerEntity().func_184840_I();
        }
        if (uuid == null) {
            return 4;
        }
        PlayerList players = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
        EntityPlayerMP player = players.func_177451_a(uuid);
        return player == null ? 0 : players.func_152603_m().func_187452_a(player.func_146103_bH());
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isSinglePlayer() {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.func_71356_B() || mc.field_71441_e == null;
    }

    public static String[] getFieldIDs() {
        ArrayList<String> ids = new ArrayList<String>();
        for (ConfigInstance config : configs.values()) {
            for (FieldInstance field : config.getFields()) {
                ids.add(field.registryName);
            }
        }
        String[] output = new String[ids.size()];
        output = ids.toArray(output);
        return output;
    }

    public static String formatRegistryName(String name) {
        return name.trim().toLowerCase().replaceAll("[ _\\-]+", "_").replaceAll("[^a-zA-Z0-9_:]", "");
    }

    public static String formatComment(String comment) {
        return ConfigManager.formatComment(new String[]{comment});
    }

    public static String formatComment(String[] comment) {
        String output = "";
        for (String line : comment) {
            output = output.isEmpty() ? line : output + Configuration.NEW_LINE + line;
        }
        return output.isEmpty() ? null : output;
    }

    public static String formatCommentForCFG(FieldInstance field) {
        if (field.comment == null) {
            return null;
        }
        return (field.comment.isEmpty() ? "" : field.comment + Configuration.NEW_LINE) + (field.type < 6 ? "Minimum: \"" + (field.type < 4 ? String.format("%d", (long)field.min) : Double.valueOf(field.min)) + "\",  Maximum: \"" + (field.type < 4 ? String.format("%d", (long)field.max) : Double.valueOf(field.max)) + "\"" + Configuration.NEW_LINE : "") + "Default: \"" + field.defaultValue + "\"";
    }

    public static String formatCommentForGui(String comment, String defaultValue, int type, boolean showMin, boolean showMax, double min, double max) {
        String input;
        if (comment == null) {
            return null;
        }
        try {
            input = WordUtils.wrap((String)comment, (int)40);
        }
        catch (Exception e) {
            input = comment;
        }
        return (comment.isEmpty() ? "" : input + Configuration.NEW_LINE) + (type < 6 ? (showMin ? TextFormatting.YELLOW + "Minimum: " + (type < 4 ? String.format("%d", (long)min) : Double.valueOf(min)) + (showMax ? ",  " : Configuration.NEW_LINE) : "") + (showMax ? TextFormatting.YELLOW + "Maximum: " + (type < 4 ? String.format("%d", (long)max) : Double.valueOf(max)) + "" + Configuration.NEW_LINE : "") : "") + TextFormatting.GOLD + "Default: " + defaultValue;
    }
}

