/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.item;

import java.util.List;
import javax.annotation.Nullable;
import net.malisis.core.MalisisCore;
import net.malisis.core.block.IRegisterable;
import net.malisis.core.inventory.MalisisTab;
import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.provider.IIconProvider;
import net.malisis.doors.DoorDescriptor;
import net.malisis.doors.renderer.DoorRenderer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MalisisRendered(item=DoorRenderer.class)
public class DoorItem
extends ItemDoor
implements IRegisterable<Item>,
IIconProvider {
    protected DoorDescriptor descriptor;
    @SideOnly(value=Side.CLIENT)
    protected Icon icon;

    public DoorItem(DoorDescriptor desc) {
        super(desc.getBlock());
        this.descriptor = desc;
        this.field_77777_bU = desc.getMaxStackSize();
        this.setName(desc.getRegistryName());
        this.func_77655_b(desc.getUnlocalizedName());
        this.setCreativeTab(desc.getTab());
        if (MalisisCore.isClient() && this.descriptor.getTextureName() != null) {
            this.icon = Icon.from((String)(this.descriptor.getModId() + ":items/" + this.descriptor.getTextureName()));
        }
    }

    public DoorItem() {
        super(null);
    }

    public DoorDescriptor getDescriptor(ItemStack itemStack) {
        return this.descriptor;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon() {
        return this.icon;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        Block block;
        if (side != EnumFacing.UP) {
            return EnumActionResult.FAIL;
        }
        ItemStack itemStack = player.func_184586_b(hand);
        IBlockState state = world.func_180495_p(pos);
        if (!state.func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177984_a();
        }
        if ((block = this.getDescriptor(itemStack).getBlock()) == null) {
            MalisisCore.log.error("Can't place Door : block is null for " + itemStack);
            return EnumActionResult.FAIL;
        }
        if (!player.func_175151_a(pos, side, itemStack) || !player.func_175151_a(pos.func_177984_a(), side, itemStack)) {
            return EnumActionResult.FAIL;
        }
        if (!block.func_176196_c(world, pos)) {
            return EnumActionResult.FAIL;
        }
        DoorItem.func_179235_a((World)world, (BlockPos)pos, (EnumFacing)EnumFacing.func_176733_a((double)player.field_70177_z), (Block)block, (boolean)false);
        itemStack.func_190918_g(1);
        block.func_180633_a(world, pos, world.func_180495_p(pos), (EntityLivingBase)player, itemStack);
        return EnumActionResult.SUCCESS;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77978_p() == null) {
            return;
        }
        tooltip.add(TextFormatting.WHITE + I18n.func_135052_a((String)("door_movement." + stack.func_77978_p().func_74779_i("movement")), (Object[])new Object[0]));
    }

    public DoorItem setCreativeTab(CreativeTabs tab) {
        super.func_77637_a(tab);
        if (tab instanceof MalisisTab) {
            ((MalisisTab)tab).addItem((Item)this);
        }
        return this;
    }
}

