/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.gui;

import com.google.common.eventbus.Subscribe;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.interaction.UIButton;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.renderer.font.FontOptions;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.gui.DigicodeGui;
import net.malisis.doors.network.DigicodeMessage;
import org.apache.commons.lang3.StringUtils;

public class Digicode
extends UIContainer<Digicode> {
    private String enteredCode = "";
    private String expectedCode = null;
    private FontOptions fontOptions = FontOptions.builder().scale(2.0f).color(52224).build();
    private FontOptions bgFontOptions = FontOptions.builder().scale(2.0f).color(13056).build();

    public Digicode(MalisisGui gui, String expected) {
        super(gui);
        this.setSize(50, 80);
        this.expectedCode = expected;
        this.createButtons(gui);
    }

    public Digicode(MalisisGui gui) {
        this(gui, null);
    }

    public String getExpectedCode() {
        return this.expectedCode;
    }

    public String getEnteredCode() {
        return this.enteredCode;
    }

    public Digicode setEnteredCode(String code) {
        if (code.length() > 6) {
            code = code.substring(0, 6);
        }
        this.enteredCode = code;
        this.fireEvent(new CodeChangeEvent(this));
        return this;
    }

    public boolean isValidCode() {
        return !StringUtils.isEmpty((CharSequence)this.expectedCode) && this.expectedCode.equals(this.enteredCode);
    }

    private void createButtons(MalisisGui gui) {
        int oy = 16;
        int h = 14;
        for (int i = 1; i <= 9; ++i) {
            int x = (i - 1) % 3 * 17;
            int y = (i - 1) / 3 * (h + 2);
            UIButton b = (UIButton)new UIButton(gui, "" + i).setSize(16, h).setPosition(x, oy + y);
            b.setName("" + i);
            this.add(new UIComponent[]{b});
        }
        this.add(new UIComponent[]{((UIButton)new UIButton(gui, "C").setSize(16, h).setPosition(0, oy + 3 * (h + 2))).setName("C")});
        this.add(new UIComponent[]{((UIButton)new UIButton(gui, "0").setSize(16, h).setPosition(17, oy + 3 * (h + 2))).setName("0")});
        if (!StringUtils.isEmpty((CharSequence)this.expectedCode)) {
            this.add(new UIComponent[]{((UIButton)new UIButton(gui, "V").setSize(16, h).setPosition(34, oy + 3 * (h + 2))).setName("V")});
        }
    }

    public boolean onKeyTyped(char keyChar, int keyCode) {
        if (keyChar >= '0' && keyChar <= '9' && this.enteredCode.length() < 6) {
            this.setEnteredCode(this.enteredCode + keyChar);
            return true;
        }
        if (keyCode == 14 && this.enteredCode.length() > 0) {
            this.setEnteredCode(this.enteredCode.substring(0, this.enteredCode.length() - 1));
            return true;
        }
        return super.onKeyTyped(keyChar, keyCode);
    }

    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
    }

    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        super.drawForeground(renderer, mouseX, mouseY, partialTick);
        String code = StringUtils.repeat((char)' ', (int)(6 - this.enteredCode.length())) + this.enteredCode;
        renderer.currentComponent = this;
        renderer.drawRectangle(0, 0, 0, this.getWidth(), 15, 0x191919, 255);
        renderer.drawText(MalisisDoors.digitalFont, "888888", this.bgFontOptions);
        renderer.drawText(MalisisDoors.digitalFont, code, this.fontOptions);
    }

    @Subscribe
    public void onButtonClick(UIButton.ClickEvent event) {
        switch (((UIButton)event.getComponent()).getName()) {
            case "C": {
                this.setEnteredCode("");
                break;
            }
            case "V": {
                if (!this.isValidCode()) break;
                this.getGui().close();
                DigicodeMessage.send(((DigicodeGui)this.getGui()).te);
                break;
            }
            default: {
                this.setEnteredCode(this.enteredCode + ((UIButton)event.getComponent()).getName());
            }
        }
    }

    public static class CodeChangeEvent
    extends ComponentEvent<Digicode> {
        private String code;

        public CodeChangeEvent(Digicode digicode) {
            super((UIComponent)digicode);
            this.code = digicode.getEnteredCode();
        }

        public String getCode() {
            return this.code;
        }
    }
}

