/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.bigdoors;

import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.bigdoors.Door3x3;
import net.malisis.doors.bigdoors.Door3x3Tile;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.minecraft.util.EnumFacing;

public class Door3x3Renderer
extends MalisisRenderer<Door3x3Tile> {
    private MalisisModel model;
    private RenderParameters rp;
    private AnimationRenderer ar = new AnimationRenderer();

    public Door3x3Renderer() {
        this.registerFor(Door3x3Tile.class);
        this.ensureBlock(new Class[]{Door3x3.class});
        this.getBlockDamage = true;
    }

    protected void initialize() {
        Cube doorLeft = new Cube();
        doorLeft.setSize(0.5f, 3.0f, 0.06229236f);
        doorLeft.interpolateUV();
        doorLeft.setSize(1.5f, 3.0f, 0.1875f);
        doorLeft.scale(1.0f, 1.0f, 0.995f);
        doorLeft.translate(-1.0f, 0.0f, 0.8125f);
        Cube doorRight = new Cube();
        doorRight.setSize(1.0f, 3.0f, 0.06229236f);
        doorRight.limit(0.5, 0.0, 0.0, 1.0, 3.0, 0.1875);
        doorRight.interpolateUV();
        doorRight.setSize(1.5f, 3.0f, 0.1875f);
        doorRight.scale(1.0f, 1.0f, 0.995f);
        doorRight.translate(0.0f, 0.0f, 0.8125f);
        this.model = new MalisisModel();
        this.model.addShape("left", (Shape)doorLeft);
        this.model.addShape("right", (Shape)doorRight);
        this.model.storeState();
        this.rp = new RenderParameters();
        this.rp.useBlockBounds.set((Object)false);
        this.rp.interpolateUV.set((Object)false);
    }

    public void render() {
        if (this.tileEntity == null) {
            return;
        }
        this.setup();
        if (this.renderType == RenderType.TILE_ENTITY) {
            this.renderTileEntity();
        }
    }

    private void renderTileEntity() {
        this.ar.setStartTime(((Door3x3Tile)this.tileEntity).getTimer().getStart());
        if (((Door3x3Tile)this.tileEntity).getMovement() != null) {
            Animation<?>[] anims = ((Door3x3Tile)this.tileEntity).getMovement().getAnimations((DoorTileEntity)this.tileEntity, this.model, this.rp);
            this.ar.animate(anims);
        }
        this.model.render((MalisisRenderer)this, this.rp);
    }

    private void setup() {
        this.model.resetState();
        EnumFacing direction = ((Door3x3Tile)this.tileEntity).getDirection();
        if (direction == EnumFacing.NORTH) {
            this.model.rotate(180.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        } else if (direction == EnumFacing.WEST) {
            this.model.rotate(-90.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        } else if (direction == EnumFacing.EAST) {
            this.model.rotate(90.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        this.rp.brightness.set((Object)this.blockState.func_185889_a(this.world, this.pos));
    }
}

