/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.bigdoors;

import java.util.ArrayList;
import java.util.List;
import net.malisis.core.MalisisCore;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.renderer.DefaultRenderer;
import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.provider.IBlockIconProvider;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.MBlockState;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.core.util.chunkcollision.ChunkCollision;
import net.malisis.core.util.chunkcollision.IChunkCollidable;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.bigdoors.Door3x3Renderer;
import net.malisis.doors.bigdoors.Door3x3Tile;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@MalisisRendered(block=Door3x3Renderer.class, item=DefaultRenderer.Item.class)
public class Door3x3
extends MalisisBlock
implements ITileEntityProvider,
IChunkCollidable {
    private Type type;
    private AxisAlignedBB defaultBoundingBox = new AxisAlignedBB(-1.0, 0.0, 0.8125, 2.0, 3.0, 1.0);

    public Door3x3(Type type) {
        super(type.metal ? Material.field_151573_f : Material.field_151575_d);
        this.type = type;
        this.setName(type.name);
        this.func_149752_b(type.metal ? 200.0f : 10.0f);
        this.func_149672_a(type.metal ? SoundType.field_185852_e : SoundType.field_185848_a);
        this.setCreativeTab((CreativeTabs)MalisisDoors.tab);
        this.addComponent((IComponent)new DirectionalComponent());
        if (MalisisCore.isClient()) {
            this.addComponent((IComponent)Door3x3IconProvider.get(type));
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack itemStack) {
        super.func_180633_a(world, pos, state, player, itemStack);
        ChunkCollision.get().replaceBlocks(world, new MBlockState((IBlockAccess)world, pos));
        Door3x3Tile te = (Door3x3Tile)((Object)TileEntityUtils.getTileEntity(Door3x3Tile.class, (IBlockAccess)world, (BlockPos)pos));
        if (te != null) {
            te.setFrameState(MBlockState.fromNBT((NBTTagCompound)itemStack.func_77978_p()));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        Door3x3Tile te = (Door3x3Tile)((Object)TileEntityUtils.getTileEntity(Door3x3Tile.class, (IBlockAccess)world, (BlockPos)pos));
        if (te == null) {
            return true;
        }
        te.openOrCloseDoor();
        return true;
    }

    public AxisAlignedBB[] getBoundingBoxes(IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        if (type == BoundingBoxType.PLACEDBOUNDINGBOX) {
            return new AxisAlignedBB[]{this.defaultBoundingBox};
        }
        Door3x3Tile te = (Door3x3Tile)((Object)TileEntityUtils.getTileEntity(Door3x3Tile.class, (IBlockAccess)world, (BlockPos)pos));
        if (te == null) {
            return AABBUtils.identities();
        }
        AxisAlignedBB[] aabbs = new AxisAlignedBB[]{this.defaultBoundingBox};
        if ((type == BoundingBoxType.COLLISION || type == BoundingBoxType.RAYTRACE || type == BoundingBoxType.RENDER) && (te.isOpened() || te.isMoving())) {
            aabbs = new AxisAlignedBB[]{new AxisAlignedBB(-1.0, 0.0, -0.5, -0.8125, 3.0, 1.0), new AxisAlignedBB(1.8125, 0.0, -0.5, 2.0, 3.0, 1.0)};
        }
        return aabbs;
    }

    public int blockRange() {
        return 3;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new Door3x3Tile(this.type.metal);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        Door3x3Tile te;
        if (!player.field_71075_bZ.field_75098_d && (te = (Door3x3Tile)((Object)TileEntityUtils.getTileEntity(Door3x3Tile.class, (IBlockAccess)world, (BlockPos)pos))) != null) {
            Door3x3.func_180635_a((World)world, (BlockPos)pos, (ItemStack)te.getDroppedItemStack());
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighbor, BlockPos fromPos) {
        Door3x3Tile te = (Door3x3Tile)((Object)TileEntityUtils.getTileEntity(Door3x3Tile.class, (IBlockAccess)world, (BlockPos)pos));
        if (te == null) {
            return;
        }
        boolean powered = world.func_175640_z(pos);
        if (powered || neighbor.func_176223_P().func_185897_m()) {
            te.setPowered(powered);
        }
    }

    public static class Door3x3IconProvider
    implements IBlockIconProvider {
        Icon itemIcon;
        Icon doorIcon;

        public Door3x3IconProvider(Type type) {
            this.itemIcon = Icon.from((String)("malisisdoors:items/" + type.name));
            this.doorIcon = Icon.from((String)("malisisdoors:blocks/" + type.name));
        }

        public Icon getIcon(IBlockState state, EnumFacing side) {
            return this.doorIcon;
        }

        public Icon getIcon(ItemStack itemStack, EnumFacing side) {
            return this.doorIcon;
        }

        public static Door3x3IconProvider get(Type type) {
            return new Door3x3IconProvider(type);
        }
    }

    public static enum Type {
        OAK("big_door_oak_3x3", false),
        SPRUCE("big_door_spruce_3x3", false),
        BIRCH("big_door_birch_3x3", false),
        JUNGLE("big_door_jungle_3x3", false),
        ACACIA("big_door_acacia_3x3", false),
        DARK_OAK("big_door_dark_oak_3x3", false),
        IRON("big_door_iron_3x3", true),
        RUSTY("big_door_rusty_3x3", true);

        public String name;
        public boolean metal;

        private Type(String name, boolean metal) {
            this.name = name;
            this.metal = metal;
        }
    }
}

