/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.util;

import CoroUtil.config.ConfigCoroUtilAdvanced;
import CoroUtil.difficulty.UtilEntityBuffs;
import CoroUtil.forge.CULog;
import CoroUtil.util.CoroUtilCompatibility;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class CoroUtilCrossMod {
    private static boolean checkHasInfernalMobs = true;
    private static boolean hasInfernalMobs = false;
    private static Class class_IM_InfernalMobsCore = null;
    private static Method method_IM_instance = null;
    private static Method method_IM_addEntityModifiersByString = null;
    private static Method method_IM_removeEntFromElites = null;
    private static boolean checkHasGameStages = true;
    private static boolean hasGameStages = false;
    private static Class class_GS_GameStageHelper = null;
    private static Method method_GS_hasAnyOf = null;
    private static Method method_GS_hasAllOf = null;
    public static List<String> listModifiers = new ArrayList<String>();

    public static boolean hasInfernalMobs() {
        if (!checkHasInfernalMobs) {
            return hasInfernalMobs;
        }
        checkHasInfernalMobs = false;
        try {
            class_IM_InfernalMobsCore = Class.forName("atomicstryker.infernalmobs.common.InfernalMobsCore");
            if (class_IM_InfernalMobsCore != null) {
                hasInfernalMobs = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        CULog.log("CoroUtil detected Infernal Mobs " + (hasInfernalMobs ? "Installed" : "Not Installed") + " for use");
        return hasInfernalMobs;
    }

    public static boolean infernalMobs_AddRandomModifiers(EntityLivingBase ent, List<String> listModifiersToUse, int modifierCount) {
        int i;
        String listMods = "";
        CULog.dbg("infernalMobs_AddRandomModifiers perform:");
        if (modifierCount >= listModifiersToUse.size()) {
            modifierCount = listModifiersToUse.size() - 1;
        }
        CULog.dbg("modifierCount: " + modifierCount);
        CULog.dbg("listModifiersToUse size: " + listModifiersToUse.size());
        ArrayList<Integer> listInts = new ArrayList<Integer>();
        for (i = 0; i < listModifiersToUse.size(); ++i) {
            listInts.add(i);
        }
        Collections.shuffle(listInts);
        for (i = 0; i < modifierCount; ++i) {
            listMods = listMods + listModifiersToUse.get((Integer)listInts.get(i)) + " ";
        }
        CULog.dbg("listMods final: " + listMods);
        if (!listMods.equals("")) {
            return CoroUtilCrossMod.infernalMobs_AddModifiers(ent, listMods);
        }
        return true;
    }

    public static boolean infernalMobs_AddModifiers(EntityLivingBase ent, String modifiers) {
        if (!CoroUtilCrossMod.hasInfernalMobs()) {
            return false;
        }
        try {
            if (method_IM_instance == null) {
                method_IM_instance = class_IM_InfernalMobsCore.getDeclaredMethod("instance", new Class[0]);
            }
            Object obj = method_IM_instance.invoke(null, new Object[0]);
            if (method_IM_addEntityModifiersByString == null) {
                method_IM_addEntityModifiersByString = obj.getClass().getDeclaredMethod("addEntityModifiersByString", EntityLivingBase.class, String.class);
            }
            method_IM_addEntityModifiersByString.invoke(obj, ent, modifiers);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            hasInfernalMobs = false;
            return false;
        }
    }

    public static boolean infernalMobs_RemoveAllModifiers(EntityLivingBase ent) {
        if (!CoroUtilCrossMod.hasInfernalMobs()) {
            return false;
        }
        try {
            if (method_IM_removeEntFromElites == null) {
                method_IM_removeEntFromElites = class_IM_InfernalMobsCore.getDeclaredMethod("removeEntFromElites", EntityLivingBase.class);
            }
            method_IM_removeEntFromElites.invoke(null, ent);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            hasInfernalMobs = false;
            return false;
        }
    }

    public static void processSpawnOverride(EntityJoinWorldEvent event) {
        EntityLivingBase ent;
        if (!CoroUtilCrossMod.hasInfernalMobs()) {
            return;
        }
        if (!ConfigCoroUtilAdvanced.difficulty_OverrideInfernalMobs) {
            return;
        }
        if (!CoroUtilCompatibility.isHWMonstersInstalled()) {
            return;
        }
        String infernalNBTString = "InfernalMobsMod";
        if (event.getEntity() instanceof EntityLivingBase && (ent = (EntityLivingBase)event.getEntity()).getEntityData().func_74764_b(infernalNBTString) && !ent.getEntityData().func_74775_l(UtilEntityBuffs.dataEntityBuffed_Data).func_74767_n(UtilEntityBuffs.dataEntityBuffed_AI_Infernal)) {
            CULog.dbg("detected infernal mob, overriding its attributes for " + event.getEntity().func_70005_c_());
            CoroUtilCrossMod.infernalMobs_RemoveAllModifiers(ent);
            ent.getEntityData().func_82580_o(infernalNBTString);
        }
    }

    public static boolean hasGameStages() {
        if (!checkHasGameStages) {
            return hasGameStages;
        }
        checkHasGameStages = false;
        try {
            class_GS_GameStageHelper = Class.forName("net.darkhax.gamestages.GameStageHelper");
            if (class_GS_GameStageHelper != null) {
                hasGameStages = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        CULog.log("CoroUtil detected GameStages mod " + (hasGameStages ? "Installed" : "Not Installed") + " for use");
        return hasGameStages;
    }

    public static boolean gameStages_hasStages(EntityPlayer player, List<String> stages, boolean matchAllOf) {
        if (!CoroUtilCrossMod.hasGameStages()) {
            return false;
        }
        if (matchAllOf) {
            try {
                if (method_GS_hasAllOf == null) {
                    method_GS_hasAllOf = class_GS_GameStageHelper.getDeclaredMethod("hasAllOf", EntityPlayer.class, Collection.class);
                }
                return (Boolean)method_GS_hasAllOf.invoke(null, player, stages);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                hasGameStages = false;
            }
        } else {
            try {
                if (method_GS_hasAnyOf == null) {
                    method_GS_hasAnyOf = class_GS_GameStageHelper.getDeclaredMethod("hasAnyOf", EntityPlayer.class, Collection.class);
                }
                return (Boolean)method_GS_hasAnyOf.invoke(null, player, stages);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                hasGameStages = false;
            }
        }
        return false;
    }

    static {
        listModifiers.add("1UP");
        listModifiers.add("Alchemist");
        listModifiers.add("Berserk");
        listModifiers.add("Blastoff");
        listModifiers.add("Bulwark");
        listModifiers.add("Choke");
        listModifiers.add("Cloaking");
        listModifiers.add("Darkness");
        listModifiers.add("Ender");
        listModifiers.add("Exhaust");
        listModifiers.add("Fiery");
        listModifiers.add("Ghastly");
        listModifiers.add("Gravity");
        listModifiers.add("LifeSteal");
        listModifiers.add("Ninja");
        listModifiers.add("Poisonous");
        listModifiers.add("Quicksand");
        listModifiers.add("Regen");
        listModifiers.add("Rust");
        listModifiers.add("Sapper");
        listModifiers.add("Sprint");
        listModifiers.add("Sticky");
        listModifiers.add("Storm");
        listModifiers.add("Vengeance");
        listModifiers.add("Weakness");
        listModifiers.add("Webber");
        listModifiers.add("Wither");
    }
}

