/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.forge;

import CoroUtil.client.debug.DebugRenderEntry;
import CoroUtil.client.debug.DebugRenderer;
import CoroUtil.packet.INBTPacketHandler;
import CoroUtil.packet.PacketHelper;
import CoroUtil.util.UtilMining;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventHandlerPacket {
    @SideOnly(value=Side.CLIENT)
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @SideOnly(value=Side.CLIENT)
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @SideOnly(value=Side.CLIENT)
    public INBTPacketHandler getClientDataInterface() {
        if (Minecraft.func_71410_x().field_71462_r instanceof INBTPacketHandler) {
            return (INBTPacketHandler)Minecraft.func_71410_x().field_71462_r;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPacketFromServer(FMLNetworkEvent.ClientCustomPacketEvent event) {
        try {
            NBTTagCompound nbt = PacketHelper.readNBTTagCompound(event.getPacket().payload());
            String command = nbt.func_74779_i("command");
            if (command.equals("Ent_Motion")) {
                int entID = nbt.func_74762_e("entityID");
                Minecraft.func_71410_x().func_152344_a(() -> {
                    Entity entity = this.getClientWorld().func_73045_a(entID);
                    if (entity != null) {
                        entity.field_70159_w += nbt.func_74769_h("motionX");
                        entity.field_70181_x += nbt.func_74769_h("motionY");
                        entity.field_70179_y += nbt.func_74769_h("motionZ");
                    }
                });
            } else if (command.equals("UpdateBlockList")) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    WorldClient world = Minecraft.func_71410_x().field_71441_e;
                    if (world == null) {
                        return;
                    }
                    String blacklistMineable_RegularBlocks = nbt.func_74779_i("blacklistRepairable_RegularBlocks");
                    String whitelistMineable_TileEntities = nbt.func_74779_i("whitelistMineable_TileEntities");
                    UtilMining.ClientData.listBlocksBlacklistedRepairing.clear();
                    UtilMining.ClientData.listTileEntitiesWhitelistedBreakable.clear();
                    UtilMining.processBlockBlacklist(blacklistMineable_RegularBlocks, UtilMining.ClientData.listBlocksBlacklistedRepairing);
                    UtilMining.processBlockBlacklist(whitelistMineable_TileEntities, UtilMining.ClientData.listTileEntitiesWhitelistedBreakable);
                });
            } else if (command.equals("DebugRender")) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    WorldClient world = Minecraft.func_71410_x().field_71441_e;
                    if (world == null) {
                        return;
                    }
                    BlockPos pos = new BlockPos(nbt.func_74762_e("posX"), nbt.func_74762_e("posY"), nbt.func_74762_e("posZ"));
                    DebugRenderEntry entry = new DebugRenderEntry(pos, world.func_82737_E() + (long)nbt.func_74762_e("time"), nbt.func_74762_e("color"));
                    DebugRenderer.addRenderable(entry);
                });
            } else if (command.equals("DebugRenderClear")) {
                Minecraft.func_71410_x().func_152344_a(() -> DebugRenderer.clearRenderables());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

