/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.item;

import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import com.mrcrayfish.guns.GunConfig;
import com.mrcrayfish.guns.ItemStackUtil;
import com.mrcrayfish.guns.MrCrayfishGunMod;
import com.mrcrayfish.guns.common.ProjectileFactory;
import com.mrcrayfish.guns.common.SpreadHandler;
import com.mrcrayfish.guns.entity.EntityProjectile;
import com.mrcrayfish.guns.event.CommonEvents;
import com.mrcrayfish.guns.init.ModGuns;
import com.mrcrayfish.guns.init.ModSounds;
import com.mrcrayfish.guns.item.AmmoRegistry;
import com.mrcrayfish.guns.item.GunRegistry;
import com.mrcrayfish.guns.item.IAttachment;
import com.mrcrayfish.guns.item.ItemAmmo;
import com.mrcrayfish.guns.item.ItemColored;
import com.mrcrayfish.guns.network.PacketHandler;
import com.mrcrayfish.guns.network.message.MessageBullet;
import com.mrcrayfish.guns.network.message.MessageMuzzleFlash;
import com.mrcrayfish.guns.network.message.MessageShoot;
import com.mrcrayfish.guns.object.Gun;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Beta
public class ItemGun
extends ItemColored {
    private Gun gun;
    private static final Predicate<EntityLivingBase> NOT_AGGRO_EXEMPT = entity -> !(entity instanceof EntityPlayer) && !GunConfig.AggroMobs.exemptClasses.contains(entity.getClass());

    public ItemGun(ResourceLocation id) {
        this.func_77655_b(id.func_110624_b() + "." + id.func_110623_a());
        this.setRegistryName(id);
        this.func_77625_d(1);
        GunRegistry.getInstance().register(this);
    }

    void setGun(Gun gun) {
        this.gun = gun;
    }

    public Gun getGun() {
        return this.gun;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Gun modifiedGun = this.getModifiedGun(stack);
        String additionalDamageText = "";
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_150297_b("AdditionalDamage", 5)) {
            float additionalDamage = tagCompound.func_74760_g("AdditionalDamage");
            if (additionalDamage > 0.0f) {
                additionalDamageText = TextFormatting.GREEN + " +" + tagCompound.func_74760_g("AdditionalDamage");
            } else if (additionalDamage < 0.0f) {
                additionalDamageText = TextFormatting.RED + " " + tagCompound.func_74760_g("AdditionalDamage");
            }
        }
        tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.cgm.damage", (Object[])new Object[]{TextFormatting.RESET + Float.toString(this.gun.projectile.getDamage(modifiedGun)) + additionalDamageText}));
        if (tagCompound != null) {
            if (tagCompound.func_74767_n("IgnoreAmmo")) {
                tooltip.add(TextFormatting.AQUA + I18n.func_135052_a((String)"info.cgm.ignore_ammo", (Object[])new Object[0]));
            } else {
                int ammoCount = tagCompound.func_74762_e("AmmoCount");
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.cgm.ammo", (Object[])new Object[]{TextFormatting.RESET + Integer.toString(ammoCount), this.gun.general.getMaxAmmo(modifiedGun)}));
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return true;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entity, int count) {
        CooldownTracker tracker;
        Gun modifiedGun = this.getModifiedGun(stack);
        if (!modifiedGun.general.auto) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (!player.field_70170_p.field_72995_K) {
            return;
        }
        if ((ItemGun.hasAmmo(stack) || player.field_71075_bZ.field_75098_d) && !(tracker = player.func_184811_cZ()).func_185141_a(stack.func_77973_b())) {
            tracker.func_185145_a(stack.func_77973_b(), modifiedGun.general.rate);
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageShoot());
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            if (!MrCrayfishGunMod.proxy.canShoot()) {
                return new ActionResult(EnumActionResult.FAIL, (Object)heldItem);
            }
            if (ItemGun.hasAmmo(heldItem) || playerIn.field_71075_bZ.field_75098_d) {
                CooldownTracker tracker;
                if (playerIn.func_184587_cr()) {
                    return new ActionResult(EnumActionResult.FAIL, (Object)heldItem);
                }
                playerIn.func_184598_c(handIn);
                Gun modifiedGun = this.getModifiedGun(heldItem);
                if (!modifiedGun.general.auto && !(tracker = playerIn.func_184811_cZ()).func_185141_a(heldItem.func_77973_b())) {
                    tracker.func_185145_a(heldItem.func_77973_b(), modifiedGun.general.rate);
                    PacketHandler.INSTANCE.sendToServer((IMessage)new MessageShoot());
                }
            } else {
                MrCrayfishGunMod.proxy.playClientSound(SoundEvents.field_187750_dc);
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)heldItem);
    }

    public static void fire(World worldIn, EntityPlayer playerIn, ItemStack heldItem) {
        NBTTagCompound tag;
        SoundEvent event;
        if (worldIn.field_72995_K) {
            return;
        }
        ItemGun item = (ItemGun)heldItem.func_77973_b();
        if (CommonEvents.getCooldownTracker(playerIn.func_110124_au()).func_185141_a((Item)item)) {
            MrCrayfishGunMod.logger.info(playerIn.func_70005_c_() + "(" + playerIn.func_110124_au() + ") tried to fire before cooldown finished or server is lagging?");
            return;
        }
        if (((Boolean)playerIn.func_184212_Q().func_187225_a(CommonEvents.RELOADING)).booleanValue()) {
            playerIn.func_184212_Q().func_187227_b(CommonEvents.RELOADING, (Object)false);
        }
        boolean silenced = Gun.getAttachment(IAttachment.Type.BARREL, heldItem).func_77973_b() == ModGuns.SILENCER;
        Gun modifiedGun = item.getModifiedGun(heldItem);
        if (!modifiedGun.general.alwaysSpread && modifiedGun.general.spread > 0.0f) {
            SpreadHandler.getSpreadTracker(playerIn.func_110124_au()).update(item);
        }
        for (int i = 0; i < modifiedGun.general.projectileAmount; ++i) {
            ProjectileFactory factory = AmmoRegistry.getInstance().getFactory(modifiedGun.projectile.item);
            EntityProjectile bullet = factory.create(worldIn, (EntityLivingBase)playerIn, item, modifiedGun);
            bullet.setWeapon(heldItem);
            bullet.setAdditionalDamage(ItemGun.getAdditionalDamage(heldItem));
            if (silenced) {
                bullet.setDamageModifier(0.75f);
            }
            worldIn.func_72838_d((Entity)bullet);
            if (modifiedGun.projectile.visible) continue;
            MessageBullet messageBullet = new MessageBullet(bullet.func_145782_y(), bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, bullet.field_70159_w, bullet.field_70181_x, bullet.field_70179_y, modifiedGun.projectile.trailColor, modifiedGun.projectile.trailLengthMultiplier);
            PacketHandler.INSTANCE.sendToAllAround((IMessage)messageBullet, new NetworkRegistry.TargetPoint(playerIn.field_71093_bK, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, GunConfig.SERVER.network.projectileTrackingRange));
            PacketHandler.INSTANCE.sendTo((IMessage)messageBullet, (EntityPlayerMP)playerIn);
        }
        if (GunConfig.SERVER.aggroMobs.enabled) {
            double r = silenced ? GunConfig.SERVER.aggroMobs.rangeSilenced : GunConfig.SERVER.aggroMobs.rangeUnsilenced;
            double x = playerIn.field_70165_t + 0.5;
            double y = playerIn.field_70163_u + 0.5;
            double z = playerIn.field_70161_v + 0.5;
            AxisAlignedBB box = new AxisAlignedBB(x - r, y - r, z - r, x + r, y + r, z + r);
            r *= r;
            for (EntityLivingBase entity : playerIn.field_70170_p.func_175647_a(EntityLivingBase.class, box, NOT_AGGRO_EXEMPT)) {
                double dx = x - entity.field_70165_t;
                double dy = y - entity.field_70163_u;
                double dz = z - entity.field_70161_v;
                if (!(dx * dx + dy * dy + dz * dz <= r)) continue;
                entity.func_70604_c((EntityLivingBase)(GunConfig.SERVER.aggroMobs.angerHostileMobs ? playerIn : entity));
            }
        }
        if (silenced) {
            String silencedSound = modifiedGun.sounds.getSilencedFire(modifiedGun);
            event = ModSounds.getSound(silencedSound);
            if (event == null) {
                event = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(silencedSound));
            }
            if (event != null) {
                worldIn.func_184133_a(null, playerIn.func_180425_c(), event, SoundCategory.HOSTILE, 1.0f, 0.8f + field_77697_d.nextFloat() * 0.2f);
            }
        } else {
            String fireSound = modifiedGun.sounds.getFire(modifiedGun);
            event = ModSounds.getSound(fireSound);
            if (event == null) {
                event = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(fireSound));
            }
            if (event != null) {
                worldIn.func_184133_a(null, playerIn.func_180425_c(), event, SoundCategory.HOSTILE, 5.0f, 0.8f + field_77697_d.nextFloat() * 0.2f);
            }
        }
        if (modifiedGun.display.flash != null) {
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageMuzzleFlash(), (EntityPlayerMP)playerIn);
        }
        if (!playerIn.field_71075_bZ.field_75098_d && !(tag = ItemStackUtil.createTagCompound(heldItem)).func_74767_n("IgnoreAmmo")) {
            tag.func_74768_a("AmmoCount", Math.max(0, tag.func_74762_e("AmmoCount") - 1));
        }
        CommonEvents.getCooldownTracker(playerIn.func_110124_au()).func_185145_a((Item)item, modifiedGun.general.rate);
    }

    private static float getAdditionalDamage(ItemStack gunStack) {
        NBTTagCompound tag = ItemStackUtil.createTagCompound(gunStack);
        return tag.func_74760_g("AdditionalDamage");
    }

    public static ItemStack findAmmo(EntityPlayer player, ResourceLocation id) {
        if (player.field_71075_bZ.field_75098_d) {
            ItemAmmo ammo = AmmoRegistry.getInstance().getAmmo(id);
            return ammo != null ? new ItemStack((Item)ammo, 64) : ItemStack.field_190927_a;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!ItemGun.isAmmo(stack, id)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private static boolean isAmmo(ItemStack stack, ResourceLocation id) {
        return stack != null && stack.func_77973_b().getRegistryName().equals((Object)id);
    }

    public static boolean hasAmmo(ItemStack gunStack) {
        NBTTagCompound tag = ItemStackUtil.createTagCompound(gunStack);
        return tag.func_74767_n("IgnoreAmmo") || tag.func_74762_e("AmmoCount") > 0;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this);
            ItemStackUtil.createTagCompound(stack).func_74768_a("AmmoCount", this.gun.general.maxAmmo);
            items.add((Object)stack);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        NBTTagCompound tagCompound = ItemStackUtil.createTagCompound(stack);
        return !tagCompound.func_74767_n("IgnoreAmmo") && tagCompound.func_74762_e("AmmoCount") != this.gun.general.maxAmmo;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        NBTTagCompound tagCompound = ItemStackUtil.createTagCompound(stack);
        return 1.0 - (double)tagCompound.func_74762_e("AmmoCount") / (double)this.gun.general.maxAmmo;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return Color.CYAN.getRGB();
    }

    public Gun getModifiedGun(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_150297_b("Gun", 10)) {
            Gun gunCopy = this.gun.copy();
            gunCopy.deserializeNBT(tagCompound.func_74775_l("Gun"));
            return gunCopy;
        }
        return this.gun;
    }
}

