/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.item;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.mrcrayfish.guns.MrCrayfishGunMod;
import com.mrcrayfish.guns.item.ItemGun;
import com.mrcrayfish.guns.object.Gun;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

@Beta
public class GunRegistry {
    private static final Type GUN_TYPE = new TypeToken<Gun>(){}.getType();
    private static final Type RESOURCE_LOCATION_TYPE = new TypeToken<ResourceLocation>(){}.getType();
    private static GunRegistry instance = null;
    private final Map<ResourceLocation, ItemGun> GUNS = new HashMap<ResourceLocation, ItemGun>();

    public static GunRegistry getInstance() {
        if (instance == null) {
            instance = new GunRegistry();
        }
        return instance;
    }

    void register(ItemGun gun) {
        this.GUNS.put(Objects.requireNonNull(gun.getRegistryName()), gun);
        GunRegistry.loadProperties(gun);
    }

    @Nullable
    public ItemGun getGun(ResourceLocation id) {
        return this.GUNS.get(id);
    }

    public Map<ResourceLocation, ItemGun> getGuns() {
        return ImmutableMap.copyOf(this.GUNS);
    }

    private static void loadProperties(ItemGun itemGun) {
        ResourceLocation id = Objects.requireNonNull(itemGun.getRegistryName());
        File configFolder = new File(new File("."), "config/" + id.func_110624_b() + "/guns/");
        configFolder.mkdirs();
        Gun gun = null;
        String assetsFile = String.format("/assets/%s/guns/%s.json", id.func_110624_b(), id.func_110623_a());
        try (InputStreamReader reader = new InputStreamReader(GunRegistry.class.getResourceAsStream(assetsFile));){
            GsonBuilder builder = new GsonBuilder();
            builder.registerTypeAdapter(RESOURCE_LOCATION_TYPE, (Object)new Gun.ResourceLocationDeserializer());
            Gson gson = builder.create();
            gun = (Gun)gson.fromJson((Reader)reader, GUN_TYPE);
        }
        catch (IOException e) {
            MrCrayfishGunMod.logger.error("Failed to load gun json '" + itemGun.getRegistryName() + "'");
            e.printStackTrace();
            return;
        }
        try {
            GunRegistry.validateFields(gun);
        }
        catch (IllegalAccessException e) {
            MrCrayfishGunMod.logger.error("Failed to validate gun fields for '" + itemGun.getRegistryName() + "'");
            e.printStackTrace();
            return;
        }
        catch (InvalidObjectException e) {
            e.printStackTrace();
            throw new RuntimeException("Missing property in gun '" + gun.id + "'. Refer to exception above");
        }
        File gunFile = new File(configFolder, id.func_110623_a() + ".json");
        if (!gunFile.exists()) {
            GunRegistry.writeGunToFile(gun, gunFile);
        }
        try (InputStreamReader reader = new InputStreamReader(new FileInputStream(gunFile));){
            JsonElement parent = new JsonParser().parse((Reader)reader);
            GsonBuilder builder = new GsonBuilder();
            builder.registerTypeAdapter(GUN_TYPE, (Object)new Gun.Deserializer(gun));
            builder.registerTypeAdapter(RESOURCE_LOCATION_TYPE, (Object)new Gun.ResourceLocationDeserializer());
            Gson gson = builder.create();
            gun = (Gun)gson.fromJson(parent, GUN_TYPE);
            itemGun.setGun(gun);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        GunRegistry.writeGunToFile(gun, gunFile);
    }

    private static void writeGunToFile(Gun gun, File gunFile) {
        try {
            GsonBuilder builder = new GsonBuilder();
            builder.setPrettyPrinting();
            builder.registerTypeAdapter(GUN_TYPE, (Object)new Gun.Serializer());
            builder.registerTypeAdapter(RESOURCE_LOCATION_TYPE, (Object)new Gun.ResourceLocationSerializer());
            Gson gson = builder.create();
            FileOutputStream os = new FileOutputStream(gunFile);
            IOUtils.write((String)gson.toJson((Object)gun), (OutputStream)os, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static <T> boolean validateFields(@Nonnull T t) throws IllegalAccessException, InvalidObjectException {
        Field[] fields;
        for (Field field : fields = t.getClass().getDeclaredFields()) {
            if (field.getDeclaredAnnotation(Gun.Ignored.class) != null || field.getDeclaredAnnotation(Gun.Optional.class) != null) continue;
            if (field.get(t) == null) {
                throw new InvalidObjectException("Missing required property: " + field.getName());
            }
            if (field.getType().isPrimitive() || field.getType() == String.class || field.getType().isEnum()) continue;
            return GunRegistry.validateFields(field.get(t));
        }
        return true;
    }
}

